/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.sdk.http.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.jxdinfo.hussar.iam.common.api.exception.IamSdkHttpException;
import com.jxdinfo.hussar.iam.common.api.exception.IamSdkTokenException;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.sdk.api.enums.SdkUrlEnum;
import com.jxdinfo.hussar.iam.sdk.http.properties.IamSdkProperties;
import com.jxdinfo.hussar.iam.sdk.http.service.SdkTokenService;
import com.jxdinfo.hussar.iam.sdk.http.utils.HttpClientUtil;
import com.jxdinfo.hussar.iam.sdk.http.utils.JsonUtil;
import com.jxdinfo.hussar.iam.sdk.http.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import io.netty.util.internal.StringUtil;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkHttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(SdkHttpUtils.class);
    private static IamSdkProperties properties;
    private static SdkTokenService tokenService;
    private static TypeFactory typeFactory;

    public static <T> T postHttp(SdkUrlEnum urlEnum, Object request, Class<T> responseClass) {
        JavaType javaType = typeFactory.constructParametricType(IamSdkApiResponse.class, new Class[]{responseClass});
        IamSdkApiResponse iamApiResponse = SdkHttpUtils.doPostRequest(request, urlEnum, javaType);
        return (T)iamApiResponse.getData();
    }

    public static <T> T postHttp(SdkUrlEnum urlEnum, Object request, TypeReference<T> typeReference) {
        JavaType javaType = typeFactory.constructParametricType(IamSdkApiResponse.class, new JavaType[]{typeFactory.constructType(typeReference.getType())});
        IamSdkApiResponse iamApiResponse = SdkHttpUtils.doPostRequest(request, urlEnum, javaType);
        return (T)iamApiResponse.getData();
    }

    private static IamSdkApiResponse doPostRequest(Object request, SdkUrlEnum urlEnum, JavaType javaType) {
        IamSdkApiResponse iamApiResponse;
        String result;
        String token = SdkHttpUtils.getToken();
        String httpUrl = SdkHttpUtils.properties().getIamServer() + urlEnum.getUrl();
        if (SdkHttpUtils.properties().isOpenLog()) {
            logger.info("iam sdk http\u8bf7\u6c42\u63a5\u53e3\u540d:{}, url:{}, \u5165\u53c2\u4e3a:{}", new Object[]{urlEnum.getName(), urlEnum.getUrl(), JsonUtil.toJson(request)});
        }
        try {
            Response response = HttpClientUtil.getClient().newCall(SdkHttpUtils.postRequest(request, httpUrl, token)).execute();
            if (!response.isSuccessful()) {
                logger.error("iam sdk\u63a5\u53e3http\u8bf7\u6c42\u5931\u8d25, \u63a5\u53e3\u540d:{}, url:{}, message:{}", new Object[]{urlEnum.getName(), urlEnum.getUrl(), response.message()});
                throw new IamSdkHttpException("iam sdk\u63a5\u53e3http\u8bf7\u6c42\u5931\u8d25");
            }
            result = response.body().string();
        }
        catch (Exception e) {
            logger.error("iam sdk\u63a5\u53e3http\u8bf7\u6c42\u5f02\u5e38, \u63a5\u53e3\u540d:{}, url:{}", new Object[]{urlEnum.getName(), urlEnum.getUrl(), e});
            throw new IamSdkHttpException("iam sdk\u63a5\u53e3http\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
        }
        if (SdkHttpUtils.properties().isOpenLog()) {
            logger.info("iam sdk\u63a5\u53e3http\u8bf7\u6c42\u6210\u529f\uff0c\u63a5\u53e3\u540d:{}, url:{}, \u8fd4\u56de\u503c\u4e3a:{}", new Object[]{urlEnum.getName(), urlEnum.getUrl(), result});
        }
        try {
            iamApiResponse = (IamSdkApiResponse)JsonUtil.getInstance().readValue(result, javaType);
        }
        catch (Exception e) {
            throw new IamSdkHttpException("\u8fd4\u56de\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
        }
        if (!iamApiResponse.isSuccess()) {
            logger.error("iam sdk\u8bf7\u6c42\u5185\u90e8\u5904\u7406\u5931\u8d25, \u63a5\u53e3\u540d:{}, url:{}, message:{}", new Object[]{urlEnum.getName(), urlEnum.getUrl(), iamApiResponse.getMsg()});
            throw new IamSdkHttpException("\u7edf\u4e00\u6743\u9650sdk\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
        }
        return iamApiResponse;
    }

    private static Request postRequest(Object request, String url, String token) {
        RequestBody body;
        if (request == null) {
            body = RequestBody.create(null, (String)"");
        } else if (request instanceof String) {
            body = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)(request == null ? "" : request.toString()));
        } else {
            String paramJson = JsonUtil.toJson(request);
            body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)paramJson);
        }
        return new Request.Builder().url(url).addHeader("Authorization", token).addHeader("Client-Id", SdkHttpUtils.properties().getClientId()).post(body).build();
    }

    private static String getToken() {
        String token = (String)HussarCacheUtil.get((String)"iam_client_token", (Object)SdkHttpUtils.properties().getClientId());
        if (StringUtil.isNullOrEmpty((String)token) && StringUtil.isNullOrEmpty((String)(token = SdkHttpUtils.tokenService().getToken()))) {
            throw new IamSdkTokenException("\u83b7\u53d6token\u5931\u8d25");
        }
        return token;
    }

    public static IamSdkProperties properties() {
        if (properties == null) {
            properties = SpringContextUtil.getBean(IamSdkProperties.class);
        }
        return properties;
    }

    public static SdkTokenService tokenService() {
        if (tokenService == null) {
            tokenService = SpringContextUtil.getBean(SdkTokenService.class);
        }
        return tokenService;
    }

    static {
        typeFactory = TypeFactory.defaultInstance();
    }
}

