/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.functionmanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseResourceDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.FunctionChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class FunctionChangeNotify
extends AbstractDataChangeNotify<FunctionChangeDto> {
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;

    public String getApplicationCode(Object ... args) {
        SysFunctions function = (SysFunctions)args[0];
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)function.getApplicationId());
        return application.getAppCode();
    }

    public FunctionChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        SysFunctions function = (SysFunctions)args[0];
        if (HussarUtils.isEmpty((Object)function)) {
            return null;
        }
        FunctionChangeDto functionChangeDto = new FunctionChangeDto();
        functionChangeDto.setChangeType(dataChangeType);
        functionChangeDto.setFunctionId(function.getId());
        functionChangeDto.setFunctionCode(function.getFunctionCode());
        if (!HussarUtils.equals((Object)DataChangeType.DELETE, (Object)dataChangeType)) {
            List functionResources;
            functionChangeDto.setFunctionName(function.getFunctionName());
            functionChangeDto.setSeq(function.getSeq());
            Long resourceId = function.getDefaultResourceId();
            if (HussarUtils.isNotEmpty((Object)resourceId)) {
                functionChangeDto.setDefaultResourceId(resourceId);
                SysResources resource2 = (SysResources)this.sysResourcesService.getById((Serializable)resourceId);
                if (HussarUtils.isNotEmpty((Object)resource2)) {
                    functionChangeDto.setDefaultResourceCode(resource2.getResourceCode());
                }
            }
            Long moduleId = function.getFunctionModuleId();
            functionChangeDto.setParentModuleId(moduleId);
            SysFunctionModules module = (SysFunctionModules)this.sysFunctionModulesService.getById((Serializable)moduleId);
            if (HussarUtils.isNotEmpty((Object)module)) {
                functionChangeDto.setModuleCode(module.getFunctionModuleCode());
            }
            if (HussarUtils.isNotEmpty((Object)(functionResources = this.sysFunctionResourcesService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctionResources::getFunctionId, (Object)function.getId()))))) {
                List resourceIds = functionResources.stream().map(SysFunctionResources::getResourceId).collect(Collectors.toList());
                ArrayList baseResourceDtos = new ArrayList();
                List resources = this.sysResourcesService.listByIds(resourceIds);
                resources.forEach(resource -> {
                    BaseResourceDto dto = new BaseResourceDto();
                    dto.setResourceId(resource.getId());
                    dto.setResourceCode(resource.getResourceCode());
                    baseResourceDtos.add(dto);
                });
                functionChangeDto.setResources(baseResourceDtos);
            }
        }
        return functionChangeDto;
    }

    public NotifyType getNotifyType() {
        return NotifyType.FUNCTION_CHANGE;
    }
}

