/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.organmanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BasePostDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.OrganChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.iam.data.change.notify.server.dao.SyncStruNotifyMapper;
import com.jxdinfo.hussar.iam.sdk.api.model.SyncStru;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class OrganChangeNotify
extends AbstractDataChangeNotify<OrganChangeDto> {
    @Resource
    private ISysStruService struService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISysOfficeService officeService;
    @Resource
    private SyncStruNotifyMapper syncStruNotifyMapper;
    @Resource
    private ISysStruPostService sysStruPostService;

    public OrganChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        Long struId = (Long)args[0];
        SysOrgan organ = (SysOrgan)args[1];
        List sysStruPosts = (List)args[2];
        if (HussarUtils.isEmpty((Object)struId) || HussarUtils.isEmpty((Object)organ)) {
            return null;
        }
        ArrayList<BasePostDto> posts = new ArrayList<BasePostDto>();
        OrganChangeDto organChangeDTO = new OrganChangeDto();
        organChangeDTO.setChangeType(dataChangeType);
        organChangeDTO.setOrganId(organ.getId());
        organChangeDTO.setOrganCode(organ.getOrganCode());
        organChangeDTO.setStruId(struId);
        SyncStru syncStru = (SyncStru)this.syncStruNotifyMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SyncStru::getIamStruId, (Object)struId));
        if (HussarUtils.isNotEmpty((Object)syncStru)) {
            organChangeDTO.setChar1(syncStru.getStruId());
        }
        if (!DataChangeType.DELETE.equals((Object)dataChangeType)) {
            SysOrgan parentOrgan;
            SysStru stru = (SysStru)this.struService.getById((Serializable)struId);
            organChangeDTO.setParentOrganId(stru.getParentId());
            SysStru parentStru = (SysStru)this.struService.getById((Serializable)stru.getParentId());
            if (HussarUtils.isNotEmpty((Object)parentStru) && Objects.nonNull(parentOrgan = (SysOrgan)this.organService.getById((Serializable)parentStru.getOrganId()))) {
                organChangeDTO.setParentOrganCode(parentOrgan.getOrganCode());
            }
            organChangeDTO.setOrganFullCode(organ.getOrganFcode());
            organChangeDTO.setOrganType(organ.getOrganType());
            organChangeDTO.setOrganName(organ.getOrganName());
            organChangeDTO.setOrganFullName(organ.getOrganFname());
            organChangeDTO.setOrganShortName(organ.getShortName());
            organChangeDTO.setOrganAlias(stru.getOrganAlias());
            SysOffice office = (SysOffice)this.officeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
            if (HussarUtils.isNotEmpty((Object)office)) {
                organChangeDTO.setOfficeId(office.getId());
                organChangeDTO.setOrganDescription(office.getOfficeAlias());
                organChangeDTO.setOrganAddress(office.getOfficeAddress());
            }
            this.buildBasePostDTOList(sysStruPosts, posts);
            this.addAttributeToOrganChangeDTO(organ, stru, organChangeDTO);
            organChangeDTO.setPosts(posts);
            if (CollectionUtils.isEmpty((Collection)sysStruPosts)) {
                LambdaQueryWrapper sysPostLambdaQueryWrapper = new LambdaQueryWrapper();
                sysPostLambdaQueryWrapper.eq(SysStruPost::getStruId, (Object)struId);
                List sysStruPostList = this.sysStruPostService.list((Wrapper)sysPostLambdaQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)sysStruPostList)) {
                    this.buildBasePostDTOList(sysStruPostList, posts);
                    organChangeDTO.setPosts(posts);
                }
            }
        }
        return organChangeDTO;
    }

    public NotifyType getNotifyType() {
        return NotifyType.ORGAN_CHANGE;
    }

    private void buildBasePostDTOList(List<SysStruPost> sysStruPostList, List<BasePostDto> posts) {
        if (CollectionUtils.isEmpty(sysStruPostList)) {
            return;
        }
        sysStruPostList.stream().forEach(sysStruPost -> {
            BasePostDto basePostDTO = new BasePostDto();
            basePostDTO.setPostId(sysStruPost.getPostId());
            posts.add(basePostDTO);
        });
    }

    private void addAttributeToOrganChangeDTO(SysOrgan organ, SysStru stru, OrganChangeDto organChangeDTO) {
        if (Objects.nonNull(organ)) {
            organChangeDTO.setWorkspaceId(organ.getWorkplaceId());
            organChangeDTO.setBeginDate(organ.getBeginDate());
            organChangeDTO.setEndDate(organ.getEndDate());
            organChangeDTO.setParentOrganCode(organ.getParentTypeCode());
            organChangeDTO.setOrganProperty(organ.getOrganProperty());
            organChangeDTO.setValidTimeLimitType(organ.getValidTimeLimitType());
        }
        if (Objects.nonNull(stru)) {
            organChangeDTO.setPrincipalId(stru.getPrincipalId());
            organChangeDTO.setCorporationId(stru.getCorporationId());
            organChangeDTO.setStruLevel(stru.getStruLevel());
            organChangeDTO.setStruFid(stru.getStruFid());
            organChangeDTO.setStruSeq(stru.getStruSeq());
            organChangeDTO.setStruPath(stru.getStruPath());
            organChangeDTO.setStruOrder(stru.getStruOrder());
            organChangeDTO.setGlobalOrder(stru.getGlobalOrder());
            organChangeDTO.setIsLeaf(stru.getIsLeaf());
            organChangeDTO.setDepartmentId(stru.getDepartmentId());
            organChangeDTO.setStaffPosition(stru.getStaffPosition());
            organChangeDTO.setProvinceCode(stru.getProvinceCode());
        }
    }
}

