/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseResourceDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.RoleResourceChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class RoleResourceChangeNotify
extends AbstractDataChangeNotify<RoleResourceChangeDto> {
    @Resource
    private ISysResourcesService resourcesService;
    @Resource
    private ISysRolesService rolesService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysRoleResourceService roleResourceService;

    public RoleResourceChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        Long roleId = (Long)args[0];
        if (HussarUtils.isEmpty((Object)roleId)) {
            return null;
        }
        SysRoles role = (SysRoles)this.rolesService.getById((Serializable)roleId);
        if (HussarUtils.isEmpty((Object)role)) {
            return null;
        }
        RoleResourceChangeDto roleResourceChangeDTO = new RoleResourceChangeDto();
        roleResourceChangeDTO.setRoleId(roleId);
        roleResourceChangeDTO.setRoleCode(String.valueOf(role.getId()));
        List resourceIds = (List)args[1];
        if (HussarUtils.isNotEmpty((Object)resourceIds)) {
            List<BaseResourceDto> baseResourceDtoList = this.getBaseResource(resourceIds);
            roleResourceChangeDTO.setResources(baseResourceDtoList);
        } else {
            List roleResources = this.roleResourceService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getRoleId, (Object)roleId));
            List<Long> resourceIdList = roleResources.stream().map(SysRoleResource::getResourceId).distinct().collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(resourceIdList)) {
                List<BaseResourceDto> baseResourceDtoList = this.getBaseResource(resourceIdList);
                roleResourceChangeDTO.setResources(baseResourceDtoList);
            }
        }
        return roleResourceChangeDTO;
    }

    public String getApplicationCode(Object ... args) {
        Long roleId = (Long)args[0];
        SysRoles role = (SysRoles)this.rolesService.getById((Serializable)roleId);
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)role.getAppId());
        return application.getAppCode();
    }

    public NotifyType getNotifyType() {
        return NotifyType.ROLE_RESOURCE_CHANGE;
    }

    private List<BaseResourceDto> getBaseResource(List<Long> resourceIds) {
        ArrayList<BaseResourceDto> baseResourceDtoList = new ArrayList<BaseResourceDto>();
        this.resourcesService.listByIds(resourceIds).forEach(sysResources -> {
            BaseResourceDto baseResourceDTO = new BaseResourceDto();
            baseResourceDTO.setResourceId(sysResources.getId());
            baseResourceDTO.setResourceCode(sysResources.getResourceCode());
            baseResourceDtoList.add(baseResourceDTO);
        });
        return baseResourceDtoList;
    }
}

