/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.functionmanager;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.ModuleChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class FunctionModuleChangeNotify
extends AbstractDataChangeNotify<ModuleChangeDto> {
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;

    public String getApplicationCode(Object ... args) {
        SysFunctionModules functionModules = (SysFunctionModules)args[0];
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)functionModules.getApplicationId());
        return application.getAppCode();
    }

    public ModuleChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        SysFunctionModules functionModules = (SysFunctionModules)args[0];
        if (HussarUtils.isEmpty((Object)functionModules)) {
            return null;
        }
        ModuleChangeDto moduleChangeDto = new ModuleChangeDto();
        moduleChangeDto.setModuleId(functionModules.getId());
        moduleChangeDto.setModuleCode(functionModules.getFunctionModuleCode());
        if (!HussarUtils.equals((Object)DataChangeType.DELETE, (Object)dataChangeType)) {
            SysFunctionModules parentModule = (SysFunctionModules)this.sysFunctionModulesService.getById((Serializable)functionModules.getParentModuleId());
            if (HussarUtils.isNotEmpty((Object)parentModule)) {
                moduleChangeDto.setParentModuleCode(parentModule.getFunctionModuleCode());
            }
            moduleChangeDto.setModuleName(functionModules.getFunctionModuleName());
            moduleChangeDto.setParentModuleId(functionModules.getParentModuleId());
            moduleChangeDto.setSeq(functionModules.getSeq());
        }
        return moduleChangeDto;
    }

    public NotifyType getNotifyType() {
        return NotifyType.FUNCTION_MODULE_CHANGE;
    }
}

