/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.usermanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseOrganDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BasePostDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.UserChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.iam.data.change.notify.server.dao.SyncUserNotifyMapper;
import com.jxdinfo.hussar.iam.data.change.notify.server.dao.UserManagerMapper;
import com.jxdinfo.hussar.iam.sdk.api.model.SyncUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class UserChangeNotify
extends AbstractDataChangeNotify<UserChangeDto> {
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private UserManagerMapper userManagerMapper;
    @Resource
    private SyncUserNotifyMapper syncUserNotifyMapper;

    public UserChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        SysUsers user = (SysUsers)args[0];
        if (HussarUtils.isEmpty((Object)user)) {
            return null;
        }
        UserChangeDto userChangeDto = new UserChangeDto();
        userChangeDto.setUserId(user.getId());
        userChangeDto.setUserAccount(user.getUserAccount());
        SyncUser syncUser = (SyncUser)this.syncUserNotifyMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SyncUser::getIamUserId, (Object)user.getId()));
        if (HussarUtils.isNotEmpty((Object)syncUser)) {
            userChangeDto.setChar1(syncUser.getUserId());
        }
        if (!HussarUtils.equals((Object)DataChangeType.DELETE, (Object)dataChangeType)) {
            SysStaff staff;
            userChangeDto.setAccountStatus(user.getAccountStatus());
            userChangeDto.setMobile(user.getMobile());
            userChangeDto.setTelephone(user.getTelephone());
            userChangeDto.setUserName(user.getUserName());
            userChangeDto.setWeChat(user.getWeChat());
            userChangeDto.seteMail(user.geteMail());
            userChangeDto.setMaxSessions(user.getMaxSessions());
            Long staffId = user.getEmployeeId();
            if (HussarUtils.isNotEmpty((Object)staffId) && HussarUtils.isNotEmpty((Object)(staff = (SysStaff)this.sysStaffService.getById((Serializable)staffId)))) {
                userChangeDto.setStaffCode(staff.getStaffCode());
            }
            List<BaseOrganDto> baseOrganDtos = this.userManagerMapper.getOrganByUserId(user.getId());
            List<BasePostDto> basePostDtos = this.userManagerMapper.getPostByUserId(user.getId());
            userChangeDto.setOrgans(baseOrganDtos);
            userChangeDto.setPosts(basePostDtos);
        }
        return userChangeDto;
    }

    public NotifyType getNotifyType() {
        return NotifyType.USER_CHANGE;
    }
}

