/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.resourcemanager;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.ModuleChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ResourceModuleChangeNotify
extends AbstractDataChangeNotify<ModuleChangeDto> {
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;

    public String getApplicationCode(Object ... args) {
        SysResourceModules resourceModules = (SysResourceModules)args[0];
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)resourceModules.getApplicationId());
        return application.getAppCode();
    }

    public ModuleChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        SysResourceModules resourceModules = (SysResourceModules)args[0];
        if (HussarUtils.isEmpty((Object)resourceModules)) {
            return null;
        }
        ModuleChangeDto moduleChangeDto = new ModuleChangeDto();
        moduleChangeDto.setModuleId(resourceModules.getId());
        moduleChangeDto.setModuleCode(resourceModules.getModuleCode());
        if (!HussarUtils.equals((Object)DataChangeType.DELETE, (Object)dataChangeType)) {
            SysResourceModules parentModule = (SysResourceModules)this.sysResourceMosulesService.getById((Serializable)resourceModules.getParentModuleId());
            if (HussarUtils.isNotEmpty((Object)parentModule)) {
                moduleChangeDto.setParentModuleCode(parentModule.getModuleCode());
            }
            moduleChangeDto.setModuleName(resourceModules.getModuleName());
            moduleChangeDto.setParentModuleId(resourceModules.getParentModuleId());
            moduleChangeDto.setSeq(resourceModules.getSeq());
        }
        return moduleChangeDto;
    }

    public NotifyType getNotifyType() {
        return NotifyType.RESOURCE_MODULE_CHANGE;
    }
}

