/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.resourcemanager;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseModuleDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseResourceDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.ResourceModuleBatchDeleteDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ResourceModuleBatchDeleteChangeNotify
extends AbstractDataChangeNotify<ResourceModuleBatchDeleteDto> {
    @Resource
    private ISysApplicationService applicationService;

    public ResourceModuleBatchDeleteDto convert(DataChangeType dataChangeType, Object ... args) {
        List resourceModules = (List)args[0];
        if (HussarUtils.isEmpty((Object)resourceModules)) {
            return null;
        }
        ResourceModuleBatchDeleteDto moduleBatchDeleteDto = new ResourceModuleBatchDeleteDto();
        ArrayList moduleDtos = new ArrayList();
        resourceModules.forEach(module -> {
            BaseModuleDto dto = new BaseModuleDto();
            dto.setModuleId(module.getId());
            dto.setModuleCode(module.getModuleCode());
            moduleDtos.add(dto);
        });
        moduleBatchDeleteDto.setModules(moduleDtos);
        List sysResources = (List)args[1];
        if (HussarUtils.isNotEmpty((Object)sysResources)) {
            ArrayList resourceDTOS = new ArrayList();
            sysResources.forEach(resource -> {
                BaseResourceDto dto = new BaseResourceDto();
                dto.setResourceId(resource.getId());
                dto.setResourceCode(resource.getResourceCode());
                resourceDTOS.add(dto);
            });
            moduleBatchDeleteDto.setResources(resourceDTOS);
        }
        return moduleBatchDeleteDto;
    }

    public String getApplicationCode(Object ... args) {
        List resourceModules = (List)args[0];
        if (HussarUtils.isEmpty((Object)resourceModules)) {
            return null;
        }
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)((SysResourceModules)resourceModules.get(0)).getApplicationId());
        return application.getAppCode();
    }

    public NotifyType getNotifyType() {
        return NotifyType.RESOURCE_MODULE_BATCH_DELETE;
    }
}

