/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseUserDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.RoleUserChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class RoleUserChangeNotify
extends AbstractDataChangeNotify<RoleUserChangeDto> {
    @Resource
    private ISysUsersService usersService;
    @Resource
    private ISysRolesService rolesService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysUserRoleService userRoleService;

    public RoleUserChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        Long roleId = (Long)args[0];
        if (HussarUtils.isEmpty((Object)roleId)) {
            return null;
        }
        SysRoles role = (SysRoles)this.rolesService.getById((Serializable)roleId);
        if (HussarUtils.isEmpty((Object)role)) {
            return null;
        }
        RoleUserChangeDto roleUserChangeDTO = new RoleUserChangeDto();
        roleUserChangeDTO.setRoleId(roleId);
        roleUserChangeDTO.setRoleCode(String.valueOf(role.getId()));
        List userIds = (List)args[1];
        if (HussarUtils.isNotEmpty((Object)userIds)) {
            List<BaseUserDto> users = this.getBaseUser(userIds);
            roleUserChangeDTO.setUsers(users);
        } else {
            List userRoles = this.userRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).eq(SysUserRole::getAdminOption, (Object)"1"));
            List<Long> userIdList = userRoles.stream().map(SysUserRole::getUserId).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(userIdList)) {
                List<BaseUserDto> users = this.getBaseUser(userIdList);
                roleUserChangeDTO.setUsers(users);
            }
        }
        return roleUserChangeDTO;
    }

    public String getApplicationCode(Object ... args) {
        Long roleId = (Long)args[0];
        SysRoles role = (SysRoles)this.rolesService.getById((Serializable)roleId);
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)role.getAppId());
        return application.getAppCode();
    }

    public NotifyType getNotifyType() {
        return NotifyType.ROLE_USER_CHANGE;
    }

    private List<BaseUserDto> getBaseUser(List<Long> userIds) {
        ArrayList<BaseUserDto> users = new ArrayList<BaseUserDto>();
        this.usersService.listByIds(userIds).forEach(sysUsers -> {
            BaseUserDto baseUserDTO = new BaseUserDto();
            baseUserDTO.setUserId(sysUsers.getId());
            baseUserDTO.setUserAccount(sysUsers.getUserAccount());
            users.add(baseUserDTO);
        });
        return users;
    }
}

