/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.resourcemanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseRoleDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.ResourceRoleChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ResourceRoleChangeNotify
extends AbstractDataChangeNotify<ResourceRoleChangeDto> {
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;

    public String getApplicationCode(Object ... args) {
        Long resourceId = (Long)args[0];
        if (HussarUtils.isEmpty((Object)resourceId)) {
            return null;
        }
        SysResources resource = (SysResources)this.sysResourcesService.getById((Serializable)resourceId);
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)resource.getApplicationId());
        return application.getAppCode();
    }

    public ResourceRoleChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        List roleIds;
        List roles;
        Long resourceId = (Long)args[0];
        if (HussarUtils.isEmpty((Object)resourceId)) {
            return null;
        }
        SysResources resource = (SysResources)this.sysResourcesService.getById((Serializable)resourceId);
        if (HussarUtils.isEmpty((Object)resource)) {
            return null;
        }
        ResourceRoleChangeDto resourceRoleChangeDto = new ResourceRoleChangeDto();
        resourceRoleChangeDto.setResourceId(resource.getId());
        resourceRoleChangeDto.setResourceCode(resource.getResourceCode());
        List roleResources = this.sysRoleResourceService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resourceId));
        if (HussarUtils.isNotEmpty((Object)roleResources) && HussarUtils.isNotEmpty((Object)(roles = this.sysRolesService.listByIds(roleIds = roleResources.stream().map(SysRoleResource::getId).distinct().collect(Collectors.toList()))))) {
            ArrayList<BaseRoleDto> roleDTOS = new ArrayList<BaseRoleDto>();
            for (SysRoles role : roles) {
                BaseRoleDto dto = new BaseRoleDto();
                dto.setRoleCode(role.getId().toString());
                dto.setRoleId(role.getId());
                roleDTOS.add(dto);
            }
            resourceRoleChangeDto.setRoles(roleDTOS);
        }
        return resourceRoleChangeDto;
    }

    public NotifyType getNotifyType() {
        return NotifyType.RESOURCE_ROLE_CHANGE;
    }
}

