/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.postmanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseOrganDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseUserDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.PostChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class PostChangeNotify
extends AbstractDataChangeNotify<PostChangeDto> {
    @Resource
    private ISysStruService struService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private ISysStruPostService sysStruPostService;
    @Resource
    private ISysUserPostService sysUserPostService;
    @Resource
    private IHussarBasePostService postService;

    public PostChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        SysPost post = (SysPost)args[0];
        if (HussarUtils.isEmpty((Object)post)) {
            return null;
        }
        PostChangeDto postChangeDTO = new PostChangeDto();
        postChangeDTO.setChangeType(dataChangeType);
        postChangeDTO.setPostId(post.getId());
        postChangeDTO.setPostCode(post.getPostCode());
        if (!DataChangeType.DELETE.equals((Object)dataChangeType)) {
            List partUserPosts;
            List<Long> partUserIdList;
            List userPosts;
            List<Long> userIdList;
            postChangeDTO.setPostName(post.getPostName());
            postChangeDTO.setOrganType(post.getOrganTypeCode());
            postChangeDTO.setDesc(post.getPostDesc());
            List struPosts = this.sysStruPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)post.getId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            List<Long> struIdList = struPosts.stream().map(SysStruPost::getStruId).distinct().collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(struIdList)) {
                List<BaseOrganDto> organs = this.getBaseOrgan(struIdList);
                postChangeDTO.setOrgans(organs);
            }
            if (HussarUtils.isNotEmpty(userIdList = (userPosts = this.sysUserPostService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)post.getId())).eq(SysUserPost::getRelateType, (Object)"0")).eq(HussarDelflagEntity::getDelFlag, (Object)"0"))).stream().map(SysUserPost::getUserId).collect(Collectors.toList()))) {
                List<BaseUserDto> users = this.getBaseUser(userIdList);
                postChangeDTO.setUsers(users);
            }
            if (HussarUtils.isNotEmpty(partUserIdList = (partUserPosts = this.sysUserPostService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)post.getId())).eq(SysUserPost::getRelateType, (Object)"1")).eq(HussarDelflagEntity::getDelFlag, (Object)"0"))).stream().map(SysUserPost::getUserId).collect(Collectors.toList()))) {
                List<BaseUserDto> users = this.getBaseUser(partUserIdList);
                postChangeDTO.setPartUsers(users);
            }
        }
        return postChangeDTO;
    }

    public NotifyType getNotifyType() {
        return NotifyType.POST_CHANGE;
    }

    private List<BaseOrganDto> getBaseOrgan(List<Long> struIds) {
        ArrayList<BaseOrganDto> organs = new ArrayList<BaseOrganDto>();
        List strus = this.struService.listByIds(struIds);
        List organIds = strus.stream().map(SysStru::getOrganId).collect(Collectors.toList());
        Map<Long, Long> map = strus.stream().collect(Collectors.toMap(SysStru::getId, SysStru::getOrganId));
        Map<Object, Object> organCodeMap = new HashMap();
        if (HussarUtils.isNotEmpty(organIds)) {
            List sysOrgans = this.organService.listByIds(organIds);
            organCodeMap = sysOrgans.stream().collect(Collectors.toMap(SysOrgan::getId, SysOrgan::getOrganCode));
        }
        for (Long struId : struIds) {
            BaseOrganDto baseOrganDTO = new BaseOrganDto();
            baseOrganDTO.setOrganId(struId);
            Long organId = map.get(struId);
            if (HussarUtils.isNotEmpty((Object)organId)) {
                baseOrganDTO.setOrganCode((String)organCodeMap.get(organId));
            }
            organs.add(baseOrganDTO);
        }
        return organs;
    }

    private List<BaseUserDto> getBaseUser(List<Long> userIds) {
        ArrayList<BaseUserDto> users = new ArrayList<BaseUserDto>();
        this.usersService.listByIds(userIds).forEach(sysUsers -> {
            BaseUserDto baseUserDTO = new BaseUserDto();
            baseUserDTO.setUserId(sysUsers.getId());
            baseUserDTO.setUserAccount(sysUsers.getUserAccount());
            users.add(baseUserDTO);
        });
        return users;
    }
}

