/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.staffmanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseOrganDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.StaffChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.iam.data.change.notify.server.dao.StaffManagerMapper;
import com.jxdinfo.hussar.iam.data.change.notify.server.dao.SyncStruNotifyMapper;
import com.jxdinfo.hussar.iam.sdk.api.model.SyncStru;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class StaffChangeNotify
extends AbstractDataChangeNotify<StaffChangeDto> {
    @Resource
    private StaffManagerMapper staffManagerMapper;
    @Resource
    private SyncStruNotifyMapper syncStruNotifyMapper;

    public StaffChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        SysStaff staff = (SysStaff)args[0];
        if (HussarUtils.isEmpty((Object)staff) || HussarUtils.isEmpty((Object)staff)) {
            return null;
        }
        StaffChangeDto staffChangeDTO = new StaffChangeDto();
        staffChangeDTO.setStaffId(staff.getId());
        staffChangeDTO.setStaffCode(staff.getStaffCode());
        staffChangeDTO.setChangeType(dataChangeType);
        if (!DataChangeType.DELETE.equals((Object)dataChangeType)) {
            BeanUtil.copyProperties((Object)staff, (Object)staffChangeDTO);
            staffChangeDTO.setStaffName(staff.getName());
            List<BaseOrganDto> baseOrganDtos = this.staffManagerMapper.searchOrganizationById(staff.getId());
            List srtuIds = baseOrganDtos.stream().map(BaseOrganDto::getOrganId).distinct().collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(srtuIds)) {
                LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SyncStru::getIamStruId, srtuIds);
                List syncStrus = this.syncStruNotifyMapper.selectList((Wrapper)wrapper);
                Map<Long, String> map = syncStrus.stream().collect(Collectors.toMap(SyncStru::getIamStruId, SyncStru::getStruId));
                for (BaseOrganDto organDto : baseOrganDtos) {
                    String struIdString = map.get(organDto.getOrganId());
                    if (!HussarUtils.isNotEmpty((Object)struIdString)) continue;
                    organDto.setChar1(struIdString);
                }
            }
            staffChangeDTO.setOrgans(baseOrganDtos);
        }
        return staffChangeDTO;
    }

    public NotifyType getNotifyType() {
        return NotifyType.STAFF_CHANGE;
    }
}

