/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BasePostDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.RolePostChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class RolePostChangeNotify
extends AbstractDataChangeNotify<RolePostChangeDto> {
    @Resource
    private IHussarBasePostService hussarBasePostService;
    @Resource
    private ISysRolesService rolesService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysPostRoleService sysPostRoleService;

    public RolePostChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        Long roleId = (Long)args[0];
        if (HussarUtils.isEmpty((Object)roleId)) {
            return null;
        }
        SysRoles role = (SysRoles)this.rolesService.getById((Serializable)roleId);
        if (HussarUtils.isEmpty((Object)role)) {
            return null;
        }
        RolePostChangeDto rolePostChangeDTO = new RolePostChangeDto();
        rolePostChangeDTO.setRoleId(roleId);
        rolePostChangeDTO.setRoleCode(String.valueOf(role.getId()));
        List postIds = (List)args[1];
        if (HussarUtils.isNotEmpty((Object)postIds)) {
            List<BasePostDto> basePostDtoList = this.getBasePost(postIds);
            rolePostChangeDTO.setPosts(basePostDtoList);
        } else {
            List postRoles = this.sysPostRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRole::getRoleId, (Object)roleId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            List<Long> postIdList = postRoles.stream().map(SysPostRole::getPostId).distinct().collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(postIdList)) {
                List<BasePostDto> basePostDtoList = this.getBasePost(postIdList);
                rolePostChangeDTO.setPosts(basePostDtoList);
            }
        }
        return rolePostChangeDTO;
    }

    public String getApplicationCode(Object ... args) {
        Long roleId = (Long)args[0];
        SysRoles role = (SysRoles)this.rolesService.getById((Serializable)roleId);
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)role.getAppId());
        return application.getAppCode();
    }

    public NotifyType getNotifyType() {
        return NotifyType.ROLE_POST_CHANGE;
    }

    private List<BasePostDto> getBasePost(List<Long> postIds) {
        ArrayList<BasePostDto> basePostDtoList = new ArrayList<BasePostDto>();
        this.hussarBasePostService.listByIds(postIds).forEach(sysPost -> {
            BasePostDto basePostDTO = new BasePostDto();
            basePostDTO.setPostId(sysPost.getId());
            basePostDTO.setPostCode(sysPost.getPostCode());
            basePostDtoList.add(basePostDTO);
        });
        return basePostDtoList;
    }
}

