/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.iam.data.change.notify.api.service.AbstractDataChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.BaseOrganDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.dto.RoleOrganChangeDto;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class RoleOrganChangeNotify
extends AbstractDataChangeNotify<RoleOrganChangeDto> {
    @Resource
    private ISysRolesService rolesService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysStruService struService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISysStruRoleService sysStruRoleService;

    public RoleOrganChangeDto convert(DataChangeType dataChangeType, Object ... args) {
        Long roleId = (Long)args[0];
        if (HussarUtils.isEmpty((Object)roleId)) {
            return null;
        }
        SysRoles role = (SysRoles)this.rolesService.getById((Serializable)roleId);
        if (HussarUtils.isEmpty((Object)role)) {
            return null;
        }
        RoleOrganChangeDto roleOrganChangeDTO = new RoleOrganChangeDto();
        roleOrganChangeDTO.setRoleId(roleId);
        roleOrganChangeDTO.setRoleCode(String.valueOf(role.getId()));
        List struIds = (List)args[1];
        if (HussarUtils.isNotEmpty((Object)struIds)) {
            List<BaseOrganDto> organs = this.getBaseOrgan(struIds);
            roleOrganChangeDTO.setOrgans(organs);
        } else {
            List struRoles = this.sysStruRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRole::getGrantedRole, (Object)roleId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            List<Long> struIdList = struRoles.stream().map(SysStruRole::getStruId).distinct().collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(struIdList)) {
                List<BaseOrganDto> organs = this.getBaseOrgan(struIdList);
                roleOrganChangeDTO.setOrgans(organs);
            }
        }
        return roleOrganChangeDTO;
    }

    public String getApplicationCode(Object ... args) {
        Long roleId = (Long)args[0];
        SysRoles role = (SysRoles)this.rolesService.getById((Serializable)roleId);
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)role.getAppId());
        return application.getAppCode();
    }

    public NotifyType getNotifyType() {
        return NotifyType.ROLE_ORGAN_CHANGE;
    }

    private List<BaseOrganDto> getBaseOrgan(List<Long> struIds) {
        ArrayList<BaseOrganDto> organs = new ArrayList<BaseOrganDto>();
        List strus = this.struService.listByIds(struIds);
        List organIds = strus.stream().map(SysStru::getOrganId).collect(Collectors.toList());
        Map<Long, Long> map = strus.stream().collect(Collectors.toMap(SysStru::getId, SysStru::getOrganId));
        Map<Object, Object> organCodeMap = new HashMap();
        if (HussarUtils.isNotEmpty(organIds)) {
            List sysOrgans = this.organService.listByIds(organIds);
            organCodeMap = sysOrgans.stream().collect(Collectors.toMap(SysOrgan::getId, SysOrgan::getOrganCode));
        }
        for (Long struId : struIds) {
            BaseOrganDto baseOrganDTO = new BaseOrganDto();
            baseOrganDTO.setOrganId(struId);
            Long organId = map.get(struId);
            if (HussarUtils.isNotEmpty((Object)organId)) {
                baseOrganDTO.setOrganCode((String)organCodeMap.get(organId));
            }
            organs.add(baseOrganDTO);
        }
        return organs;
    }
}

