/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.common.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.NullSerializer;
import com.jxdinfo.hussar.iam.common.api.enums.SdkResultCode;
import java.io.Serializable;

public class IamSdkApiResponse<T>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private int code;
    private boolean success;
    @JsonSerialize(nullsUsing=NullSerializer.class)
    private T data;
    private String msg;

    public IamSdkApiResponse() {
    }

    private IamSdkApiResponse(int code, T data, String msg) {
        this.code = code;
        this.data = data;
        this.msg = msg;
        this.success = SdkResultCode.SUCCESS.getCode() == code;
    }

    private static <T> IamSdkApiResponse<T> createInstance(T data, int code, String msg) {
        IamSdkApiResponse<T> apiResponse = new IamSdkApiResponse<T>();
        apiResponse.setCode(code);
        apiResponse.setData(data);
        apiResponse.setMsg(msg);
        apiResponse.setSuccess(SdkResultCode.SUCCESS.getCode() == code);
        return apiResponse;
    }

    private static <T> IamSdkApiResponse<T> createInstance(T data, SdkResultCode resultCode) {
        IamSdkApiResponse<T> apiResponse = new IamSdkApiResponse<T>();
        apiResponse.setCode(resultCode.getCode());
        apiResponse.setData(data);
        apiResponse.setMsg(resultCode.getMessage());
        apiResponse.setSuccess(SdkResultCode.SUCCESS.getCode() == resultCode.getCode());
        return apiResponse;
    }

    public static <T> IamSdkApiResponse<T> success(T data, String msg) {
        return IamSdkApiResponse.createInstance(data, SdkResultCode.SUCCESS.getCode(), msg);
    }

    public static <T> IamSdkApiResponse<T> success(T data) {
        return IamSdkApiResponse.createInstance(data, SdkResultCode.SUCCESS);
    }

    public static <T> IamSdkApiResponse<T> success(int code, T data, String msg) {
        return IamSdkApiResponse.createInstance(data, code, msg);
    }

    public static <T> IamSdkApiResponse<T> success(String msg) {
        return IamSdkApiResponse.createInstance(null, SdkResultCode.SUCCESS.getCode(), msg);
    }

    public static <T> IamSdkApiResponse<T> success() {
        return IamSdkApiResponse.createInstance(null, SdkResultCode.SUCCESS.getCode(), SdkResultCode.SUCCESS.getMessage());
    }

    public static <T> IamSdkApiResponse<T> success(int code, String msg) {
        return IamSdkApiResponse.createInstance(null, code, msg);
    }

    public static <T> IamSdkApiResponse<T> success(SdkResultCode resultCode) {
        return IamSdkApiResponse.createInstance(null, resultCode);
    }

    public static <T> IamSdkApiResponse<T> success(SdkResultCode resultCode, String msg) {
        return IamSdkApiResponse.createInstance(null, resultCode.getCode(), msg);
    }

    public static <T> IamSdkApiResponse<T> fail(String msg) {
        return IamSdkApiResponse.createInstance(null, SdkResultCode.FAILURE.getCode(), msg);
    }

    public static <T> IamSdkApiResponse<T> fail(int code, T data, String msg) {
        return IamSdkApiResponse.createInstance(data, code, msg);
    }

    public static <T> IamSdkApiResponse<T> fail(int code, String msg) {
        return IamSdkApiResponse.createInstance(null, code, msg);
    }

    public static <T> IamSdkApiResponse<T> fail(SdkResultCode resultCode) {
        return IamSdkApiResponse.createInstance(null, resultCode);
    }

    public static <T> IamSdkApiResponse<T> fail(SdkResultCode resultCode, String msg) {
        return IamSdkApiResponse.createInstance(null, resultCode.getCode(), msg);
    }

    public static <T> IamSdkApiResponse<T> status(boolean flag) {
        return flag ? IamSdkApiResponse.success(SdkResultCode.SUCCESS.getMessage()) : IamSdkApiResponse.fail(SdkResultCode.FAILURE.getMessage());
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

