/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.client.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.iam.client.dto.ClientGetTokenDto;
import com.jxdinfo.hussar.iam.client.enums.SdkUrlEnum;
import com.jxdinfo.hussar.iam.client.exception.IamSdkTokenException;
import com.jxdinfo.hussar.iam.client.properties.IamClientSdkProperties;
import com.jxdinfo.hussar.iam.client.service.ISdkTokenService;
import com.jxdinfo.hussar.iam.client.utils.HttpClientUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.Map;
import javax.annotation.Resource;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.iam.client.service.impl.SdkTokenServiceImpl")
public class SdkTokenServiceImpl
implements ISdkTokenService {
    @Resource
    private IamClientSdkProperties properties;

    @Override
    public String getToken() {
        ClientGetTokenDto clientGetTokenDto = new ClientGetTokenDto();
        clientGetTokenDto.setIamServer(this.properties.getIamServer());
        clientGetTokenDto.setScopes(this.properties.getScopes());
        clientGetTokenDto.setClientId(this.properties.getClientId());
        clientGetTokenDto.setClientSecret(this.properties.getClientSecret());
        clientGetTokenDto.setRefreshTokenTime(this.properties.getRefreshTokenTime());
        if (!StringUtil.isEmpty((Object)this.properties.getTcode())) {
            clientGetTokenDto.setTcode(this.properties.getTcode());
        }
        return this.getToken(clientGetTokenDto);
    }

    @Override
    public String getToken(ClientGetTokenDto clientGetTokenDto) throws IamSdkTokenException {
        String clientId = clientGetTokenDto.getClientId();
        String clientSecret = clientGetTokenDto.getClientSecret();
        if (StringUtil.isEmpty((Object)clientId) || StringUtil.isEmpty((Object)clientSecret)) {
            throw new IamSdkTokenException("\u83b7\u53d6\u7edf\u4e00\u6743\u9650\u5e73\u53f0\u5ba2\u6237\u7aef\u8ba4\u8bc1token\u8bf7\u6c42\u5931\u8d25:\u7f3a\u5c11\u53c2\u6570clientId\u6216\u8005clientSecret");
        }
        String token = (String)HussarCacheUtil.get((String)"iam_client_token", (Object)clientId);
        if (!StringUtil.isEmpty((Object)token)) {
            return token;
        }
        try {
            String getTokenUrl = clientGetTokenDto.getIamServer() + SdkUrlEnum.GET_TOKEN.getUrl();
            getTokenUrl = getTokenUrl + clientGetTokenDto.getScopes();
            String tcode = clientGetTokenDto.getTcode();
            Request request = !StringUtil.isEmpty((Object)tcode) ? new Request.Builder().url(getTokenUrl).addHeader("Client-Id", clientId).addHeader("client-secret", clientSecret).addHeader("tcode", tcode).build() : new Request.Builder().url(getTokenUrl).addHeader("Client-Id", clientId).addHeader("client-secret", clientSecret).build();
            Response response = HttpClientUtil.getClient().newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new IamSdkTokenException("\u83b7\u53d6\u7edf\u4e00\u6743\u9650\u5e73\u53f0\u5ba2\u6237\u7aef\u8ba4\u8bc1token\u8bf7\u6c42\u5931\u8d25:" + response.message());
            }
            String resultStr = response.body().string();
            ApiResponse tokenResponse = (ApiResponse)JsonUtil.parse((String)resultStr, (TypeReference)new TypeReference<ApiResponse<Map<String, Object>>>(){});
            if (tokenResponse == null || !tokenResponse.isSuccess()) {
                throw new IamSdkTokenException("\u83b7\u53d6\u7edf\u4e00\u6743\u9650\u5e73\u53f0\u5ba2\u6237\u7aef\u8ba4\u8bc1token\u5931\u8d25:" + resultStr);
            }
            Map tokenMap = (Map)tokenResponse.getData();
            token = (String)tokenMap.get("client-token");
            long expiresIn = Long.parseLong(tokenMap.get("expires-in").toString());
            long thisExpiresIn = expiresIn - this.properties.getRefreshTokenTime() * 60L;
            if (thisExpiresIn > 0L) {
                HussarCacheUtil.put((String)"iam_client_token", (Object)this.properties.getClientId(), (Object)token, (long)thisExpiresIn);
            }
            return token;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IamSdkTokenException("\u8c03\u7528sdk\u63a5\u53e3\u65f6\uff0c\u83b7\u53d6token\u5931\u8d25", e);
        }
    }
}

