/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.client.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.client.manager.QueryClientModelManager;
import com.jxdinfo.hussar.iam.client.manager.impl.CommonClientModelManager;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.vo.ClientInfoVo;
import com.jxdinfo.hussar.iam.client.vo.ClientVo;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.client.manager.impl.queryClientModelManager")
public class QueryClientModelManagerImpl
extends CommonClientModelManager
implements QueryClientModelManager {
    @Override
    public Page<ClientVo> selectClientModelList(PageInfo pageInfo, String clientId, Long appId) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("clientId", SqlQueryUtil.transferSpecialChar((String)clientId));
        queryParams.put("appId", appId);
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<ClientVo> clientVoList = this.sysClientModelMapper.selectClientModelList((Page<ClientVo>)page, queryParams);
        ArrayList appIdList = new ArrayList();
        HashMap appMap = new HashMap();
        clientVoList.forEach(c -> appIdList.add(c.getAppId()));
        if (ToolUtil.isNotEmpty(appIdList)) {
            List applicationList = this.sysApplicationService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysApplication::getId, appIdList.stream().distinct().collect(Collectors.toList())));
            applicationList.forEach(a -> appMap.put(a.getId(), a.getAppName()));
            clientVoList.forEach(c -> c.setAppName((String)appMap.get(c.getAppId())));
        }
        page.setRecords(clientVoList);
        return page;
    }

    @Override
    public ClientVo clientDetail(Long id) {
        SysClientModel clientModel = (SysClientModel)this.sysClientModelService.getById((Serializable)id);
        return this.clientModelToVo(clientModel);
    }

    @Override
    public ClientInfoVo getClientInfo() {
        ClientInfoVo clientInfoVo = new ClientInfoVo();
        clientInfoVo.setClientId(this.generateClientInfoService.getClientId());
        clientInfoVo.setClientSecret(this.generateClientInfoService.getClientSecret());
        return clientInfoVo;
    }
}

