/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.client.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.client.dao.SysClientModelMapper;
import com.jxdinfo.hussar.iam.client.dto.ClientDto;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.service.GenerateClientInfoService;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.iam.client.service.ISysClientPermissionService;
import com.jxdinfo.hussar.iam.client.vo.ClientVo;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class CommonClientModelManager {
    protected static final String DEFAULT_CONTRACT_SCOPE = "permission_list";
    protected static final String DEFAULT_ALLOW_URL = "*";
    protected static final String DEFAULT_AUTHORIZED_GRANT_TYPE = "client_credentials";
    protected static final Long DEFAULT_REFRESH_TOKEN_VALID_TIME = 86400L;
    protected static final Long DEFAULT_APPLICATION_ID = 1L;
    @Autowired
    protected ISysClientModelService sysClientModelService;
    @Autowired
    protected SysAuthClientModelService sysAuthClientModelService;
    @Autowired
    protected ISysClientPermissionService sysClientPermissionService;
    @Lazy
    @Autowired
    protected ISysApplicationService sysApplicationService;
    @Autowired
    protected GenerateClientInfoService generateClientInfoService;
    @Resource
    protected SysClientModelMapper sysClientModelMapper;
    @Autowired
    protected HussarTenantProperties tenantProperties;
    @Resource
    SecurityOAuth2Config securityOAuth2Config;
    @Resource
    private SecureAssesmentProperties secureAssesmentProperties;

    protected void checkSaveOrUpdate(ClientDto clientDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ToolUtil.isNotEmpty((Object)clientDto.getAccessTokenValidTime())) {
            long accessTokenValidTime = clientDto.getAccessTokenValidTime();
            Long clientCreateNewTokenThreshold = this.securityOAuth2Config.getClientCreateNewTokenThreshold();
            if (this.secureAssesmentProperties.isOpen() && (accessTokenValidTime <= clientCreateNewTokenThreshold || accessTokenValidTime > 1800L)) {
                throw new BaseException("\u8bf7\u6c42\u4ee4\u724c\u6709\u6548\u65f6\u95f4\u9700\u5927\u4e8e" + clientCreateNewTokenThreshold + "\u79d2\u4e14\u5c0f\u4e8e\u7b49\u4e8e30\u5206\u949f");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)clientDto.getClientId())) {
            List ifRepeat;
            ((LambdaQueryWrapper)queryWrapper.or()).eq(SysClientModel::getClientId, (Object)clientDto.getClientId());
            if (clientDto.getId() != null) {
                queryWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.ne(SysClientModel::getId, (Object)clientDto.getId());
                });
            }
            if ((ifRepeat = this.sysClientModelService.list((Wrapper)queryWrapper)).size() > 0) {
                throw new BaseException("\u5ba2\u6237\u7aefID\u5df2\u7ecf\u5b58\u5728");
            }
        } else {
            throw new BaseException("\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void checkSaveOrUpdate(String connName, ClientDto clientDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ToolUtil.isNotEmpty((Object)clientDto.getAccessTokenValidTime())) {
            long accessTokenValidTime = clientDto.getAccessTokenValidTime();
            Long clientCreateNewTokenThreshold = this.securityOAuth2Config.getClientCreateNewTokenThreshold();
            if (this.secureAssesmentProperties.isOpen() && (accessTokenValidTime <= clientCreateNewTokenThreshold || accessTokenValidTime > 1800L)) {
                throw new BaseException("\u8bf7\u6c42\u4ee4\u724c\u6709\u6548\u65f6\u95f4\u9700\u5927\u4e8e" + clientCreateNewTokenThreshold + "\u79d2\u4e14\u5c0f\u4e8e\u7b49\u4e8e30\u5206\u949f");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)clientDto.getClientId())) {
            List ifRepeat;
            ((LambdaQueryWrapper)queryWrapper.or()).eq(SysClientModel::getClientId, (Object)clientDto.getClientId());
            if (clientDto.getId() != null) {
                queryWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.ne(SysClientModel::getId, (Object)clientDto.getId());
                });
            }
            if ((ifRepeat = this.sysClientModelService.list(connName, (Wrapper)queryWrapper)).size() > 0) {
                throw new BaseException("\u5ba2\u6237\u7aefID\u5df2\u7ecf\u5b58\u5728");
            }
        } else {
            throw new BaseException("\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected SysClientModel clientDtoToModel(ClientDto clientDto) {
        SysClientModel clientModel = new SysClientModel();
        clientModel.setId(clientDto.getId());
        clientModel.setClientId(clientDto.getClientId());
        clientModel.setClientSecret(clientDto.getClientSecret());
        clientModel.setAccessTokenValidTime(clientDto.getAccessTokenValidTime());
        clientModel.setApplicationId(ToolUtil.isNotEmpty((Object)clientDto.getAppId()) ? clientDto.getAppId() : DEFAULT_APPLICATION_ID);
        return clientModel;
    }

    protected SysAuthClientModel clientDtoToAuthModel(ClientDto clientDto, boolean addFlag) {
        SysAuthClientModel clientModel = new SysAuthClientModel();
        clientModel.setId(clientDto.getId());
        clientModel.setClientId(clientDto.getClientId());
        clientModel.setClientSecret(clientDto.getClientSecret());
        clientModel.setAccessTokenValidTime(clientDto.getAccessTokenValidTime());
        clientModel.setApplicationId(clientDto.getAppId());
        if (addFlag) {
            clientModel.setContractScope(DEFAULT_CONTRACT_SCOPE);
            clientModel.setAllowUrl(DEFAULT_ALLOW_URL);
            clientModel.setAuthorizedGrantType(DEFAULT_AUTHORIZED_GRANT_TYPE);
            clientModel.setRefreshTokenValidTime(DEFAULT_REFRESH_TOKEN_VALID_TIME.longValue());
        }
        return clientModel;
    }

    protected ClientVo clientModelToVo(SysClientModel clientModel) {
        ClientVo clientVo = new ClientVo();
        if (ToolUtil.isNotEmpty((Object)clientModel)) {
            clientVo.setId(clientModel.getId());
            clientVo.setClientId(clientModel.getClientId());
            clientVo.setClientSecret(clientModel.getClientSecret());
            clientVo.setContractScope(clientModel.getContractScope());
            clientVo.setAllowUrl(clientModel.getAllowUrl());
            clientVo.setAuthorizedGrantType(clientModel.getAuthorizedGrantType());
            clientVo.setWebServerRedirectUri(clientModel.getWebServerRedirectUri());
            clientVo.setAuthorities(clientModel.getAuthorities());
            clientVo.setAccessTokenValidTime(clientModel.getAccessTokenValidTime());
            clientVo.setRefreshTokenValidTime(clientModel.getRefreshTokenValidTime());
            clientVo.setAdditionalInformation(clientModel.getAdditionalInformation());
            clientVo.setAutoApprove(clientModel.getAutoApprove());
            clientVo.setTenantId(clientModel.getTenantId());
            clientVo.setPublicKey(clientModel.getPublicKey());
            clientVo.setPrivateKey(clientModel.getPrivateKey());
            clientVo.setAppId(clientModel.getApplicationId());
        }
        return clientVo;
    }
}

