/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.client.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceTreeVo;
import com.jxdinfo.hussar.common.properties.UnifyPermissionProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.client.dao.SysClientPermissionMapper;
import com.jxdinfo.hussar.iam.client.dto.ClientPermissionDto;
import com.jxdinfo.hussar.iam.client.model.SysClientPermission;
import com.jxdinfo.hussar.iam.client.service.ISysClientPermissionService;
import com.jxdinfo.hussar.iam.client.vo.ClientPermissionVo;
import com.jxdinfo.hussar.iam.client.vo.OpenResTreeVo;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CommonClientPermissionManager {
    @Autowired
    protected ISysClientPermissionService sysClientPermissionService;
    @Autowired
    protected ISysResourcesService sysResourcesService;
    @Resource
    protected SysClientPermissionMapper sysClientPermissionMapper;
    @Autowired
    protected UnifyPermissionProperties unifyPermissionProperties;

    protected List<OpenResTreeVo> filterNoChildNode(List<OpenResTreeVo> items) {
        ArrayList<OpenResTreeVo> newItems = new ArrayList<OpenResTreeVo>();
        for (OpenResTreeVo model : items) {
            List children = model.getChildren();
            if ("1".equals(model.getIsRes())) {
                newItems.add(model);
                continue;
            }
            if (ToolUtil.isNotEmpty((Object)children)) {
                List<OpenResTreeVo> newChildren = this.filterNoChildNode(children);
                if (ToolUtil.isNotEmpty(newChildren)) {
                    model.setChildren(newChildren);
                    newItems.add(model);
                } else if ("1".equals(model.getId())) {
                    model.setChildren(newChildren);
                }
            }
            if (!"1".equals(model.getId()) || newItems.contains(model)) continue;
            newItems.add(model);
        }
        return newItems;
    }

    protected ClientPermissionVo resourceToPermissionVo(SysResources sysResources) {
        ClientPermissionVo clientPermissionVo = new ClientPermissionVo();
        clientPermissionVo.setResourceId(sysResources.getId());
        clientPermissionVo.setResourceName(sysResources.getResourceName());
        clientPermissionVo.setUrl(sysResources.getUrlNames());
        return clientPermissionVo;
    }

    protected OpenResTreeVo resourceTreeVoToOpenResVo(ResourceTreeVo resourceTreeVo) {
        OpenResTreeVo openResTreeVo = new OpenResTreeVo();
        openResTreeVo.setId(resourceTreeVo.getId());
        openResTreeVo.setLabel(resourceTreeVo.getLabel());
        openResTreeVo.setParentId(resourceTreeVo.getParentId());
        openResTreeVo.setIcon(resourceTreeVo.getIcon());
        openResTreeVo.setIsRes(resourceTreeVo.getIsRes());
        openResTreeVo.setIsModule(resourceTreeVo.getIsModule());
        return openResTreeVo;
    }

    protected void updateClientPermissionByAddDel(List<ClientPermissionDto> addList, List<ClientPermissionDto> delList) {
        ArrayList<String> clientIdList = new ArrayList();
        clientIdList.addAll(addList.stream().map(ClientPermissionDto::getClientId).collect(Collectors.toList()));
        clientIdList.addAll(delList.stream().map(ClientPermissionDto::getClientId).collect(Collectors.toList()));
        if (ToolUtil.isNotEmpty(clientIdList)) {
            clientIdList = clientIdList.stream().distinct().collect(Collectors.toList());
            List clientPermissionList = this.sysClientPermissionService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysClientPermission::getClientId, clientIdList));
            this.updateClientPermission(clientPermissionList, clientIdList);
        }
    }

    protected void updateClientPermission(List<SysClientPermission> clientPermissionList, List<String> clientIdList) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        String tenantCode = ToolUtil.isNotEmpty((Object)securityUser) && ToolUtil.isNotEmpty((Object)securityUser.getTenantCode()) ? securityUser.getTenantCode() : "";
        HashMap permissionMap = new HashMap();
        Map<Long, String> resourceIdUrlMap = this.getResourceIdUrlMap(clientPermissionList);
        for (String clientId : clientIdList) {
            permissionMap.put(clientId, new ArrayList());
        }
        for (SysClientPermission clientPermission : clientPermissionList) {
            List permissionList = (List)permissionMap.get(clientPermission.getClientId());
            String permission = resourceIdUrlMap.get(clientPermission.getPermissionId());
            if (!ToolUtil.isNotEmpty((Object)permission)) continue;
            permissionList.add(permission);
        }
        for (String clientId : permissionMap.keySet()) {
            HussarSecurityUtils.updateClientPermissions((String)clientId, (String)tenantCode, (List)((List)permissionMap.get(clientId)));
        }
    }

    private Map<Long, String> getResourceIdUrlMap(List<SysClientPermission> clientPermissionList) {
        List permissionIdList = clientPermissionList.stream().map(SysClientPermission::getPermissionId).distinct().collect(Collectors.toList());
        HashMap<Long, String> resourceIdUrlMap = new HashMap<Long, String>();
        if (ToolUtil.isNotEmpty(permissionIdList)) {
            List resourcesList = this.sysResourcesService.listByIds(permissionIdList);
            for (SysResources resource : resourcesList) {
                if (!ToolUtil.isNotEmpty((Object)resource.getUrlNames())) continue;
                resourceIdUrlMap.put(resource.getId(), resource.getUrlNames());
            }
        }
        return resourceIdUrlMap;
    }
}

