/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.permission;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.ElementResourceVo;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryElementResourceDto;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryResourceModuleDto;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.common.server.util.ApplicationUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/resource"})
@Api(tags={"\u8d44\u6e90\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseResourceSdkController {
    @Autowired
    private ISysResourcesService sysResourcesService;
    @Autowired
    private ISysResourceMosulesService sysResourceMosulesService;

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u8d44\u6e90\u5217\u8868", notes="\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u8d44\u6e90\u5217\u8868")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u8d44\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:list"})
    @PostMapping(value={"/list"})
    public IamSdkApiResponse<List<SysResources>> list() {
        Long appId = ApplicationUtils.getApplicationId();
        return IamSdkApiResponse.success((Object)this.sysResourcesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getApplicationId, (Object)appId)).orderByAsc(SysResources::getSeq)));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u7684\u8d44\u6e90\u6743\u9650\u5217\u8868", notes="\u83b7\u53d6\u89d2\u8272\u7684\u8d44\u6e90\u6743\u9650\u5217\u8868")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u89d2\u8272\u7684\u8d44\u6e90\u6743\u9650\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:queryPermissionsByRoleIds"})
    @PostMapping(value={"/queryPermissionsByRoleIds"})
    public IamSdkApiResponse<List<String>> queryPermissionsByRoleIds(@RequestBody List<Long> roleIds) {
        return IamSdkApiResponse.success((Object)this.sysResourcesService.queryPermissionsByRoleIds(roleIds));
    }

    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u8d44\u6e90", notes="\u6279\u91cf\u66f4\u65b0\u8d44\u6e90")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6279\u91cf\u66f4\u65b0\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"iamBaseSdk:resource:updateBatchById"})
    @PostMapping(value={"/updateBatchById"})
    public IamSdkApiResponse<Boolean> updateBatchById(@RequestBody List<SysResources> sysResources) {
        return IamSdkApiResponse.success((Object)this.sysResourcesService.updateBatchById(sysResources));
    }

    @ApiOperation(value="\u4fdd\u5b58\u8d44\u6e90", notes="\u4fdd\u5b58\u8d44\u6e90")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamBaseSdk:resource:save"})
    @PostMapping(value={"/save"})
    public IamSdkApiResponse<Boolean> save(@RequestBody SysResources sysResources) {
        sysResources.setApplicationId(ApplicationUtils.getApplicationId());
        return IamSdkApiResponse.success((Object)this.sysResourcesService.save((Object)sysResources));
    }

    @ApiOperation(value="\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u4e0b\u8d44\u6e90\u6700\u5927\u6392\u5e8f\u503c", notes="\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u4e0b\u8d44\u6e90\u6700\u5927\u6392\u5e8f\u503c")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u4e0b\u8d44\u6e90\u6700\u5927\u6392\u5e8f\u503c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:getMaxOrderByParentId"})
    @PostMapping(value={"/getMaxOrderByParentId"})
    public IamSdkApiResponse<Integer> getMaxOrderByParentId(@RequestBody Long moduleId) {
        Integer order = this.sysResourcesService.getMaxOrderByParentId(moduleId);
        if (HussarUtils.isEmpty((Object)order)) {
            order = 1;
        }
        return IamSdkApiResponse.success((Object)order);
    }

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u8d44\u6e90\u6a21\u5757\u5217\u8868", notes="\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u8d44\u6e90\u6a21\u5757\u5217\u8868")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u8d44\u6e90\u6a21\u5757\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:moduleList"})
    @PostMapping(value={"/moduleList"})
    public IamSdkApiResponse<List<SysResourceModules>> moduleList(@RequestBody IamQueryResourceModuleDto iamQueryResourceModuleDto) {
        Long appId = ApplicationUtils.getApplicationId();
        String moduleName = iamQueryResourceModuleDto.getModuleName();
        Long parentModuleId = iamQueryResourceModuleDto.getParentModuleId();
        return IamSdkApiResponse.success((Object)this.sysResourceMosulesService.listByNameAndParentId(moduleName, parentModuleId, appId));
    }

    @ApiOperation(value="\u4fdd\u5b58\u8d44\u6e90\u6a21\u5757\u4fe1\u606f", notes="\u4fdd\u5b58\u8d44\u6e90\u6a21\u5757\u4fe1\u606f")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u8d44\u6e90\u6a21\u5757\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamBaseSdk:resource:saveModule"})
    @PostMapping(value={"/saveModule"})
    public IamSdkApiResponse<Boolean> saveModule(@RequestBody SysResourceModules sysResourceModules) {
        sysResourceModules.setApplicationId(ApplicationUtils.getApplicationId());
        return IamSdkApiResponse.success((Object)this.sysResourceMosulesService.save((Object)sysResourceModules));
    }

    @ApiOperation(value="\u83b7\u53d6\u540c\u5e94\u7528\u4e0b\u8d44\u6e90\u6a21\u5757\u4e0b\u6a21\u5757\u6700\u5927\u6392\u5e8f\u503c", notes="\u83b7\u53d6\u540c\u5e94\u7528\u4e0b\u8d44\u6e90\u6a21\u5757\u4e0b\u6a21\u5757\u6700\u5927\u6392\u5e8f\u503c")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u540c\u5e94\u7528\u4e0b\u8d44\u6e90\u6a21\u5757\u4e0b\u6a21\u5757\u6700\u5927\u6392\u5e8f\u503c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:getMaxOrderByParentIdAndAppId"})
    @PostMapping(value={"/getMaxOrderByParentIdAndAppId"})
    public IamSdkApiResponse<Integer> getMaxOrderByParentIdAndAppId(@RequestBody Long moduleId) {
        Long appId = ApplicationUtils.getApplicationId();
        Integer order = this.sysResourceMosulesService.getMaxOrderByParentIdAndAppId(moduleId, appId);
        if (HussarUtils.isEmpty((Object)order)) {
            order = 1;
        }
        return IamSdkApiResponse.success((Object)order);
    }

    @ApiOperation(value="\u6839\u636e\u8d44\u6e90id\u96c6\u5408\u83b7\u53d6\u8d44\u6e90\u4fe1\u606f", notes="\u6839\u636e\u8d44\u6e90id\u96c6\u5408\u83b7\u53d6\u8d44\u6e90\u4fe1\u606f")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u8d44\u6e90id\u96c6\u5408\u83b7\u53d6\u8d44\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:listByIds"})
    @PostMapping(value={"/listByIds"})
    public IamSdkApiResponse<List<SysResources>> listByIds(@RequestBody List<Long> idList) {
        return IamSdkApiResponse.success((Object)this.sysResourcesService.listByIds(idList));
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u5757\u4e0b\u9875\u9762\u53ca\u5143\u7d20\u8d44\u6e90\u5217\u8868", notes="\u83b7\u53d6\u6a21\u5757\u4e0b\u9875\u9762\u53ca\u5143\u7d20\u8d44\u6e90\u5217\u8868")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6a21\u5757\u4e0b\u9875\u9762\u53ca\u5143\u7d20\u8d44\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:getPageAndElementResources"})
    @PostMapping(value={"/getPageAndElementResources"})
    public IamSdkApiResponse<List<SysResources>> getPageAndElementResources(@RequestBody Long moduleId) {
        return IamSdkApiResponse.success((Object)this.sysResourcesService.getPageAndElementResources(moduleId));
    }

    @ApiOperation(value="\u83b7\u53d6\u9875\u9762\u5185\u5143\u7d20\u8d44\u6e90", notes="\u83b7\u53d6\u9875\u9762\u5185\u5143\u7d20\u8d44\u6e90")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u9875\u9762\u5185\u5143\u7d20\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:elementResources"})
    @PostMapping(value={"/elementResources"})
    public IamSdkApiResponse<List<ElementResourceVo>> elementResources(@RequestBody IamQueryElementResourceDto dto) {
        return IamSdkApiResponse.success((Object)this.sysResourcesService.elementResources(dto.getPagePath(), dto.getRoleIds()));
    }

    @ApiOperation(value="\u6839\u636eid\u4fee\u6539\u8d44\u6e90", notes="\u6839\u636eid\u4fee\u6539\u8d44\u6e90")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636eid\u4fee\u6539\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"iamBaseSdk:resource:updateById"})
    @PostMapping(value={"/updateById"})
    public IamSdkApiResponse<Boolean> updateById(@RequestBody SysResources sysResources) {
        return IamSdkApiResponse.success((Object)this.sysResourcesService.updateById((Object)sysResources));
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u8d44\u6e90", notes="\u6839\u636eid\u83b7\u53d6\u8d44\u6e90")
    @PostMapping(value={"/getById"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636eid\u83b7\u53d6\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public IamSdkApiResponse<SysResources> getById(@RequestBody Long id) {
        return IamSdkApiResponse.success((Object)this.sysResourcesService.getById((Serializable)id));
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u5757\u540d\u79f0\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u8d44\u6e90\u6a21\u5757\u7684\u5168\u8def\u5f84", notes="\u6839\u636e\u6a21\u5757\u540d\u79f0\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u8d44\u6e90\u6a21\u5757\u7684\u5168\u8def\u5f84")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u6a21\u5757\u540d\u79f0\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u8d44\u6e90\u6a21\u5757\u7684\u5168\u8def\u5f84", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:getFullModuleNameMapByName"})
    @PostMapping(value={"/getFullModuleNameMapByName"})
    public IamSdkApiResponse<Map<Long, String>> getFullModuleNameMapByName(@RequestBody String moduleName) {
        Long appId = ApplicationUtils.getApplicationId();
        return IamSdkApiResponse.success((Object)this.sysResourceMosulesService.getFullModuleNameMapByName(moduleName, appId));
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u5757id\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u7684\u5168\u8def\u5f84", notes="\u6839\u636e\u6a21\u5757id\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u7684\u5168\u8def\u5f84")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u6a21\u5757id\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u7684\u5168\u8def\u5f84", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:getFullModuleNameById"})
    @PostMapping(value={"/getFullModuleNameById"})
    public IamSdkApiResponse<String> getFullModuleNameById(@RequestBody Long moduleId) {
        Long appId = ApplicationUtils.getApplicationId();
        return IamSdkApiResponse.success((String)this.sysResourceMosulesService.getFullModuleNameById(moduleId, appId));
    }

    @ApiOperation(value="\u6839\u636e\u8d44\u6e90\u7c7b\u578b\u7f16\u7801\u83b7\u53d6\u8d44\u6e90", notes="\u6839\u636e\u8d44\u6e90\u7c7b\u578b\u7f16\u7801\u83b7\u53d6\u8d44\u6e90")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u8d44\u6e90\u7c7b\u578b\u7f16\u7801\u83b7\u53d6\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:getResourcesByType"})
    @PostMapping(value={"/getResourcesByType"})
    public IamSdkApiResponse<List<SysResources>> getResourcesByType(@RequestBody String resTypeCode) {
        Long appId = ApplicationUtils.getApplicationId();
        return IamSdkApiResponse.success((Object)this.sysResourcesService.getResourcesByType(resTypeCode, appId));
    }

    @ApiOperation(value="\u6839\u636e\u8d44\u6e90\u6a21\u5757id\u4fee\u6539\u8d44\u6e90\u6a21\u5757", notes="\u6839\u636e\u8d44\u6e90\u6a21\u5757id\u4fee\u6539\u8d44\u6e90\u6a21\u5757")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u8d44\u6e90\u6a21\u5757id\u4fee\u6539\u8d44\u6e90\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"iamBaseSdk:resource:updateModule"})
    @PostMapping(value={"/updateModule"})
    public IamSdkApiResponse<Boolean> updateModule(@RequestBody SysResourceModules sysResourceModules) {
        return IamSdkApiResponse.success((Object)this.sysResourceMosulesService.updateById((Object)sysResourceModules));
    }

    @ApiOperation(value="\u6839\u636e\u8d44\u6e90\u6a21\u5757id\u83b7\u53d6\u8d44\u6e90\u6a21\u5757", notes="\u6839\u636e\u8d44\u6e90\u6a21\u5757id\u83b7\u53d6\u8d44\u6e90\u6a21\u5757")
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u8d44\u6e90\u6a21\u5757id\u83b7\u53d6\u8d44\u6e90\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:resource:getModuleByModuleId"})
    @PostMapping(value={"/getModuleByModuleId"})
    public IamSdkApiResponse<SysResourceModules> getModuleByModuleId(@RequestBody Long moduleId) {
        return IamSdkApiResponse.success((Object)this.sysResourceMosulesService.getById((Serializable)moduleId));
    }
}

