/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.identity;

import com.jxdinfo.hussar.authorization.permit.dto.SwitchIdentityDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserIdentityService;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamHandleIdentityDto;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.common.server.util.ApplicationUtils;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/identity"})
@Api(tags={"\u8eab\u4efd\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseIdentitySdkController {
    @Autowired
    private IHussarBaseUserIdentityService hussarBaseUserIdentityService;

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7\u5c97\u4f4d\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7\u5c97\u4f4d\u5217\u8868")
    @AuditLog(moduleName="\u7528\u6237\u8eab\u4efd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7\u5c97\u4f4d\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:identity:getUserOrganPost"})
    @PostMapping(value={"/getUserOrganPost"})
    public IamSdkApiResponse<List<UserOrganPostVo>> getUserOrganPostList(@RequestBody Long userId) {
        return IamSdkApiResponse.success((Object)this.hussarBaseUserIdentityService.getUserOrganPost(userId));
    }

    @ApiOperation(value="\u5207\u6362\u7528\u6237\u8eab\u4efd", notes="\u5207\u6362\u7528\u6237\u8eab\u4efd")
    @AuditLog(moduleName="\u7528\u6237\u8eab\u4efd\u7ba1\u7406", eventDesc="\u5207\u6362\u7528\u6237\u8eab\u4efd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"iamBaseSdk:identity:switchUserIdentity"})
    @PostMapping(value={"/switchUserIdentity"})
    public IamSdkApiResponse<UserDetails> switchUserIdentity(@ApiParam(value="\u5207\u6362\u7528\u6237\u8eab\u4efdDto") @RequestBody SwitchIdentityDto switchIdentityDto) {
        switchIdentityDto.setAppId(ApplicationUtils.getApplicationId());
        return IamSdkApiResponse.success((Object)this.hussarBaseUserIdentityService.switchUserIdentity(switchIdentityDto));
    }

    @ApiOperation(value="\u5904\u7406\u7528\u6237\u8eab\u4efd\u4fe1\u606f", notes="\u5904\u7406\u7528\u6237\u8eab\u4efd\u4fe1\u606f")
    @AuditLog(moduleName="\u7528\u6237\u8eab\u4efd\u7ba1\u7406", eventDesc="\u5904\u7406\u7528\u6237\u8eab\u4efd\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:identity:handleUserIdentity"})
    @PostMapping(value={"/handleUserIdentity"})
    public IamSdkApiResponse<UserDetails> handleUserIdentity(@RequestBody IamHandleIdentityDto iamHandleIdentityDto) {
        UserDetails userDetails = iamHandleIdentityDto.getUserDetails();
        Long appId = ApplicationUtils.getApplicationId();
        return IamSdkApiResponse.success((Object)this.hussarBaseUserIdentityService.handleUserIdentity(userDetails, appId));
    }
}

