/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.identity;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostBoService;
import com.jxdinfo.hussar.authorization.post.vo.PostBasicVo;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamFeignQueryPostDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.vo.OrganPostTreeVo;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/feign/post"})
@Api(tags={"\u5c97\u4f4d\u5bf9\u5916feign\u63a5\u53e3"})
public class HussarBaseFeignPostSdkController {
    @Resource
    private IHussarBasePostBoService hussarBasePostBoService;

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u3001\u5c97\u4f4d\u540d\u79f0\u83b7\u53d6\u5c97\u4f4d\u5217\u8868", notes="\u6839\u636e\u7ec4\u7ec7id\u3001\u5c97\u4f4d\u540d\u79f0\u83b7\u53d6\u5c97\u4f4d\u5217\u8868")
    @AuditLog(moduleName="\u5c97\u4f4d\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u6839\u636e\u7ec4\u7ec7id\u3001\u5c97\u4f4d\u540d\u79f0\u83b7\u53d6\u5c97\u4f4d\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:post:getPostsByStruId"})
    @PostMapping(value={"/getPostsByStruId"})
    public IamSdkApiResponse<List<PostBasicVo>> getPostsByStruId(@RequestBody IamFeignQueryPostDTO feignQueryPostDTO) {
        Long struId = feignQueryPostDTO.getOrganId();
        String postName = feignQueryPostDTO.getPostName();
        return IamSdkApiResponse.success((Object)this.hussarBasePostBoService.getPostsByStruId(struId, postName));
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u5c97\u4f4d\u6811", notes="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u5c97\u4f4d\u6811")
    @CheckPermission(value={"iamBaseSdk:feign:post:lazyLoadOrganPostTree"})
    @PostMapping(value={"/lazyLoadOrganPostTree"})
    @AuditLog(moduleName="\u5c97\u4f4d\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u5c97\u4f4d\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public IamSdkApiResponse<List<OrganPostTreeVo>> lazyLoadOrganPostTree(@RequestBody Long parentId) {
        List treeVos = this.hussarBasePostBoService.lazyLoadOrganPostTree(parentId);
        List organPostTreeVos = JSON.parseArray((String)JSON.toJSONString((Object)treeVos), OrganPostTreeVo.class);
        return IamSdkApiResponse.success((Object)organPostTreeVos);
    }

    @ApiOperation(value="\u6839\u636e\u5c97\u4f4did\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u5c97\u4f4d\u4fe1\u606f", notes="\u6839\u636e\u5c97\u4f4did\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u5c97\u4f4d\u4fe1\u606f")
    @CheckPermission(value={"iamBaseSdk:feign:post:getPostInfoByIds"})
    @PostMapping(value={"/getPostInfoByIds"})
    @AuditLog(moduleName="\u5c97\u4f4d\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u6839\u636e\u5c97\u4f4did\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u5c97\u4f4d\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public IamSdkApiResponse<List<PostBasicVo>> getPostInfoByIds(@RequestBody List<Long> postIds) {
        return IamSdkApiResponse.success((Object)this.hussarBasePostBoService.getPostInfoByIds(postIds));
    }

    @ApiOperation(value="\u6839\u636e\u5c97\u4f4d\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u5c97\u4f4d", notes="\u6839\u636e\u5c97\u4f4d\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u5c97\u4f4d")
    @CheckPermission(value={"iamBaseSdk:feign:post:organPostSearch"})
    @PostMapping(value={"/organPostSearch"})
    @AuditLog(moduleName="\u5c97\u4f4d\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u6839\u636e\u5c97\u4f4d\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u5c97\u4f4d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public IamSdkApiResponse<List<OrganPostTreeVo>> organPostSearch(@RequestBody(required=false) String postName) {
        List treeVos = this.hussarBasePostBoService.organPostSearch(postName);
        List organPostTreeVos = JSON.parseArray((String)JSON.toJSONString((Object)treeVos), OrganPostTreeVo.class);
        return IamSdkApiResponse.success((Object)organPostTreeVos);
    }
}

