/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.http.service.permission;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.authorization.permit.dto.QueryFuncDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryFuncModuleTreeDto;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryFunctionModuleDto;
import com.jxdinfo.hussar.iam.base.sdk.api.enums.SdkUrlEnum;
import com.jxdinfo.hussar.iam.base.sdk.api.treemodel.JSTreeModel;
import com.jxdinfo.hussar.iam.base.sdk.http.utils.SdkHttpUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseFunctionService {
    public SysFunctions getById(Long id) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_BY_ID, (Object)id, SysFunctions.class);
    }

    public Boolean updateById(SysFunctions sysFunctions) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_UPDATE_BY_ID, (Object)sysFunctions, Boolean.class);
    }

    public Boolean save(SysFunctions sysFunctions) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_SAVE, (Object)sysFunctions, Boolean.class);
    }

    public Integer getMaxOrderByParentId(Long moduleId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_MAX_ORDER_BY_PARENT_ID, (Object)moduleId, Integer.class);
    }

    public List<SysFunctionModules> moduleList(String moduleName, Long parentModuleId, Long businessAppId) {
        IamQueryFunctionModuleDto iamQueryFunctionModuleDto = new IamQueryFunctionModuleDto();
        iamQueryFunctionModuleDto.setModuleName(moduleName);
        iamQueryFunctionModuleDto.setParentModuleId(parentModuleId);
        iamQueryFunctionModuleDto.setBusinessAppId(businessAppId);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_MODULE_LIST, (Object)iamQueryFunctionModuleDto, new TypeReference<List<SysFunctionModules>>(){});
    }

    public Boolean saveModule(SysFunctionModules sysFunctionModules) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_SAVE_MODULE, (Object)sysFunctionModules, Boolean.class);
    }

    public Integer getMaxOrderByParentIdAndAppId(Long moduleId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_MAX_ORDER_BY_PARENT_ID_AND_APP_ID, (Object)moduleId, Integer.class);
    }

    public List<JSTreeModel> getFunModuleMergeTreeForOrg(String functionFlag, String showFlag, Long bizAppId) {
        IamQueryFuncModuleTreeDto iamQueryFuncModuleTreeDto = new IamQueryFuncModuleTreeDto();
        iamQueryFuncModuleTreeDto.setFunctionFlag(functionFlag);
        iamQueryFuncModuleTreeDto.setShowFlag(showFlag);
        iamQueryFuncModuleTreeDto.setBusinessAppId(bizAppId);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_FUNC_MODULE_TREE_FOR_ORG, (Object)iamQueryFuncModuleTreeDto, new TypeReference<List<JSTreeModel>>(){});
    }

    public List<SysFunctions> listByIds(Collection<? extends Serializable> idList) {
        if (HussarUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_LIST_BY_IDS, idList, new TypeReference<List<SysFunctions>>(){});
    }

    public SysModuleFunctionsVo getFunctionDetail(Long functionId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_FUNCTION_DETAIL, (Object)functionId, SysModuleFunctionsVo.class);
    }

    public Map<Long, String> getFullModuleNameMapByName(String moduleName, Long businessAppId) {
        IamQueryFunctionModuleDto iamQueryFunctionModuleDto = new IamQueryFunctionModuleDto();
        iamQueryFunctionModuleDto.setModuleName(moduleName);
        iamQueryFunctionModuleDto.setBusinessAppId(businessAppId);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_FULL_MODULE_NAME_MAP_BY_NAME, (Object)iamQueryFunctionModuleDto, new TypeReference<Map<Long, String>>(){});
    }

    public String getFullModuleNameById(Long moduleId, Long businessAppId) {
        IamQueryFunctionModuleDto iamQueryFunctionModuleDto = new IamQueryFunctionModuleDto();
        iamQueryFunctionModuleDto.setModuleId(moduleId);
        iamQueryFunctionModuleDto.setBusinessAppId(businessAppId);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_FULL_MODULE_NAME_BY_ID, (Object)iamQueryFunctionModuleDto, String.class);
    }

    public List<SysFunctions> getFunsByAllDefaultRes() {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_FUNS_BY_ALL_DEFAULT_RES, null, new TypeReference<List<SysFunctions>>(){});
    }

    public Boolean updateModule(SysFunctionModules sysFunctionModules) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_UPDATE_MODULE, (Object)sysFunctionModules, Boolean.class);
    }

    public SysFunctionModules getModuleByModuleId(Long moduleId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_MODULE_BY_MODULE_ID, (Object)moduleId, SysFunctionModules.class);
    }

    public List<JSTreeModel> loadMenuFuncModuleTree(QueryFuncDto queryFuncDto) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_LOAD_MENU_FUNC_MODULE_TREE, (Object)queryFuncDto, new TypeReference<List<JSTreeModel>>(){});
    }
}

