/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.http.service.account;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.authorization.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryUserDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.enums.SdkUrlEnum;
import com.jxdinfo.hussar.iam.base.sdk.http.utils.SdkHttpUtils;
import com.jxdinfo.hussar.iam.common.api.exception.IamSdkHttpException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.iam.base.sdk.http.service.account.hussarBaseUserService")
public class HussarBaseUserService {
    public SysUsers getById(Long userId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_USER_BY_ID, (Object)userId, SysUsers.class);
    }

    public SysUsers getOne(List<String> accountStatus, String userAccount) {
        if (HussarUtils.isEmpty((Object)userAccount)) {
            throw new IamSdkHttpException("\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IamQueryUserDTO queryUserDTO = new IamQueryUserDTO();
        queryUserDTO.setUserAccount(userAccount);
        queryUserDTO.setAccountStatus(accountStatus);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ONE_USER, (Object)queryUserDTO, SysUsers.class);
    }

    public List<SysUsers> listByIds(List<Long> userIds) {
        if (HussarUtils.isEmpty(userIds)) {
            throw new IamSdkHttpException("\u7528\u6237id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_USERS_BY_ID_LIST, userIds, new TypeReference<List<SysUsers>>(){});
    }

    public List<SysUsers> getExpiredTemporary(LocalDateTime endTime) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_EXPIRED_TEMPORARY, (Object)endTime, new TypeReference<List<SysUsers>>(){});
    }

    public void updateBatchById(List<SysUsers> users) {
        SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_BATCH_UPDATE_USER, users, Void.class);
    }

    public Boolean isExistAccount(String userAccount) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_IS_EXIST_ACCOUNT, (Object)userAccount, Boolean.class);
    }

    public List<SysPasswordHist> getPwdHist(Long userId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_PWD_HIST, (Object)userId, new TypeReference<List<SysPasswordHist>>(){});
    }

    public void updatePwd(SysUsers sysUsers) {
        SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_UPDATE_PWD, (Object)sysUsers, Void.class);
    }
}

