/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.http.service.permission;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryRoleDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.enums.SdkUrlEnum;
import com.jxdinfo.hussar.iam.base.sdk.api.treemodel.JSTreeModel;
import com.jxdinfo.hussar.iam.base.sdk.api.treemodel.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.iam.base.sdk.http.utils.SdkHttpUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseRoleService {
    public List<JSTreeModel> getLazyRoleTree(Long nodeId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_LAZY_ROLE_TREE, (Object)nodeId, new TypeReference<List<JSTreeModel>>(){});
    }

    public List<SysRoles> listByIds(Collection<? extends Serializable> idList) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_LIST_BY_IDS, idList, new TypeReference<List<SysRoles>>(){});
    }

    public List<Long> getRoleIdByRoleName(List<String> roleNames) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ROLE_ID_BY_NAME, roleNames, new TypeReference<List<Long>>(){});
    }

    public Long addAppDevRole(String appName) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_ADD_APP_DEV_ROLE, (Object)appName, Long.class);
    }

    public List<Long> getRoleIdByGroupId(List<String> groupNames) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ROLE_ID_BY_GROUP_ID, groupNames, new TypeReference<List<Long>>(){});
    }

    public void deleteDevelopRole(Long roleId) {
        SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_DELETE_DEVELOP_ROLE, (Object)roleId, Void.class);
    }

    public List<RoleVo> getRoleInfoByIds(List<Long> roleIds) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ROLE_INFO_BY_IDS, roleIds, new TypeReference<List<RoleVo>>(){});
    }

    public List<JSTreeModel> loadRoleGruopTree(Long appId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_LOAD_ROLE_GROUP_TREE, (Object)appId, new TypeReference<List<JSTreeModel>>(){});
    }

    public List<SysRoles> searchRoleToGroup(Long groupId, String roleName) {
        IamQueryRoleDTO queryRoleDTO = new IamQueryRoleDTO();
        queryRoleDTO.setRoleGroupId(groupId);
        queryRoleDTO.setRoleName(roleName);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_SEARCH_ROLE_TO_GROUP, (Object)queryRoleDTO, new TypeReference<List<SysRoles>>(){});
    }

    public List<ReadOnlyRoleTreeVo> getRoleTree() {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ROLE_TREE, null, new TypeReference<List<ReadOnlyRoleTreeVo>>(){});
    }
}

