/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.http.service.permission;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.vo.ElementResourceVo;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryElementResourceDto;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryResourceModuleDto;
import com.jxdinfo.hussar.iam.base.sdk.api.enums.SdkUrlEnum;
import com.jxdinfo.hussar.iam.base.sdk.http.utils.SdkHttpUtils;
import com.jxdinfo.hussar.iam.common.api.exception.IamSdkPermissionException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseResourceService {
    public List<SysResources> list() {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_LIST, null, new TypeReference<List<SysResources>>(){});
    }

    public List<String> queryPermissionsByRoleIds(List<Long> roleIds) {
        if (HussarUtils.isEmpty(roleIds)) {
            throw new IamSdkPermissionException("\u89d2\u8272id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_QUERY_PERMISSIONS_BY_ROLEIDS, roleIds, new TypeReference<List<String>>(){});
    }

    public Boolean updateBatchById(List<SysResources> sysResources) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_UPDATE_BATCH_BY_ID, sysResources, Boolean.class);
    }

    public Boolean save(SysResources sysResources) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_SAVE, (Object)sysResources, Boolean.class);
    }

    public Integer getMaxOrderByParentId(Long moduleId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_GET_MAX_ORDER_BY_PARENT_ID, (Object)moduleId, Integer.class);
    }

    public List<SysResourceModules> moduleList(String moduleName, Long parentModuleId) {
        IamQueryResourceModuleDto iamQueryResourceModuleDto = new IamQueryResourceModuleDto();
        iamQueryResourceModuleDto.setModuleName(moduleName);
        iamQueryResourceModuleDto.setParentModuleId(parentModuleId);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_MODULE_LIST, (Object)iamQueryResourceModuleDto, new TypeReference<List<SysResourceModules>>(){});
    }

    public Boolean saveModule(SysResourceModules sysResourceModules) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_SAVE_MODULE, (Object)sysResourceModules, Boolean.class);
    }

    public Integer getMaxOrderByParentIdAndAppId(Long moduleId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_GET_MAX_ORDER_BY_PARENT_ID_AND_APP_ID, (Object)moduleId, Integer.class);
    }

    public List<SysResources> listByIds(Collection<? extends Serializable> idList) {
        if (HussarUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_LIST_BY_IDS, idList, new TypeReference<List<SysResources>>(){});
    }

    public List<SysResources> getPageAndElementResources(Long moduleId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_GET_PAGE_AND_ELEMENT_RESOURCES, (Object)moduleId, new TypeReference<List<SysResources>>(){});
    }

    public List<ElementResourceVo> elementResources(String pagePath, List<Long> roleIds) {
        IamQueryElementResourceDto iamQueryElementResourceDto = new IamQueryElementResourceDto();
        iamQueryElementResourceDto.setPagePath(pagePath);
        iamQueryElementResourceDto.setRoleIds(roleIds);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_ELEMENT_RESOURCES, (Object)iamQueryElementResourceDto, new TypeReference<List<ElementResourceVo>>(){});
    }

    public Boolean updateById(SysResources sysResources) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_UPDATE_BY_ID, (Object)sysResources, Boolean.class);
    }

    public SysResources getById(Serializable id) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_RESOURCE_GET_BY_ID, (Object)id, SysResources.class);
    }
}

