/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.http.service.account;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.authorization.organ.dto.SearchOrganUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamFeignQueryOrganUserDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamFeignQueryUserDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamFeignSearchUserDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamSearchOrganUserDto;
import com.jxdinfo.hussar.iam.base.sdk.api.enums.SdkUrlEnum;
import com.jxdinfo.hussar.iam.base.sdk.api.treemodel.OrganUserTreeVo;
import com.jxdinfo.hussar.iam.base.sdk.http.utils.SdkHttpUtils;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseFeignUserService {
    public List<UserVo> getUsersByOrganUser(List<Long> struIds, List<Long> userIds) {
        IamFeignQueryUserDTO feignQueryUserDTO = new IamFeignQueryUserDTO();
        feignQueryUserDTO.setStruIds(struIds);
        feignQueryUserDTO.setUserIds(userIds);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_USER_BY_ORGAN_USER, (Object)feignQueryUserDTO, new TypeReference<List<UserVo>>(){});
    }

    public List<OrganUserTreeVo> lazyOrganUserTree(List<Long> parentOrganIds, Boolean needParentOrganInfo, Integer resultType) {
        IamFeignQueryOrganUserDTO feignQueryOrganUserDTO = new IamFeignQueryOrganUserDTO();
        feignQueryOrganUserDTO.setParentOrganIds(parentOrganIds);
        feignQueryOrganUserDTO.setNeedParentOrganInfo(needParentOrganInfo);
        feignQueryOrganUserDTO.setResultType(resultType);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_LAZY_ORGAN_USER_TREE, (Object)feignQueryOrganUserDTO, new TypeReference<List<OrganUserTreeVo>>(){});
    }

    public Page<SearchUserTreeVo> searchUser(long size, long current, SearchOrganUserDto searchOrganUserDto) {
        IamSearchOrganUserDto organUserDto = new IamSearchOrganUserDto();
        organUserDto.setSize(size);
        organUserDto.setCurrent(current);
        organUserDto.setName(searchOrganUserDto.getName());
        organUserDto.setResultType(searchOrganUserDto.getResultType());
        organUserDto.setOrganIds(searchOrganUserDto.getOrganIds());
        organUserDto.setUserIds(searchOrganUserDto.getUserIds());
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_SEARCH_USER, (Object)organUserDto, new TypeReference<Page<SearchUserTreeVo>>(){});
    }

    public UserStaffVo getUserAndStaffInfo(Long userId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_USER_STAFF_BY_ID, (Object)userId, UserStaffVo.class);
    }

    public Page<SearchUserVo> searchUsers(long size, long current, QueryUserDto queryUserDto) {
        IamFeignSearchUserDTO feignSearchUserDTO = new IamFeignSearchUserDTO();
        feignSearchUserDTO.setSize(size);
        feignSearchUserDTO.setCurrent(current);
        feignSearchUserDTO.setQueryUserDto(queryUserDto);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_SEARCH_USERS, (Object)feignSearchUserDTO, new TypeReference<Page<SearchUserVo>>(){});
    }

    public Map<Long, SysUsers> getUserInfo(List<Long> userIds) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_USER_INFO, userIds, new TypeReference<Map<Long, SysUsers>>(){});
    }

    public Page<SearchUserVo> getUserList(long size, long current, String userName, String userAccount) {
        IamFeignSearchUserDTO feignSearchUserDTO = new IamFeignSearchUserDTO();
        feignSearchUserDTO.setSize(size);
        feignSearchUserDTO.setCurrent(current);
        QueryUserDto queryUserDto = new QueryUserDto();
        queryUserDto.setUserName(userName);
        queryUserDto.setUserAccount(userAccount);
        feignSearchUserDTO.setQueryUserDto(queryUserDto);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_USER_LIST, (Object)feignSearchUserDTO, new TypeReference<Page<SearchUserVo>>(){});
    }

    public List<UserVo> getUserInfoByRoleId(List<Long> roleIds) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_USER_INFO_BY_ROLE_ID, roleIds, new TypeReference<List<UserVo>>(){});
    }

    public List<UserVo> getUsersByPostIds(List<Long> postIds) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_USERS_BY_POST_ID, postIds, new TypeReference<List<UserVo>>(){});
    }

    public List<SysStruUser> getStruUserByStruIds(List<Long> struIds) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_STRU_USER_BY_STRU_IDS, struIds, new TypeReference<List<SysStruUser>>(){});
    }

    public List<String> getUserIdsByUserIdsAndRolePermission(List<Long> userIds, String rolePermission) {
        IamFeignQueryUserDTO feignQueryUserDTO = new IamFeignQueryUserDTO();
        feignQueryUserDTO.setUserIds(userIds);
        feignQueryUserDTO.setRolePermission(rolePermission);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_USER_BY_USER_ID_AND_PERMISSION, (Object)feignQueryUserDTO, new TypeReference<List<String>>(){});
    }
}

