/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.http.service.permission;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryFunctionModuleDto;
import com.jxdinfo.hussar.iam.base.sdk.api.enums.SdkUrlEnum;
import com.jxdinfo.hussar.iam.base.sdk.api.treemodel.JSTreeModel;
import com.jxdinfo.hussar.iam.base.sdk.http.utils.SdkHttpUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseFunctionService {
    public SysFunctions getById(Long id) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_BY_ID, (Object)id, SysFunctions.class);
    }

    public Boolean updateById(SysFunctions sysFunctions) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_UPDATE_BY_ID, (Object)sysFunctions, Boolean.class);
    }

    public Boolean save(SysFunctions sysFunctions) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_SAVE, (Object)sysFunctions, Boolean.class);
    }

    public Integer getMaxOrderByParentId(Long moduleId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_MAX_ORDER_BY_PARENT_ID, (Object)moduleId, Integer.class);
    }

    public List<SysFunctionModules> moduleList(String moduleName, Long parentModuleId) {
        IamQueryFunctionModuleDto iamQueryFunctionModuleDto = new IamQueryFunctionModuleDto();
        iamQueryFunctionModuleDto.setModuleName(moduleName);
        iamQueryFunctionModuleDto.setParentModuleId(parentModuleId);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_MODULE_LIST, (Object)iamQueryFunctionModuleDto, new TypeReference<List<SysFunctionModules>>(){});
    }

    public Boolean saveModule(SysFunctionModules sysFunctionModules) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_SAVE_MODULE, (Object)sysFunctionModules, Boolean.class);
    }

    public Integer getMaxOrderByParentIdAndAppId(Long moduleId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_MAX_ORDER_BY_PARENT_ID_AND_APP_ID, (Object)moduleId, Integer.class);
    }

    public List<JSTreeModel> getFunModuleMergeTreeForOrg(String functionFlag) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_FUNC_MODULE_TREE_FOR_ORG, (Object)functionFlag, new TypeReference<List<JSTreeModel>>(){});
    }

    public List<SysFunctions> listByIds(Collection<? extends Serializable> idList) {
        if (HussarUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_LIST_BY_IDS, idList, new TypeReference<List<SysFunctions>>(){});
    }

    public SysModuleFunctionsVo getFunctionDetail(Long functionId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_FUNCTION_GET_FUNCTION_DETAIL, (Object)functionId, SysModuleFunctionsVo.class);
    }
}

