/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.htsz.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.htsz.extend.dao.SysTenantDataPushMapper;
import com.jxdinfo.hussar.htsz.extend.dto.QuerySysTenantDataPushDto;
import com.jxdinfo.hussar.htsz.extend.model.SysTenantDataPush;
import com.jxdinfo.hussar.htsz.extend.service.ISysTenantDataPushService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.dto.QueryTenantDto;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SolitaryGroupingModelTenant;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysTenantDataPushServiceImpl
extends HussarBaseServiceImpl<SysTenantDataPushMapper, SysTenantDataPush>
implements ISysTenantDataPushService {
    @Resource
    private IHussarBaseTenantService<SolitaryGroupingModelTenant> hussarBaseTenantService;

    public Page<SysTenantDataPush> searchConfigList(QuerySysTenantDataPushDto queryDto) {
        Page tenantDataPushPage;
        ArrayList<String> tenantCodes = new ArrayList<String>();
        QueryTenantDto queryTenantDto = new QueryTenantDto();
        queryTenantDto.setTenantName(queryDto.getTenantName());
        queryTenantDto.setSize(Integer.MAX_VALUE);
        Page tenants = this.hussarBaseTenantService.searchTenant(queryTenantDto);
        if (HussarUtils.isEmpty((Object)tenants.getRecords())) {
            return new Page();
        }
        HashMap<String, String> tenantCodeNameMap = new HashMap<String, String>();
        for (SolitaryGroupingModelTenant solitaryGroupingModelTenant : tenants.getRecords()) {
            tenantCodes.add(solitaryGroupingModelTenant.getTenantCode());
            tenantCodeNameMap.put(solitaryGroupingModelTenant.getTenantCode(), solitaryGroupingModelTenant.getTenantName());
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getTenantName())) {
            LambdaUpdateWrapper queryWrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate().in(HussarUtils.isNotEmpty(tenantCodes), SysTenantDataPush::getTenantCode, tenantCodes);
            tenantDataPushPage = (Page)this.page((IPage)new Page((long)queryDto.getCurrent().intValue(), (long)queryDto.getSize().intValue()), (Wrapper)queryWrapper);
        } else {
            tenantDataPushPage = (Page)this.page((IPage)new Page((long)queryDto.getCurrent().intValue(), (long)queryDto.getSize().intValue()));
        }
        for (SysTenantDataPush sysTenantDataPush : tenantDataPushPage.getRecords()) {
            String tenantCode = sysTenantDataPush.getTenantCode();
            String tenantName = (String)tenantCodeNameMap.get(tenantCode);
            sysTenantDataPush.setTenantName(tenantName);
        }
        return tenantDataPushPage;
    }
}

