/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.htsz.extend.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.vo.OrgUserNameVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.htsz.extend.organ.dao.AssigneeEyMapper;
import com.jxdinfo.hussar.htsz.extend.organ.dao.SysStruHtszMapper;
import com.jxdinfo.hussar.htsz.extend.organ.model.JSTreeModelMdm;
import com.jxdinfo.hussar.htsz.extend.organ.model.SysPostStru;
import com.jxdinfo.hussar.htsz.extend.organ.service.HussarDsOrganHtszService;
import com.jxdinfo.hussar.htsz.extend.organ.service.ILocalOrganizationHtszBoService;
import com.jxdinfo.hussar.htsz.extend.organ.service.ISysPostStruService;
import com.jxdinfo.hussar.htsz.extend.properties.HtszProperties;
import com.jxdinfo.hussar.htsz.extend.util.ForestNodeMergerMdm;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LocalHussarBaseOrganizationHtszBoServiceImpl
implements ILocalOrganizationHtszBoService {
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysPostStruService postStruService;
    @Autowired
    private SysStruHtszMapper sysStruHtszMapper;
    @Autowired
    private HussarDsOrganHtszService hussarDsOrganHtszService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Resource
    private AssigneeEyMapper assigneeEyMapper;
    @Autowired
    private HtszProperties htszProperties;
    private static String HTSZ_ROOT_CODE = "0000";
    private static String HTSZ_ROOT_PARENT = "";

    public List<JSTreeModel> getOrgTree(Map<String, Object> map) {
        HussarTenantDefinition tenant;
        String label = map.get("label") == null ? null : map.get("label").toString();
        Long parentId = map.get("struId") == null ? 0L : Long.parseLong(map.get("struId").toString());
        String flag = map.get("flag") == null ? "true" : map.get("flag").toString();
        List list = new ArrayList();
        ArrayList<Object> result = new ArrayList<Object>();
        JSTreeModel root = new JSTreeModel();
        root.setCode(Constants.ROOT_NODE_ID.toString());
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        JSTreeModel rootOut = new JSTreeModel();
        rootOut.setCode(Constants.OUT_STRU_NODE_ID.toString());
        rootOut.setText("\u5916\u90e8\u7ec4\u7ec7\u673a\u6784");
        rootOut.setIsLeaf("0");
        rootOut.setParent(Constants.ROOT_NODE_PARENT);
        rootOut.setStruLevel("0");
        rootOut.setType("isRoot");
        String connName = "master";
        if ("platformLevel".equals(label)) {
            connName = "master";
        } else if ("factoryLevel".equals(label) && HussarUtils.isNotEmpty((Object)(tenant = HussarContextHolder.getHussarTenant()))) {
            connName = tenant.getConnName();
        }
        if (flag.equals("true")) {
            List outList = new ArrayList();
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentId)) {
                root.setId(Constants.ROOT_NODE_ID);
                root.setChildren(true);
                parentId = Constants.ROOT_NODE_ID;
                result.add(root);
                rootOut.setId(Constants.OUT_STRU_NODE_ID);
                outList = this.hussarDsOrganHtszService.getJsTreeModelsLazy(connName, Constants.OUT_STRU_NODE_ID);
                rootOut.setChildren(!outList.isEmpty());
                result.add(rootOut);
            }
            list = this.hussarDsOrganHtszService.getJsTreeModelsLazy(connName, parentId);
            list.addAll(outList);
        } else {
            root.setId(Constants.ROOT_NODE_ID);
            list = this.hussarDsOrganHtszService.getJsTreeModelsNoLazy(connName);
            result.add(root);
        }
        result.addAll(list);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            JSTreeModel jsTreeModel;
            jsTreeModel.setIsFinalNode(!(jsTreeModel = (JSTreeModel)iterator.next()).isChildren());
        }
        return ForestNodeMerger.merge(result);
    }

    public List<JSTreeModelMdm> getOrgTreeMdm(Map<String, Object> map) {
        HussarTenantDefinition tenant;
        String label = map.get("label") == null ? null : map.get("label").toString();
        String parentCode = map.get("struId") == null ? Constants.ROOT_NODE_PARENT.toString() : map.get("struId").toString();
        String flag = map.get("flag") == null ? "true" : map.get("flag").toString();
        List list = new ArrayList();
        ArrayList<JSTreeModelMdm> result = new ArrayList<JSTreeModelMdm>();
        String connName = "master";
        if ("platformLevel".equals(label)) {
            connName = "master";
        } else if ("factoryLevel".equals(label) && HussarUtils.isNotEmpty((Object)(tenant = HussarContextHolder.getHussarTenant()))) {
            connName = tenant.getConnName();
        }
        list = "true".equals(flag) ? (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT.toString(), (Object)parentCode) ? this.hussarDsOrganHtszService.getJsTreeModelsLazyMdm(connName, HTSZ_ROOT_PARENT) : this.hussarDsOrganHtszService.getJsTreeModelsLazyMdm(connName, parentCode)) : this.hussarDsOrganHtszService.getJsTreeModelsNoLazyMdm(connName);
        result.addAll(list);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            JSTreeModelMdm jsTreeModel;
            jsTreeModel.setIsFinalNode(!(jsTreeModel = (JSTreeModelMdm)iterator.next()).isChildren());
        }
        return ForestNodeMergerMdm.merge(result);
    }

    public List<SysStaff> queryUserStaff(Map<String, Object> map) {
        HussarTenantDefinition tenant;
        String label = map.get("label") == null ? null : map.get("label").toString();
        String struId = map.get("struId") == null ? null : map.get("struId").toString();
        String connName = "master";
        if ("platformLevel".equals(label)) {
            connName = "master";
        } else if ("factoryLevel".equals(label) && HussarUtils.isNotEmpty((Object)(tenant = HussarContextHolder.getHussarTenant()))) {
            connName = tenant.getConnName();
        }
        if ("mdm".equals(this.htszProperties.getOrganDatasource())) {
            struId = this.hussarDsOrganHtszService.getStruIdByMdmCode(connName, struId);
        }
        if (HussarUtils.isEmpty((Object)struId)) {
            return Lists.newArrayList();
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        SysStru depStru = this.hussarDsOrganHtszService.getSysStruById(connName, Long.valueOf(struId));
        if (ToolUtil.isNotEmpty((Object)depStru)) {
            List orgList = this.hussarDsOrganHtszService.getOrgTree(connName, null);
            List<JSTreeModel> list = this.filterChildTreeNodeByStru(orgList, depStru);
            for (JSTreeModel jsTreeModel : list) {
                Long treeId = jsTreeModel.getId();
                idList.add(treeId);
            }
        } else {
            return new ArrayList<SysStaff>();
        }
        List staffIds = new ArrayList();
        if (!HussarUtils.isNotEmpty(idList) || idList.size() <= 0) {
            return new ArrayList<SysStaff>();
        }
        staffIds = this.hussarDsOrganHtszService.selectBatchOrganStaffId(connName, idList);
        if (HussarUtils.isEmpty(staffIds)) {
            return new ArrayList<SysStaff>();
        }
        return this.hussarDsOrganHtszService.queryUserStaff(staffIds);
    }

    @HussarDs(value="master")
    public List<OrgUserNameVo> getOrgUerInfo(Map<String, Object> map) {
        String type = map.get("type") == null ? "" : map.get("type").toString();
        String ids = map.get("ids") == null ? null : map.get("ids").toString();
        AssertUtil.isNotEmpty((String)ids, (String)"\u53c2\u6570\u9519\u8bef");
        List<Long> struIdOrStaffIds = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        ArrayList<OrgUserNameVo> result = new ArrayList<OrgUserNameVo>();
        switch (type) {
            case "1": {
                result.addAll(this.getOrganName(struIdOrStaffIds));
                break;
            }
            case "2": {
                result.addAll(this.getStaffName(struIdOrStaffIds));
                break;
            }
            case "3": {
                result.addAll(this.getStaffNameWithUserId(struIdOrStaffIds));
                break;
            }
            default: {
                result.addAll(this.getOrganName(struIdOrStaffIds));
                result.addAll(this.getStaffName(struIdOrStaffIds));
                result.addAll(this.getPostStruName(struIdOrStaffIds));
            }
        }
        return result;
    }

    public List<JSTreeModel> getSpecialOrgTree(String label, String orgName) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long permissionStruId = null;
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        String connName = "master";
        if ("factoryLevel".equals(label)) {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)user.getDeptId()));
            permissionStruId = sysStru.getPermissionStruId();
            HussarTenantDefinition tenant = HussarContextHolder.getHussarTenant();
            if (HussarUtils.isNotEmpty((Object)tenant)) {
                connName = tenant.getConnName();
            }
        } else if ("platformLevel".equals(label)) {
            connName = "master";
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(Constants.ROOT_NODE_ID.toString());
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        root.setState(false, false, true);
        result.add(root);
        List allList = this.hussarDsOrganHtszService.getOrgTree(connName, null);
        List orgList = this.hussarDsOrganHtszService.getSpecialOrgTree(connName, SqlQueryUtil.transferSpecialChar((String)orgName), permissionStruId);
        if (!orgList.isEmpty()) {
            orgList.forEach(org -> {
                StringBuilder parentName = new StringBuilder();
                this.getTreeParentNames(allList, org.getParent(), parentName);
                if (HussarUtils.isNotEmpty((Object)parentName)) {
                    org.setText(org.getText() + "(" + parentName + ")");
                }
                org.setParent(Constants.ROOT_NODE_ID);
            });
        } else {
            result = new ArrayList();
        }
        result.addAll(orgList);
        return ForestNodeMerger.merge(result);
    }

    private void getTreeParentNames(List<JSTreeModel> allTreeList, Long struId, StringBuilder parentName) {
        for (JSTreeModel treeNode : allTreeList) {
            if (ToolUtil.isEmpty((Object)treeNode.getParent()) || !struId.equals(treeNode.getId())) continue;
            parentName.append("/" + treeNode.getText());
            this.getTreeParentNames(allTreeList, treeNode.getParent(), parentName);
        }
    }

    @HussarDs(value="master")
    private List<OrgUserNameVo> getOrganName(Collection<Long> struIds) {
        List<Map<String, Object>> orgStru = this.sysStruHtszMapper.queryOrgStru(struIds);
        ArrayList<OrgUserNameVo> result = new ArrayList<OrgUserNameVo>();
        if (HussarUtils.isNotEmpty(orgStru)) {
            this.sortByIds(orgStru, struIds);
            for (Map<String, Object> item : orgStru) {
                OrgUserNameVo orgUserNameVo = new OrgUserNameVo();
                orgUserNameVo.setId(Long.valueOf(Long.parseLong(item.get("id").toString())));
                orgUserNameVo.setOrganName(item.get("organName").toString());
                result.add(orgUserNameVo);
            }
        }
        return result;
    }

    private List<OrgUserNameVo> getPostStruName(Collection<Long> struIds) {
        List postStruList = this.postStruService.list((Wrapper)new LambdaQueryWrapper().in(SysPostStru::getStruId, struIds));
        ArrayList<OrgUserNameVo> result = new ArrayList<OrgUserNameVo>();
        if (HussarUtils.isNotEmpty((Object)postStruList)) {
            this.sortByIds(postStruList, struIds);
            for (SysPostStru item : postStruList) {
                OrgUserNameVo orgUserNameVo = new OrgUserNameVo();
                orgUserNameVo.setId(item.getStruId());
                orgUserNameVo.setOrganName(item.getOrganName());
                result.add(orgUserNameVo);
            }
        }
        return result;
    }

    private <T> void sortByIds(List<T> itemList, Collection<Long> ids) {
        ArrayList<Long> idList = new ArrayList<Long>(ids);
        itemList.sort(Comparator.comparingInt(item -> idList.indexOf(this.getId(item))));
    }

    private Long getId(Object o) {
        if (o instanceof SysPostStru) {
            return ((SysPostStru)o).getStruId();
        }
        if (o instanceof Map) {
            return Long.parseLong(((Map)o).get("id").toString());
        }
        if (o instanceof SysStaff) {
            return ((SysStaff)o).getId();
        }
        throw new BaseException("\u4f20\u5165\u53c2\u6570\u9519\u8bef");
    }

    private List<OrgUserNameVo> getStaffName(Collection<Long> staffIds) {
        List staffList = this.sysStaffMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStaff::getId, staffIds));
        ArrayList<OrgUserNameVo> result = new ArrayList<OrgUserNameVo>();
        if (HussarUtils.isNotEmpty((Object)staffList)) {
            this.sortByIds(staffList, staffIds);
            for (SysStaff item : staffList) {
                OrgUserNameVo orgUserNameVo = new OrgUserNameVo();
                orgUserNameVo.setStruId(item.getId());
                orgUserNameVo.setName(item.getName());
                result.add(orgUserNameVo);
            }
        }
        return result;
    }

    private List<OrgUserNameVo> getStaffNameWithUserId(Collection<Long> staffIds) {
        List staffList;
        Map<Long, List<SysUsers>> employee;
        ArrayList<OrgUserNameVo> result = new ArrayList<OrgUserNameVo>();
        List usersList = this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getEmployeeId, staffIds));
        if (HussarUtils.isNotEmpty((Object)usersList) && HussarUtils.isNotEmpty(employee = usersList.stream().filter(a -> HussarUtils.isNotEmpty((Object)a.getEmployeeId())).collect(Collectors.groupingBy(SysUsers::getEmployeeId))) && HussarUtils.isNotEmpty((Object)(staffList = this.sysStaffMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStaff::getId, employee.keySet()))))) {
            this.sortByIds(staffList, staffIds);
            for (SysStaff item : staffList) {
                OrgUserNameVo orgUserNameVo = new OrgUserNameVo();
                orgUserNameVo.setStruId(item.getId());
                orgUserNameVo.setName(item.getName());
                orgUserNameVo.setUserId(employee.get(item.getId()).get(0).getId());
                result.add(orgUserNameVo);
            }
        }
        return result;
    }

    private List<JSTreeModel> filterChildTreeNodeByStru(List<JSTreeModel> allTreeList, SysStru depStru) {
        ArrayList returnTreeNodeList = com.google.common.collect.Lists.newArrayList();
        HashMap<Long, Long> childStruIdMap = new HashMap<Long, Long>();
        for (JSTreeModel treeNode : allTreeList) {
            Long struId = treeNode.getId();
            Long parentStruId = treeNode.getParent();
            childStruIdMap.put(struId, parentStruId);
        }
        Long depStruId = depStru.getId();
        ArrayList<Long> childStrIdList = new ArrayList<Long>();
        this.getAllChilden(childStruIdMap, childStrIdList, depStruId);
        for (JSTreeModel treeModel : allTreeList) {
            if (depStru.getId().equals(treeModel.getId())) {
                treeModel.setParent(Constants.ROOT_NODE_ID);
                returnTreeNodeList.add(treeModel);
                continue;
            }
            if (!childStrIdList.contains(treeModel.getId())) continue;
            returnTreeNodeList.add(treeModel);
        }
        return returnTreeNodeList;
    }

    private void getAllChilden(Map<Long, Long> childIdMap, List<Long> childIdList, Long struId) {
        List<Long> tmpList;
        if (childIdMap.containsValue(struId) && (tmpList = this.getKey(childIdMap, struId)).size() > 0) {
            for (Long item : tmpList) {
                childIdList.add(item);
                this.getAllChilden(childIdMap, childIdList, item);
            }
        }
    }

    private List<Long> getKey(Map<Long, Long> map, Object value) {
        Set<Map.Entry<Long, Long>> set = map.entrySet();
        Iterator<Map.Entry<Long, Long>> iterator = set.iterator();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Map.Entry<Long, Long> entry = iterator.next();
            if (!entry.getValue().equals(value)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }
}

