/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.htsz.extend.organ.service.impl;

import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.htsz.extend.organ.dao.AssigneeEyMapper;
import com.jxdinfo.hussar.htsz.extend.organ.dao.SysStruHtszMapper;
import com.jxdinfo.hussar.htsz.extend.organ.model.JSTreeModelMdm;
import com.jxdinfo.hussar.htsz.extend.organ.service.HussarDsOrganHtszService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class HussarDsOrganHtszServiceImpl
implements HussarDsOrganHtszService {
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStruHtszMapper sysStruHtszMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private AssigneeEyMapper assigneeEyMapper;

    @HussarDs(value="#connName")
    public List<JSTreeModel> getJsTreeModelsLazy(String connName, Long parentId) {
        return this.sysStruMapper.getLazyLoadingOrgTree(null, parentId);
    }

    @HussarDs(value="#connName")
    public List<JSTreeModel> getJsTreeModelsNoLazy(String connName) {
        List list = this.sysStruMapper.getOrgTree(null);
        return list;
    }

    @HussarDs(value="master")
    public List<JSTreeModelMdm> getJsTreeModelsLazyMdm(String connName, String parentCode) {
        List<JSTreeModelMdm> list = this.sysStruHtszMapper.getLazyLoadingOrgTreeMdm(parentCode);
        list.sort(Comparator.comparing(model -> {
            String struOrder = model.getStruOrder();
            if (struOrder == null) {
                return Integer.MAX_VALUE;
            }
            try {
                return Integer.parseInt(struOrder);
            }
            catch (NumberFormatException e) {
                return Integer.MAX_VALUE;
            }
        }));
        return list;
    }

    @HussarDs(value="master")
    public List<JSTreeModelMdm> getJsTreeModelsNoLazyMdm(String connName) {
        List<JSTreeModelMdm> list = this.sysStruHtszMapper.getOrgTreeMdm();
        list.sort(Comparator.comparing(model -> {
            String struOrder = model.getStruOrder();
            if (struOrder == null) {
                return Integer.MAX_VALUE;
            }
            try {
                return Integer.parseInt(struOrder);
            }
            catch (NumberFormatException e) {
                return Integer.MAX_VALUE;
            }
        }));
        Set parentSet = list.stream().map(JSTreeModelMdm::getParent).collect(Collectors.toSet());
        for (JSTreeModelMdm model2 : list) {
            if (!parentSet.contains(model2.getId())) {
                model2.setChildren("true");
                continue;
            }
            model2.setChildren("false");
        }
        return list;
    }

    @HussarDs(value="#connName")
    public String getStruIdByMdmCode(String connName, String code) {
        if (code == null) {
            return null;
        }
        List<String> idList = this.sysStruHtszMapper.getStruIdByMdmCode(code);
        if (idList.size() > 0) {
            return idList.get(0);
        }
        return null;
    }

    @HussarDs(value="#connName")
    public List<JSTreeModel> getOrgTree(String connName, String isEmployee) {
        return this.sysStruMapper.getOrgTree(null);
    }

    @HussarDs(value="#connName")
    public List<JSTreeModel> getSpecialOrgTree(String connName, String orgName, Long permissionStruId) {
        return this.sysStruHtszMapper.getSpecialOrgTree(orgName, permissionStruId);
    }

    @HussarDs(value="#connName")
    public SysStru getSysStruById(String connName, Long struId) {
        return (SysStru)this.sysStruMapper.selectById((Serializable)struId);
    }

    @HussarDs(value="#connName")
    public List<Long> selectBatchOrganStaffId(String connName, List<Long> organIds) {
        return this.sysStaffMapper.selectBatchOrganStaffId(organIds);
    }

    @HussarDs(value="#connName")
    public List<SysStaff> queryUserStaff(List<Long> staffIds) {
        return this.assigneeEyMapper.queryUserStaff(staffIds);
    }
}

