/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.htsz.extend.organ.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.htsz.extend.organ.model.UserVInfo;
import com.jxdinfo.hussar.htsz.extend.organ.service.HussarDsOrganHtszService;
import com.jxdinfo.hussar.htsz.extend.organ.service.IHussarBaseSysOrgManageService;
import com.jxdinfo.hussar.htsz.extend.permit.service.IHussarBaseUserVInfoService;
import com.jxdinfo.hussar.htsz.extend.properties.HtszProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.service.impl.hussarBaseSysOrgManageServiceImpl")
public class HussarBaseSysOrgManageServiceImpl
implements IHussarBaseSysOrgManageService {
    @Autowired
    private IHussarBaseUserVInfoService userVInfoService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private HussarDsOrganHtszService hussarDsOrganHtszService;
    @Autowired
    private HtszProperties htszProperties;

    public List<UserVInfo> querySelectParts(BpmResponseResult bpmResponseResult, String processDefinitionKey, String taskId, String nodeId, String endEvent, String selectData, String filterCandidate) {
        JSONArray jsonArray;
        String realStruId = filterCandidate;
        if ("mdm".equals(this.htszProperties.getOrganDatasource()) && HussarUtils.isNotEmpty((Object)filterCandidate)) {
            HussarTenantDefinition tenant = HussarContextHolder.getHussarTenant();
            String connName = "master";
            if (HussarUtils.isNotEmpty((Object)tenant)) {
                connName = tenant.getConnName();
            }
            if (ToolUtil.isEmpty((Object)(realStruId = this.hussarDsOrganHtszService.getStruIdByMdmCode(connName, filterCandidate)))) {
                return new ArrayList<UserVInfo>();
            }
        }
        HashMap userMap = this.userVInfoService.querySelectParts(realStruId, selectData);
        ArrayList<UserVInfo> userResults = new ArrayList<UserVInfo>();
        if ("1".equals(bpmResponseResult.getCode()) && ToolUtil.isNotEmpty((Object)(jsonArray = bpmResponseResult.getResult())) && !jsonArray.isEmpty()) {
            for (Object userObject : jsonArray) {
                HashMap user = (HashMap)JSON.parseObject((String)JSON.toJSONString(userObject), HashMap.class);
                UserVInfo userVInfo = (UserVInfo)userMap.get(user.get("id"));
                if (!HussarUtils.isNotEmpty((Object)userVInfo) || !userResults.stream().noneMatch(u -> u.getUserId().equals(userVInfo.getUserId()))) continue;
                userResults.add(userVInfo);
            }
        }
        if (ToolUtil.isNotEmpty(userResults) && !userResults.isEmpty()) {
            for (UserVInfo userVInfo : userResults) {
                String userName = userVInfo.getUserName();
                String organName = userVInfo.getOrganName();
                if (HussarUtils.isNotEmpty((Object)organName)) {
                    userVInfo.setUserName(userName + "(" + organName + ")");
                    continue;
                }
                List sysStruUsers = this.sysStruUserService.list((Wrapper)Wrappers.lambdaQuery().eq(SysStruUser::getUserId, (Object)Long.parseLong(userVInfo.getUserId())));
                List sysStrus = this.sysStruService.list((Wrapper)Wrappers.lambdaQuery().in(HussarUtils.isNotEmpty((Object)sysStruUsers), SysStru::getId, (Collection)sysStruUsers.stream().map(SysStruUser::getStruId).collect(Collectors.toList())));
                if (!HussarUtils.isNotEmpty((Object)sysStrus)) continue;
                userVInfo.setUserName(userName + "(" + sysStrus.stream().map(SysStru::getOrganAlias).collect(Collectors.joining(",")) + ")");
            }
            userResults.sort(Comparator.comparing(UserVInfo::getOrganCode).thenComparing(UserVInfo::getSort));
        }
        return userResults;
    }
}

