/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.htsz.extend.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.htsz.extend.permit.dto.QueryRoleByIdsDto;
import com.jxdinfo.hussar.htsz.extend.permit.service.IHussarBaseRoleBoService;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.hussarBaseRoleBoServiceImpl")
public class HussarBaseRoleBoServiceImpl
implements IHussarBaseRoleBoService {
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysConfRolesetMapper sysConfRolesetMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;

    public List<Map<String, Object>> getRoleByStruId(Long struId) {
        if (HussarUtils.isEmpty((Object)struId)) {
            return Collections.emptyList();
        }
        return this.sysRolesMapper.getRolesByOrgId(struId);
    }

    public List<Map<String, Object>> getConfRolesetByStruId(Long struId) {
        if (HussarUtils.isEmpty((Object)struId)) {
            return Collections.emptyList();
        }
        return this.sysConfRolesetMapper.getRolesByOrgId(struId);
    }

    public List<JSTreeModel> selfRoleTree(List<Long> roleIds) {
        List splitIds = LambdaQueryUtil.getSplitList(roleIds);
        if (ToolUtil.isNotEmpty(roleIds)) {
            return this.sysRolesMapper.selfRoleTree(splitIds);
        }
        return new ArrayList<JSTreeModel>();
    }

    public List<SysRoles> getRolesByUserIdsAndRoleIds(QueryRoleByIdsDto queryRoleByIdsDto) {
        List userIds = queryRoleByIdsDto.getUserIds();
        ArrayList roleIds = queryRoleByIdsDto.getRoleIds();
        List<Object> rolesList = new ArrayList<SysRoles>();
        if (ToolUtil.isEmpty((Object)roleIds)) {
            roleIds = new ArrayList();
        }
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            List userRoleList = this.sysUserRoleMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUserRole::getUserId, (List)userIds));
            roleIds.addAll(userRoleList.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty(roleIds)) {
            rolesList = this.sysRolesMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoles::getId, roleIds));
        }
        return rolesList;
    }

    @CacheEvict(value={"authorization_info"}, key="'hussar_authInfo:'+#userId")
    public void delAuthCacheInfo(Long userId) {
        if (this.hussarTenantProperties.isEnabled() && this.tenantCommonService != null) {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            String code = null;
            if (ToolUtil.isNotEmpty((Object)securityUser)) {
                code = securityUser.getConnName();
            }
            HussarCacheUtil.evict((String)"menu_info", (Object)("hussar_menus:" + userId + code));
        } else {
            HussarCacheUtil.evict((String)"menu_info", (Object)("hussar_menus:" + userId));
        }
    }

    public List<JSTreeModel> getRoleTree(Long parentId) {
        return this.sysRolesMapper.getRoleTree(parentId);
    }

    public List<Map<String, Object>> getRolesByOrgId(Long orgId) {
        return this.sysRolesMapper.getRolesByOrgId(orgId);
    }

    public List<JSTreeModel> getLazyRoleTree(Long nodeId) {
        return this.sysRoleGroupService.getLazyRoleTree(nodeId);
    }

    public List<JSTreeModel> getSelfRoleTree(String[] roleIds) {
        return this.sysRolesService.getSelfRoleTree(roleIds);
    }
}

