/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.generator.engine.config;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.core.constant.IsMenu;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.generator.action.model.HussarGeneratorProperties;
import com.jxdinfo.hussar.generator.engine.config.ContextConfig;
import com.jxdinfo.hussar.generator.engine.config.Menu;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class SqlConfig {
    private String sqlPathTemplate;
    private ContextConfig contextConfig;
    private Connection connection;
    private String parentMenuName;
    private List<Menu> menus = new ArrayList<Menu>(6);
    private static Logger LOGGER = LoggerFactory.getLogger(SqlConfig.class);
    private HussarGeneratorProperties hussarProperties = (HussarGeneratorProperties)SpringContextHolder.getBean(HussarGeneratorProperties.class);

    public void init() {
        String environment = this.hussarProperties.getEnvironment();
        String pageLocal = "";
        pageLocal = "dyna".equals(environment) ? "\\src\\" : "\\src\\main\\java\\";
        this.sqlPathTemplate = pageLocal + "{}.sql";
        String[] pcodeAndPcodes = this.getPcodeAndPcodes();
        if (this.parentMenuName == null || pcodeAndPcodes == null) {
            LOGGER.error("\u7236\u7ea7\u83dc\u5355\u540d\u79f0\u8f93\u5165\u6709\u8bef!!!!");
            return;
        }
        Menu menu = new Menu();
        menu.setId(IdWorker.getId());
        menu.setCode(this.contextConfig.getBizEnName());
        menu.setPcode(pcodeAndPcodes[0]);
        menu.setPcodes(pcodeAndPcodes[1] + "[" + pcodeAndPcodes[0] + "],");
        menu.setName(this.contextConfig.getBizChName());
        menu.setIcon("");
        menu.setUrl("/" + this.contextConfig.getBizEnName());
        menu.setNum(99);
        if ("\u9876\u7ea7".equals(this.parentMenuName)) {
            menu.setLevels(1);
        } else {
            menu.setLevels(2);
        }
        menu.setIsmenu(IsMenu.YES.getCode());
        menu.setStatus(1);
        menu.setIsopen(0);
        this.menus.add(menu);
        Menu list = this.createSubMenu(menu);
        list.setCode(this.contextConfig.getBizEnName() + "_list");
        list.setName(this.contextConfig.getBizChName() + "\u5217\u8868");
        list.setUrl("/" + this.contextConfig.getBizEnName() + "/list");
        this.menus.add(list);
        Menu add = this.createSubMenu(menu);
        add.setCode(this.contextConfig.getBizEnName() + "_add");
        add.setName(this.contextConfig.getBizChName() + "\u6dfb\u52a0");
        add.setUrl("/" + this.contextConfig.getBizEnName() + "/add");
        this.menus.add(add);
        Menu update = this.createSubMenu(menu);
        update.setCode(this.contextConfig.getBizEnName() + "_update");
        update.setName(this.contextConfig.getBizChName() + "\u66f4\u65b0");
        update.setUrl("/" + this.contextConfig.getBizEnName() + "/update");
        this.menus.add(update);
        Menu delete = this.createSubMenu(menu);
        delete.setCode(this.contextConfig.getBizEnName() + "_delete");
        delete.setName(this.contextConfig.getBizChName() + "\u5220\u9664");
        delete.setUrl("/" + this.contextConfig.getBizEnName() + "/delete");
        this.menus.add(delete);
        Menu detail = this.createSubMenu(menu);
        detail.setCode(this.contextConfig.getBizEnName() + "_detail");
        detail.setName(this.contextConfig.getBizChName() + "\u8be6\u60c5");
        detail.setUrl("/" + this.contextConfig.getBizEnName() + "/detail");
        this.menus.add(detail);
    }

    private Menu createSubMenu(Menu parentMenu) {
        Menu menu = new Menu();
        menu.setId(IdWorker.getId());
        menu.setPcode(parentMenu.getCode());
        menu.setPcodes(parentMenu.getPcodes() + "[" + parentMenu.getCode() + "],");
        menu.setIcon("");
        menu.setNum(99);
        menu.setLevels(parentMenu.getLevels() + 1);
        menu.setIsmenu(IsMenu.NO.getCode());
        menu.setStatus(1);
        menu.setIsopen(0);
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPcodeAndPcodes() {
        if ("\u9876\u7ea7".equals(this.parentMenuName)) {
            return new String[]{"0", ""};
        }
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        try {
            preparedStatement = this.connection.prepareStatement("select * from sys_menu where name like ?");
            preparedStatement.setString(1, "%" + this.parentMenuName + "%");
            results = preparedStatement.executeQuery();
            if (results.next()) {
                String pcode = results.getString("code");
                String pcodes = results.getString("pcodes");
                if (ToolUtil.isNotEmpty((Object)pcode) && ToolUtil.isNotEmpty((Object)pcodes)) {
                    String[] strings;
                    String[] stringArray = strings = new String[]{pcode, pcodes};
                    return stringArray;
                }
                String[] stringArray = null;
                return stringArray;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public void setContextConfig(ContextConfig contextConfig) {
        this.contextConfig = contextConfig;
    }

    public String getParentMenuName() {
        return this.parentMenuName;
    }

    public void setParentMenuName(String parentMenuName) {
        this.parentMenuName = parentMenuName;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getSqlPathTemplate() {
        return this.sqlPathTemplate;
    }

    public void setSqlPathTemplate(String sqlPathTemplate) {
        this.sqlPathTemplate = sqlPathTemplate;
    }

    public List<Menu> getMenus() {
        return this.menus;
    }

    public void setMenus(List<Menu> menus) {
        this.menus = menus;
    }
}

