/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.generator.engine.base;

import com.jxdinfo.hussar.bsp.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.bsp.menu.model.SysMenu;
import com.jxdinfo.hussar.bsp.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.bsp.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysModulesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysFunctions;
import com.jxdinfo.hussar.bsp.permit.model.SysModules;
import com.jxdinfo.hussar.bsp.permit.model.SysResources;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleResource;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResManageService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.bsp.permit.vo.SysResourcesVo;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.generator.engine.base.AbstractTemplateEngine;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HussarTemplateEngine
extends AbstractTemplateEngine {
    private ISysResManageService sysResManageService = (ISysResManageService)SpringContextHolder.getBean(ISysResManageService.class);
    private ISysIdtableService sysIdtableService = (ISysIdtableService)SpringContextHolder.getBean(ISysIdtableService.class);
    private ISysRoleResourceService sysRoleResourceService = (ISysRoleResourceService)SpringContextHolder.getBean(ISysRoleResourceService.class);
    private ISysMenuManageService sysMenuManageService = (ISysMenuManageService)SpringContextHolder.getBean(ISysMenuManageService.class);
    private SysModulesMapper sysModulesMapper = (SysModulesMapper)SpringContextHolder.getBean(SysModulesMapper.class);
    private SysFunctionsMapper sysFunctionsMapper = (SysFunctionsMapper)SpringContextHolder.getBean(SysFunctionsMapper.class);
    private SysUserRoleMapper sysUserRoleMapper = (SysUserRoleMapper)SpringContextHolder.getBean(SysUserRoleMapper.class);
    private SysResourcesMapper sysResourcesMapper = (SysResourcesMapper)SpringContextHolder.getBean(SysResourcesMapper.class);
    private SysMenuMapper sysMenuMapper = (SysMenuMapper)SpringContextHolder.getBean(SysMenuMapper.class);
    private static Logger logger = LoggerFactory.getLogger(HussarTemplateEngine.class);
    private SysModules sysModules = new SysModules();
    private SysFunctions sysFunctions = new SysFunctions();
    private List<SysModules> modulesList = new ArrayList<SysModules>(1);
    private List<SysFunctions> functionsList = new ArrayList<SysFunctions>(1);
    private List<SysResources> resourcesList = new ArrayList<SysResources>(6);
    private List<SysRoleResource> roleResourceList = new ArrayList<SysRoleResource>(6);
    private List<SysMenu> menuList = new ArrayList<SysMenu>(2);
    private GroupTemplate groupTemplate;

    public HussarTemplateEngine() {
        this.initBeetlEngine();
    }

    private void initBeetlEngine() {
        Properties properties = new Properties();
        properties.put("RESOURCE.root", "");
        properties.put("DELIMITER_STATEMENT_START", "<%");
        properties.put("DELIMITER_STATEMENT_END", "%>");
        properties.put("HTML_TAG_FLAG", "##");
        Configuration cfg = null;
        try {
            cfg = new Configuration(properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader();
        this.groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
        this.groupTemplate.registerFunctionPackage("tool", (Object)new ToolUtil());
    }

    private void configTemplate(Template template) {
        template.binding("controller", (Object)this.controllerConfig);
        template.binding("context", (Object)this.contextConfig);
        template.binding("dao", (Object)this.daoConfig);
        template.binding("service", (Object)this.serviceConfig);
        template.binding("sqls", (Object)this.sqlConfig);
        template.binding("resourceSqls", (Object)this.resourceSqlConfig);
        template.binding("menuSqls", (Object)this.menuSqlConfig);
        template.binding("table", (Object)this.tableInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateFile(String template, String filePath) {
        Template pageTemplate = this.groupTemplate.getTemplate(template);
        this.configTemplate(pageTemplate);
        String os = System.getProperty("os.name");
        String path = os.startsWith("Windows") ? filePath.replaceAll("/+|\\\\+", "\\\\") : filePath.replaceAll("/+|\\\\+", "/");
        File file = new File(path);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            pageTemplate.renderTo((OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void start() {
        super.initConfig();
        if (this.contextConfig.getControllerSwitch().booleanValue()) {
            this.generateController();
        }
        if (this.contextConfig.getIndexPageSwitch().booleanValue()) {
            this.generatePageHtml();
        }
        if (this.contextConfig.getAddPageSwitch().booleanValue()) {
            this.generatePageAddHtml();
        }
        if (this.contextConfig.getEditPageSwitch().booleanValue()) {
            this.generatePageEditHtml();
        }
        if (this.contextConfig.getJsSwitch().booleanValue()) {
            this.generatePageJs();
        }
        if (this.contextConfig.getInfoJsSwitch().booleanValue()) {
            this.generatePageInfoJs();
        }
        this.createResource();
        if (this.contextConfig.getSqlSwitch().booleanValue()) {
            this.generateSqls();
        }
        if (this.contextConfig.getResourceSqlSwitch().booleanValue()) {
            this.generateResourceSqls(this.modulesList, this.functionsList, this.resourcesList, this.roleResourceList);
        }
        if (this.contextConfig.getMenuSqlSwitch().booleanValue()) {
            this.generateMenuSqls(this.menuList);
        }
    }

    public void createResource() {
        String[][] res = new String[][]{{"view", "add", "delete", "update", "list", "detail"}, {"\u9875\u9762", "\u589e\u52a0", "\u5220\u9664", "\u4fee\u6539", "\u67e5\u8be2", "\u8be6\u60c5"}, {"1", "2", "2", "2", "2", "2"}};
        try {
            boolean flag = true;
            for (int i = 0; i < res[0].length; ++i) {
                SysResourcesVo sysResourcesVo = this.sysResourcesMapper.getResourceInfoByUrl("/" + this.contextConfig.getBizEnName() + "/" + res[0][i]);
                if (!ToolUtil.isNotEmpty((Object)sysResourcesVo)) continue;
                flag = false;
            }
            if (flag && this.modulesAdd().booleanValue() && this.functionAdd().booleanValue()) {
                this.resourceAdd(res);
            }
        }
        catch (Exception e) {
            logger.error("\u6709\u8def\u5f84\u88ab\u591a\u6b21\u4f7f\u7528!");
        }
    }

    private Boolean modulesAdd() {
        String moduleCode = this.sysIdtableService.getCurrentCode("module_code", "sys_modules");
        this.sysModules.setModuleName(this.contextConfig.getBizChName());
        this.sysModules.setModuleCode(moduleCode);
        this.sysModules.setParentModuleId("1");
        this.sysModules.setIsLeaf("1");
        int moduleResult = this.sysResManageService.moduleSave(this.sysModules);
        if (moduleResult != 1) {
            return false;
        }
        SysModules getModule = this.sysModulesMapper.selectModuleByCode(moduleCode);
        this.sysModules.setModuleId(getModule.getModuleId());
        this.sysModules.setSeq(getModule.getSeq());
        this.sysModules.setCreator(getModule.getCreator());
        this.sysModules.setCreateTime(getModule.getCreateTime());
        this.modulesList.add(this.sysModules);
        logger.info("\u65b0\u589e\u6a21\u5757\u6210\u529f!");
        return true;
    }

    private Boolean functionAdd() {
        String functionCode = this.sysModules.getModuleCode() + this.sysIdtableService.getCurrentCode("function_code", "sys_functions");
        this.sysFunctions.setModuleId(this.sysModules.getModuleId());
        this.sysFunctions.setFunctionCode(functionCode);
        this.sysFunctions.setFunctionName(this.contextConfig.getBizChName());
        this.sysFunctions.setIsSys("1");
        int functionResult = this.sysResManageService.functionSave(this.sysFunctions);
        if (functionResult != 1) {
            return false;
        }
        SysFunctions getFunction = this.sysFunctionsMapper.selectFunctionByCode(functionCode);
        this.sysFunctions.setFunctionId(getFunction.getFunctionId());
        this.sysFunctions.setCreator(getFunction.getCreator());
        this.sysFunctions.setCreateTime(getFunction.getCreateTime());
        this.sysFunctions.setSeq(getFunction.getSeq());
        this.functionsList.add(this.sysFunctions);
        logger.info("\u65b0\u589e\u529f\u80fd\u6210\u529f!");
        return true;
    }

    private void resourceAdd(String[][] res) {
        for (int i = 0; i < res[0].length; ++i) {
            String currentCode = this.sysIdtableService.getCurrentCode("resource_code", "sys_resources");
            SysResources sysResources = new SysResources();
            sysResources.setResourceCode(this.sysFunctions.getFunctionCode() + currentCode);
            String prefix = "1".equals(res[2][i]) ? this.contextConfig.getBizChName() : "";
            sysResources.setResourceName(prefix + res[1][i]);
            sysResources.setResourceAlias(prefix + res[1][i]);
            sysResources.setUrlNames("/" + this.contextConfig.getBizEnName() + "/" + res[0][i]);
            sysResources.setPermissions(this.contextConfig.getBizEnName() + ":" + res[0][i]);
            sysResources.setIsDefault("0");
            sysResources.setIsAudit("0");
            sysResources.setFunctionId(this.sysFunctions.getFunctionId());
            sysResources.setResTypeId(res[2][i]);
            sysResources.setIsRepeatAuthenticate("0");
            String resourceResult = this.sysResManageService.resourceSave(sysResources);
            SysResources getResources = this.sysResourcesMapper.getResourceByCode(sysResources.getResourceCode());
            sysResources.setResourceId(getResources.getResourceId());
            sysResources.setCreator(getResources.getCreator());
            sysResources.setCreateTime(getResources.getCreateTime());
            sysResources.setSeq(getResources.getSeq());
            this.resourcesList.add(sysResources);
            boolean associationResult = this.associationRole(sysResources);
            if (ToolUtil.isNotEmpty((Object)resourceResult) && associationResult) {
                logger.info("\u65b0\u589e'" + res[0][i] + "'\u8d44\u6e90\u6210\u529f!");
            }
            if (i != 0) continue;
            this.menuAdd(sysResources);
        }
    }

    private Boolean associationRole(SysResources sysResources) {
        String[] roleName = new String[]{"\u8d85\u7ea7\u7ba1\u7406\u5458", "\u516c\u7528\u89d2\u8272"};
        String[] groupId = new String[]{"\u666e\u901a\u89d2\u8272"};
        List roleList = this.sysUserRoleMapper.getRoleIdByRoleName(roleName);
        List groupList = this.sysUserRoleMapper.getRoleIdByGroupId(groupId);
        for (String g : groupList) {
            boolean flag = false;
            for (String r : roleList) {
                if (!g.equals(r)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            roleList.add(g);
        }
        for (String roleId : roleList) {
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setRoleId(roleId);
            sysRoleResource.setResourceId(sysResources.getResourceId());
            sysRoleResource.setCreator(sysResources.getCreator());
            sysRoleResource.setCreateTime(sysResources.getCreateTime());
            sysRoleResource.setLastEditor(sysResources.getCreator());
            sysRoleResource.setLastTime(sysResources.getCreateTime());
            this.roleResourceList.add(sysRoleResource);
        }
        return this.sysRoleResourceService.saveBatch(this.roleResourceList, this.roleResourceList.size());
    }

    private void menuAdd(SysResources sysResources) {
        SysMenu menu = new SysMenu();
        menu.setText(this.contextConfig.getBizChName());
        menu.setMenuAlias(this.contextConfig.getBizChName());
        menu.setTitle(this.contextConfig.getBizChName());
        menu.setIcons("\ue001");
        menu.setIsLeaf("0");
        menu.setParentId("1");
        this.sysMenuManageService.menuInfoSave(menu);
        List list = this.sysMenuMapper.selectMenuByText(this.contextConfig.getBizChName());
        menu.setMenuId(((SysMenu)list.get(0)).getMenuId());
        menu.setSeq(((SysMenu)list.get(0)).getSeq());
        menu.setResourceId(((SysMenu)list.get(0)).getResourceId());
        this.menuList.add(menu);
        SysMenu menus = new SysMenu();
        menus.setText(this.contextConfig.getBizChName());
        menus.setMenuAlias(this.contextConfig.getBizChName());
        menus.setTitle(this.contextConfig.getBizChName());
        menus.setIcons(null);
        menus.setIsLeaf("1");
        menus.setParentId(((SysMenu)list.get(0)).getMenuId());
        menus.setResourceId(sysResources.getResourceId());
        menus.setOpenType(null);
        this.sysMenuManageService.menuInfoSave(menus);
        List sonList = this.sysMenuMapper.selectSonMenuById(menu.getMenuId());
        menus.setMenuId(((SysMenu)sonList.get(0)).getMenuId());
        menus.setSeq(((SysMenu)sonList.get(0)).getSeq());
        menus.setResourceId(((SysMenu)sonList.get(0)).getResourceId());
        this.menuList.add(menus);
        logger.info("\u65b0\u589e\u83dc\u5355\u6210\u529f!");
    }

    protected abstract void generatePageEditHtml();

    protected abstract void generatePageAddHtml();

    protected abstract void generatePageInfoJs();

    protected abstract void generatePageJs();

    protected abstract void generatePageHtml();

    protected abstract void generateController();

    protected abstract void generateSqls();

    protected abstract void generateResourceSqls(List<SysModules> var1, List<SysFunctions> var2, List<SysResources> var3, List<SysRoleResource> var4);

    protected abstract void generateMenuSqls(List<SysMenu> var1);
}

