/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.generator.engine.config;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.generator.action.model.HussarGeneratorProperties;
import com.jxdinfo.hussar.generator.engine.config.ContextConfig;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class ControllerConfig {
    private ContextConfig contextConfig;
    private String controllerPathTemplate;
    private String packageName;
    private List<String> imports;
    private HussarGeneratorProperties hussarProperties = (HussarGeneratorProperties)SpringContextHolder.getBean(HussarGeneratorProperties.class);

    public void init() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        imports.add("com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        imports.add(this.contextConfig.getCoreBasePackage() + ".base.controller.BaseController");
        imports.add("org.springframework.stereotype.Controller");
        imports.add("org.springframework.ui.Model");
        imports.add("org.springframework.web.bind.annotation.*");
        imports.add("org.springframework.beans.factory.annotation.Autowired");
        imports.add(this.contextConfig.getCoreBasePackage() + ".log.LogObjectHolder");
        imports.add("com.jxdinfo.hussar.common.annotion.BussinessLog");
        imports.add("org.apache.shiro.authz.annotation.RequiresPermissions");
        imports.add("com.jxdinfo.hussar.core.log.type.BussinessLogType");
        imports.add("com.jxdinfo.hussar.core.base.tips.Tip");
        imports.add("com.jxdinfo.hussar.core.base.tips.ErrorTip");
        imports.add("com.jxdinfo.hussar.core.base.tips.SuccessTip");
        imports.add("com.jxdinfo.hussar.core.constant.HttpCode");
        imports.add("com.jxdinfo.hussar.core.util.ToolUtil");
        imports.add("com.alibaba.druid.util.StringUtils");
        imports.add(this.contextConfig.getModelPackageName() + "." + this.contextConfig.getEntityName());
        imports.add(this.contextConfig.getProPackage() + "." + this.contextConfig.getModuleName() + ".service.I" + this.contextConfig.getEntityName() + "Service");
        imports.add("java.util.HashMap");
        imports.add("java.util.List");
        imports.add("java.util.Map");
        imports.add("java.util.Arrays");
        this.imports = imports;
        String environment = this.hussarProperties.getEnvironment();
        String packLocal = "";
        packLocal = "dyna".equals(environment) ? "\\src\\" : "\\src\\main\\java\\";
        this.packageName = this.contextConfig.getProPackage() + "." + this.contextConfig.getModuleName() + ".controller";
        this.controllerPathTemplate = packLocal + this.contextConfig.getProPackage().replaceAll("\\.", "\\\\") + "\\" + this.contextConfig.getModuleName() + "\\controller\\{}Controller.java";
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public String getControllerPathTemplate() {
        return this.controllerPathTemplate;
    }

    public void setControllerPathTemplate(String controllerPathTemplate) {
        this.controllerPathTemplate = controllerPathTemplate;
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public void setContextConfig(ContextConfig contextConfig) {
        this.contextConfig = contextConfig;
    }
}

