/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.generator.action.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.generator.action.config.AbstractGeneratorConfig;
import com.jxdinfo.hussar.generator.action.model.GenQo;
import com.jxdinfo.hussar.generator.action.model.HussarGeneratorProperties;
import java.io.File;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@DependsOn(value={"springContextHolder"})
public class WebGeneratorConfig
extends AbstractGeneratorConfig {
    public static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    public static final String ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    public static final String DM_DRIVER = "dm.jdbc.driver.DmDriver";
    public static final String OSCAR_DRIVER = "com.oscar.Driver";
    public static final String KINGBASE_DRIVER = "com.kingbase.Driver";
    public static final String POSTGRESQL_DRIVER = "org.postgresql.Driver";
    private GenQo genQo;
    private Environment env = (Environment)SpringContextHolder.getBean(Environment.class);
    private HussarGeneratorProperties hussarProperties = (HussarGeneratorProperties)SpringContextHolder.getBean(HussarGeneratorProperties.class);

    public WebGeneratorConfig(GenQo genQo) {
        this.genQo = genQo;
    }

    @Override
    protected void config() {
        String dbDriver = this.env.getProperty("spring.datasource.driverClassName");
        this.dataSourceConfig.setDbType(DbType.MYSQL);
        if (POSTGRESQL_DRIVER.equals(dbDriver)) {
            String schemaName = this.env.getProperty("spring.datasource.db-name");
            this.dataSourceConfig.setSchemaName(schemaName);
        }
        this.dataSourceConfig.setDriverName(dbDriver);
        this.dataSourceConfig.setUsername(this.genQo.getUserName());
        this.dataSourceConfig.setPassword(this.genQo.getPassword());
        this.dataSourceConfig.setUrl(this.genQo.getUrl());
        String environment = this.hussarProperties.getEnvironment();
        String pageLocal = "";
        pageLocal = "dyna".equals(environment) ? this.genQo.getProjectPath() + File.separator + "src" : this.genQo.getProjectPath() + File.separator + "src" + File.separator + "main" + File.separator + "java";
        this.globalConfig.setOutputDir(pageLocal);
        this.globalConfig.setFileOverride(true);
        this.globalConfig.setEnableCache(false);
        this.globalConfig.setBaseResultMap(true);
        this.globalConfig.setBaseColumnList(true);
        this.globalConfig.setOpen(false);
        this.globalConfig.setAuthor(this.genQo.getAuthor());
        this.contextConfig.setProPackage(this.genQo.getProjectPackage());
        this.contextConfig.setCoreBasePackage(this.genQo.getCorePackage());
        this.contextConfig.setModuleName(this.genQo.getModuleName());
        if (this.genQo.getIgnoreTabelPrefix() != null) {
            this.strategyConfig.setTablePrefix(new String[]{this.genQo.getIgnoreTabelPrefix()});
        }
        this.strategyConfig.setInclude(new String[]{this.genQo.getTableName()});
        this.strategyConfig.setNaming(NamingStrategy.underline_to_camel);
        this.strategyConfig.setEntityTableFieldAnnotationEnable(true);
        this.packageConfig.setParent(null);
        this.packageConfig.setEntity(this.genQo.getProjectPackage() + "." + this.contextConfig.getModuleName() + ".model");
        this.packageConfig.setMapper(this.genQo.getProjectPackage() + "." + this.contextConfig.getModuleName() + ".dao");
        this.packageConfig.setXml(this.genQo.getProjectPackage() + "." + this.contextConfig.getModuleName() + ".dao.mapping");
        this.contextConfig.setBizChName(this.genQo.getBizName());
        this.contextConfig.setModuleName(this.genQo.getModuleName());
        this.contextConfig.setProjectPath(this.genQo.getProjectPath());
        this.contextConfig.setAuthor(this.genQo.getAuthor());
        this.sqlConfig.setParentMenuName(this.genQo.getParentMenuName());
        this.contextConfig.setEntitySwitch(this.genQo.getEntitySwitch());
        this.contextConfig.setDaoSwitch(this.genQo.getDaoSwitch());
        this.contextConfig.setServiceSwitch(this.genQo.getServiceSwitch());
        this.contextConfig.setControllerSwitch(this.genQo.getControllerSwitch());
        this.contextConfig.setIndexPageSwitch(this.genQo.getIndexPageSwitch());
        this.contextConfig.setAddPageSwitch(this.genQo.getAddPageSwitch());
        this.contextConfig.setEditPageSwitch(this.genQo.getEditPageSwitch());
        this.contextConfig.setJsSwitch(this.genQo.getJsSwitch());
        this.contextConfig.setInfoJsSwitch(this.genQo.getInfoJsSwitch());
        this.contextConfig.setSqlSwitch(this.genQo.getSqlSwitch());
        this.contextConfig.setResourceSqlSwitch(this.genQo.getResourceSqlSwitch());
        this.contextConfig.setMenuSqlSwitch(this.genQo.getMenuSqlSwitch());
        if (ORACLE_DRIVER.equals(dbDriver)) {
            this.dataSourceConfig.setDbType(DbType.ORACLE);
            this.strategyConfig.setCapitalMode(true);
            this.strategyConfig.setEntityTableFieldAnnotationEnable(true);
        }
        if (DM_DRIVER.equals(dbDriver)) {
            this.dataSourceConfig.setDbType(DbType.DM);
            this.strategyConfig.setCapitalMode(true);
            this.strategyConfig.setEntityTableFieldAnnotationEnable(true);
        }
        if (KINGBASE_DRIVER.equals(dbDriver)) {
            this.dataSourceConfig.setDbType(DbType.KINGBASE_ES);
            this.strategyConfig.setCapitalMode(true);
            this.strategyConfig.setEntityTableFieldAnnotationEnable(true);
        }
        if (POSTGRESQL_DRIVER.equals(dbDriver)) {
            this.dataSourceConfig.setDbType(DbType.POSTGRE_SQL);
            this.strategyConfig.setCapitalMode(true);
            this.strategyConfig.setEntityTableFieldAnnotationEnable(true);
        }
    }
}

