/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.generator.action.config;

import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.jxdinfo.hussar.core.support.StrKit;
import com.jxdinfo.hussar.core.util.FileUtil;
import com.jxdinfo.hussar.generator.engine.SimpleTemplateEngine;
import com.jxdinfo.hussar.generator.engine.config.ContextConfig;
import com.jxdinfo.hussar.generator.engine.config.MenuSqlConfig;
import com.jxdinfo.hussar.generator.engine.config.ResourceSqlConfig;
import com.jxdinfo.hussar.generator.engine.config.SqlConfig;
import java.io.File;
import java.util.List;

public abstract class AbstractGeneratorConfig {
    GlobalConfig globalConfig = new GlobalConfig();
    DataSourceConfig dataSourceConfig = new DataSourceConfig();
    StrategyConfig strategyConfig = new StrategyConfig();
    PackageConfig packageConfig = new PackageConfig();
    TableInfo tableInfo = null;
    ContextConfig contextConfig = new ContextConfig();
    SqlConfig sqlConfig = new SqlConfig();
    ResourceSqlConfig resourceSqlConfig = new ResourceSqlConfig();
    MenuSqlConfig menuSqlConfig = new MenuSqlConfig();

    protected abstract void config();

    public void init() {
        this.config();
        this.packageConfig.setService(this.contextConfig.getProPackage() + "." + this.contextConfig.getModuleName() + ".service");
        this.packageConfig.setServiceImpl(this.contextConfig.getProPackage() + "." + this.contextConfig.getModuleName() + ".service.impl");
        this.packageConfig.setController("TTT");
        if (!this.contextConfig.getEntitySwitch().booleanValue()) {
            this.packageConfig.setEntity("TTT");
        }
        if (!this.contextConfig.getDaoSwitch().booleanValue()) {
            this.packageConfig.setMapper("TTT");
            this.packageConfig.setXml("TTT");
        }
        if (!this.contextConfig.getServiceSwitch().booleanValue()) {
            this.packageConfig.setService("TTT");
            this.packageConfig.setServiceImpl("TTT");
        }
    }

    public void destory() {
        String outputDir = this.globalConfig.getOutputDir() + "/TTT";
        FileUtil.deleteDir((File)new File(outputDir));
    }

    public void doMpGeneration() {
        this.init();
        AutoGenerator autoGenerator = new AutoGenerator();
        this.globalConfig.setDateType(DateType.SQL_PACK);
        autoGenerator.setGlobalConfig(this.globalConfig);
        autoGenerator.setDataSource(this.dataSourceConfig);
        autoGenerator.setStrategy(this.strategyConfig);
        autoGenerator.setPackageInfo(this.packageConfig);
        autoGenerator.execute();
        this.destory();
        List tableInfoList = autoGenerator.getConfig().getTableInfoList();
        if (tableInfoList != null && tableInfoList.size() > 0) {
            this.tableInfo = (TableInfo)tableInfoList.get(0);
        }
    }

    public void doHussarGeneration() {
        SimpleTemplateEngine hussarTemplateEngine = new SimpleTemplateEngine();
        this.contextConfig.setEntityName(this.tableInfo.getEntityName());
        this.contextConfig.setBizEnName(StrKit.firstCharToLowerCase((String)this.tableInfo.getEntityName()));
        hussarTemplateEngine.setContextConfig(this.contextConfig);
        this.sqlConfig.setConnection(this.dataSourceConfig.getConn());
        hussarTemplateEngine.setSqlConfig(this.sqlConfig);
        this.resourceSqlConfig.setConnection(this.dataSourceConfig.getConn());
        hussarTemplateEngine.setResourceSqlConfig(this.resourceSqlConfig);
        this.menuSqlConfig.setConnection(this.dataSourceConfig.getConn());
        hussarTemplateEngine.setMenuSqlConfig(this.menuSqlConfig);
        hussarTemplateEngine.setTableInfo(this.tableInfo);
        hussarTemplateEngine.start();
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }
}

