/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.generator.engine.config;

import com.jxdinfo.hussar.bsp.permit.model.SysFunctions;
import com.jxdinfo.hussar.bsp.permit.model.SysModules;
import com.jxdinfo.hussar.bsp.permit.model.SysResources;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleResource;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.generator.action.model.HussarGeneratorProperties;
import com.jxdinfo.hussar.generator.engine.config.ContextConfig;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class ResourceSqlConfig {
    private String sqlPathTemplate;
    private ContextConfig contextConfig;
    private Connection connection;
    private List<SysModules> moduleList = new ArrayList<SysModules>(1);
    private List<SysFunctions> functionsList = new ArrayList<SysFunctions>(1);
    private List<SysResources> resourceList = new ArrayList<SysResources>(6);
    private List<SysRoleResource> roleResourcesList = new ArrayList<SysRoleResource>(6);
    private HussarGeneratorProperties hussarProperties = (HussarGeneratorProperties)SpringContextHolder.getBean(HussarGeneratorProperties.class);

    public void init() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(new Date());
        String userId = ShiroKit.getUser().getId();
        String environment = this.hussarProperties.getEnvironment();
        String pageLocal = "";
        pageLocal = "dyna".equals(environment) ? "\\src\\" : "\\src\\main\\resources\\sql\\";
        this.sqlPathTemplate = pageLocal + "{}\\{}Resource.sql";
    }

    public String getSqlPathTemplate() {
        return this.sqlPathTemplate;
    }

    public void setSqlPathTemplate(String sqlPathTemplate) {
        this.sqlPathTemplate = sqlPathTemplate;
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public void setContextConfig(ContextConfig contextConfig) {
        this.contextConfig = contextConfig;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public List<SysModules> getModuleList() {
        return this.moduleList;
    }

    public void setModuleList(List<SysModules> moduleList) {
        this.moduleList = moduleList;
    }

    public List<SysFunctions> getFunctionsList() {
        return this.functionsList;
    }

    public void setFunctionsList(List<SysFunctions> functionsList) {
        this.functionsList = functionsList;
    }

    public List<SysResources> getResourceList() {
        return this.resourceList;
    }

    public void setResourceList(List<SysResources> resourceList) {
        this.resourceList = resourceList;
    }

    public List<SysRoleResource> getRoleResourcesList() {
        return this.roleResourcesList;
    }

    public void setRoleResourcesList(List<SysRoleResource> roleResourcesList) {
        this.roleResourcesList = roleResourcesList;
    }
}

