/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.generator.action.model;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar")
public class HussarGeneratorProperties {
    public static final String PREFIX = "hussar";
    private String staticVersion = "1111";
    private Boolean mutiDatasourceOpen = false;
    private Boolean swaggerOpen = false;
    private Boolean kaptchaOpen = false;
    private String fileUploadPathWindows = "e:/hussar";
    private String environment = "maven";
    private String fileUploadPathLinux = "/usr/local/hussar";
    private String fileUploadPathMac = "/tmp/hussar";
    private Boolean fileDateSplit = true;
    private Boolean springSessionOpen = false;
    private Integer sessionInvalidateTime = 1800;
    private Integer sessionValidationInterval = 300;
    private String firewallXssLevel = "B";
    private List<String> xssWhitelist = new ArrayList<String>();
    private boolean standAlone = true;
    private String welcomePage = "/";
    private String loginHtml = "/login.html";
    private boolean indexConfig = false;
    private String defaultIndex = "/default/index";
    private int downloadLogLimit = 100;
    private Boolean haveCreatePath = false;
    private Boolean loginUpperOpen = false;
    private Boolean useJNDI = false;
    private Boolean openOrgservice = false;

    public String getFileUploadPath() {
        File file;
        String fileUploadPath = "";
        boolean fileDateSplit = this.getFileDateSplit();
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        if (os != null && os.toLowerCase().indexOf("linux") > -1) {
            fileUploadPath = this.fileUploadPathLinux;
        } else if (os != null && os.toLowerCase().indexOf("windows") > -1) {
            fileUploadPath = this.fileUploadPathWindows;
        } else if (os != null && os.toLowerCase().indexOf("mac") > -1) {
            fileUploadPath = this.fileUploadPathMac;
        }
        if (fileDateSplit) {
            fileUploadPath = fileUploadPath + "/" + new SimpleDateFormat("yyyy/MM/dd").format(new Date());
        }
        if (ToolUtil.isEmpty((Object)fileUploadPath)) {
            return ToolUtil.getTempPath();
        }
        if (!fileUploadPath.endsWith(File.separator)) {
            fileUploadPath = fileUploadPath + File.separator;
        }
        if (!(file = new File(fileUploadPath)).exists()) {
            file.mkdirs();
        }
        return fileUploadPath;
    }

    public String getFirewallXssLevel() {
        return this.firewallXssLevel;
    }

    public void setFirewallXssLevel(String firewallXssLevel) {
        this.firewallXssLevel = firewallXssLevel;
    }

    public List<String> getXssWhitelist() {
        return this.xssWhitelist;
    }

    public void setXssWhitelist(List<String> xssWhitelist) {
        this.xssWhitelist = xssWhitelist;
    }

    public void setFileUploadPathWindows(String fileUploadPathWindows) {
        this.fileUploadPathWindows = fileUploadPathWindows;
    }

    public void setFileUploadPathLinux(String fileUploadPathLinux) {
        this.fileUploadPathLinux = fileUploadPathLinux;
    }

    public String getFileUploadPathMac() {
        return this.fileUploadPathMac;
    }

    public void setFileUploadPathMac(String fileUploadPathMac) {
        this.fileUploadPathMac = fileUploadPathMac;
    }

    public Boolean getKaptchaOpen() {
        return this.kaptchaOpen;
    }

    public void setKaptchaOpen(Boolean kaptchaOpen) {
        this.kaptchaOpen = kaptchaOpen;
    }

    public Boolean getFileDateSplit() {
        return this.fileDateSplit;
    }

    public void setFileDateSplit(Boolean fileDateSplit) {
        this.fileDateSplit = fileDateSplit;
    }

    public Boolean getSwaggerOpen() {
        return this.swaggerOpen;
    }

    public void setSwaggerOpen(Boolean swaggerOpen) {
        this.swaggerOpen = swaggerOpen;
    }

    public Boolean getSpringSessionOpen() {
        return this.springSessionOpen;
    }

    public void setSpringSessionOpen(Boolean springSessionOpen) {
        this.springSessionOpen = springSessionOpen;
    }

    public Integer getSessionInvalidateTime() {
        return this.sessionInvalidateTime;
    }

    public void setSessionInvalidateTime(Integer sessionInvalidateTime) {
        this.sessionInvalidateTime = sessionInvalidateTime;
    }

    public Integer getSessionValidationInterval() {
        return this.sessionValidationInterval;
    }

    public void setSessionValidationInterval(Integer sessionValidationInterval) {
        this.sessionValidationInterval = sessionValidationInterval;
    }

    public int getDownloadLogLimit() {
        return this.downloadLogLimit;
    }

    public void setDownloadLogLimit(int downloadLogLimit) {
        this.downloadLogLimit = downloadLogLimit;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public void setStandAlone(boolean standAlone) {
        this.standAlone = standAlone;
    }

    public String getWelcomePage() {
        return this.welcomePage;
    }

    public void setWelcomePage(String welcomePage) {
        this.welcomePage = welcomePage;
    }

    public String getLoginHtml() {
        return this.loginHtml;
    }

    public void setLoginHtml(String loginHtml) {
        this.loginHtml = loginHtml;
    }

    public boolean isIndexConfig() {
        return this.indexConfig;
    }

    public void setIndexConfig(boolean indexConfig) {
        this.indexConfig = indexConfig;
    }

    public String getDefaultIndex() {
        return this.defaultIndex;
    }

    public void setDefaultIndex(String defaultIndex) {
        this.defaultIndex = defaultIndex;
    }

    public String getStaticVersion() {
        return this.staticVersion;
    }

    public void setStaticVersion(String staticVersion) {
        this.staticVersion = staticVersion;
    }

    public Boolean getMutiDatasourceOpen() {
        return this.mutiDatasourceOpen;
    }

    public void setMutiDatasourceOpen(Boolean mutiDatasourceOpen) {
        this.mutiDatasourceOpen = mutiDatasourceOpen;
    }

    public String getFileUploadPathWindows() {
        return this.fileUploadPathWindows;
    }

    public String getFileUploadPathLinux() {
        return this.fileUploadPathLinux;
    }

    public Boolean getHaveCreatePath() {
        return this.haveCreatePath;
    }

    public void setHaveCreatePath(Boolean haveCreatePath) {
        this.haveCreatePath = haveCreatePath;
    }

    public Boolean getLoginUpperOpen() {
        return this.loginUpperOpen;
    }

    public void setLoginUpperOpen(Boolean loginUpperOpen) {
        this.loginUpperOpen = loginUpperOpen;
    }

    public Boolean getUseJNDI() {
        return this.useJNDI;
    }

    public void setUseJNDI(Boolean useJNDI) {
        this.useJNDI = useJNDI;
    }

    public Boolean getOpenOrgservice() {
        return this.openOrgservice;
    }

    public void setOpenOrgservice(Boolean openOrgservice) {
        this.openOrgservice = openOrgservice;
    }

    public String getEnvironment() {
        Properties prop = System.getProperties();
        String environment = prop.getProperty("hussar.environment");
        if (environment == null || "".equals(environment)) {
            return this.environment;
        }
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }
}

