/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.modeling.controller;

import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.dataSource.DataSourceProperties;
import com.jxdinfo.hussar.generator.action.config.WebGeneratorConfig;
import com.jxdinfo.hussar.generator.action.model.GenQo;
import com.jxdinfo.hussar.generator.action.model.HussarGeneratorProperties;
import com.jxdinfo.hussar.modeling.factory.DefaultTemplateFactory;
import com.jxdinfo.hussar.modeling.service.FileCheckService;
import com.jxdinfo.hussar.modeling.service.ITableService;
import io.swagger.annotations.ApiOperation;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/code"})
@DependsOn(value={"springContextHolder"})
public class CodeController
extends BaseController {
    private static String PREFIX = "/core/modeling";
    @Autowired
    private ITableService ITableService;
    @Autowired
    private FileCheckService fileCheckService;
    @Autowired
    private DataSourceProperties druidProperties;
    @Resource
    private HussarGeneratorProperties hussarGeneratorProperties;

    @RequestMapping(value={""})
    public String blackboard(Model model) throws SQLException {
        String envDev = "dev";
        String envPropPath = "spring.profiles.active";
        Environment env = (Environment)SpringContextHolder.getBean(Environment.class);
        GenQo genQo = new GenQo();
        genQo = DefaultTemplateFactory.getDefaultParams();
        String projectPath = DefaultTemplateFactory.getDefaultParams().getProjectPath();
        if (!envDev.equals(env.getProperty(envPropPath))) {
            return PREFIX + "/codeUnable.html";
        }
        String packageLocal = "";
        String pageLocal = "";
        String staticLocal = "";
        String environment = this.hussarGeneratorProperties.getEnvironment();
        if ("dyna".equals(environment)) {
            packageLocal = "/src/";
            pageLocal = "/resources/WEB-INF/view/";
            staticLocal = "/resources/static/";
            projectPath = projectPath.substring(0, projectPath.lastIndexOf("/"));
            genQo.setProjectPath(projectPath);
        } else {
            packageLocal = "/src/main/java/";
            pageLocal = "/src/main/webapp/WEB-INF/view/";
            staticLocal = "/src/main/webapp/static/";
        }
        List<Map<String, Object>> bizTps = DefaultTemplateFactory.getBizTemplates();
        List<Map<String, Object>> frontTps = DefaultTemplateFactory.getFrontTemplates();
        model.addAttribute("packageLocal", (Object)packageLocal);
        model.addAttribute("pageLocal", (Object)pageLocal);
        model.addAttribute("staticLocal", (Object)staticLocal);
        model.addAttribute("tables", this.ITableService.getAllTables());
        model.addAttribute("params", (Object)genQo);
        model.addAttribute("bizTemplates", bizTps);
        model.addAttribute("frontTemplates", frontTps);
        return PREFIX + "/code.html";
    }

    @ApiOperation(value="\u751f\u6210\u4ee3\u7801")
    @RequestMapping(value={"/generate"}, method={RequestMethod.POST})
    @ResponseBody
    public Object generate(GenQo genQo) {
        this.setDBConnInfo(genQo);
        WebGeneratorConfig webGeneratorConfig = new WebGeneratorConfig(genQo);
        webGeneratorConfig.doMpGeneration();
        webGeneratorConfig.doHussarGeneration();
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/fileCheck"}, method={RequestMethod.POST})
    @ResponseBody
    public List<String> fileCheck(GenQo genQo) {
        boolean[] temp = new boolean[]{genQo.getDaoSwitch(), genQo.getServiceSwitch(), genQo.getEntitySwitch()};
        this.setDBConnInfo(genQo);
        genQo.setDaoSwitch(false);
        genQo.setServiceSwitch(false);
        genQo.setEntitySwitch(false);
        WebGeneratorConfig webGeneratorConfig = new WebGeneratorConfig(genQo);
        webGeneratorConfig.doMpGeneration();
        genQo.setDaoSwitch(temp[0]);
        genQo.setServiceSwitch(temp[1]);
        genQo.setEntitySwitch(temp[2]);
        return this.fileCheckService.fileCheck(genQo, webGeneratorConfig);
    }

    private void setDBConnInfo(GenQo o) {
        o.setUrl(this.druidProperties.getUrl());
        o.setUserName(this.druidProperties.getUsername());
        o.setPassword(this.druidProperties.getPassword());
    }
}

