/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.modeling.service;

import com.jxdinfo.hussar.core.support.StrKit;
import com.jxdinfo.hussar.generator.action.config.AbstractGeneratorConfig;
import com.jxdinfo.hussar.generator.action.model.GenQo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class FileCheckService {
    public List<String> fileCheck(GenQo genQo, AbstractGeneratorConfig config) {
        String path;
        String packageStr = genQo.getProjectPackage().replace(".", File.separator);
        String moduleStr = genQo.getModuleName();
        ArrayList<String> result = new ArrayList<String>();
        String entityName = config.getTableInfo().getEntityName();
        String clazzName = StrKit.firstCharToUpperCase((String)entityName);
        String frontName = StrKit.firstCharToLowerCase((String)entityName);
        String mainPath = genQo.getProjectPath().replace("/", File.separator) + File.separator + "src" + File.separator + "main" + File.separator;
        String packagePath = mainPath + "java" + File.separator + packageStr + File.separator + moduleStr + File.separator;
        String frontPathSuffix = File.separator + moduleStr + File.separator + frontName + File.separator;
        String htmlPath = mainPath + "webapp" + File.separator + "WEB-INF" + File.separator + "view" + frontPathSuffix;
        String jsPath = mainPath + "webapp" + File.separator + "static" + File.separator + frontPathSuffix;
        if (genQo.getControllerSwitch().booleanValue()) {
            path = packagePath + "controller" + File.separator + clazzName + "Controller.java";
            this.checkExist(result, path);
        }
        if (genQo.getDaoSwitch().booleanValue()) {
            String daoPath = packagePath + "dao" + File.separator + clazzName + "Mapper.java";
            String xmlPath = packagePath + "dao" + File.separator + "mapping" + File.separator + clazzName + "Mapper.xml";
            this.checkExist(result, daoPath);
            this.checkExist(result, xmlPath);
        }
        if (genQo.getServiceSwitch().booleanValue()) {
            String servicePath = packagePath + "service" + File.separator + "I" + clazzName + "Service.java";
            String impPath = packagePath + "service" + File.separator + "impl" + File.separator + clazzName + "ServiceImpl.java";
            this.checkExist(result, servicePath);
            this.checkExist(result, impPath);
        }
        if (genQo.getEntitySwitch().booleanValue()) {
            path = packagePath + "model" + File.separator + clazzName + ".java";
            this.checkExist(result, path);
        }
        if (genQo.getIndexPageSwitch().booleanValue()) {
            path = htmlPath + frontName + ".html";
            this.checkExist(result, path);
        }
        if (genQo.getAddPageSwitch().booleanValue()) {
            path = htmlPath + frontName + "_add.html";
            this.checkExist(result, path);
        }
        if (genQo.getEditPageSwitch().booleanValue()) {
            path = htmlPath + frontName + "_edit.html";
            this.checkExist(result, path);
        }
        if (genQo.getJsSwitch().booleanValue()) {
            path = jsPath + frontName + ".js";
            this.checkExist(result, path);
        }
        if (genQo.getInfoJsSwitch().booleanValue()) {
            path = jsPath + frontName + "_info.js";
            this.checkExist(result, path);
        }
        return result;
    }

    private void checkExist(List<String> result, String path) {
        if (new File(path).exists()) {
            result.add(path);
        }
    }
}

