/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.generator.engine.config;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.generator.action.model.HussarGeneratorProperties;
import com.jxdinfo.hussar.generator.engine.config.ContextConfig;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class ServiceConfig {
    private ContextConfig contextConfig;
    private String servicePathTemplate;
    private String serviceImplPathTemplate;
    private String packageName;
    private List<String> serviceInterfaceImports;
    private List<String> serviceImplImports;
    private HussarGeneratorProperties hussarProperties = (HussarGeneratorProperties)SpringContextHolder.getBean(HussarGeneratorProperties.class);

    public void init() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("org.springframework.stereotype.Service");
        imports.add("com.baomidou.mybatisplus.service.impl.ServiceImpl");
        imports.add(this.contextConfig.getModelPackageName() + "." + this.contextConfig.getEntityName());
        imports.add(this.contextConfig.getModelMapperPackageName() + "." + this.contextConfig.getEntityName() + "Mapper");
        imports.add(this.contextConfig.getProPackage() + "." + this.contextConfig.getModuleName() + ".service.I" + this.contextConfig.getBizEnBigName() + "Service");
        this.serviceImplImports = imports;
        ArrayList<String> interfaceImports = new ArrayList<String>();
        interfaceImports.add("com.baomidou.mybatisplus.service.IService");
        interfaceImports.add(this.contextConfig.getModelPackageName() + "." + this.contextConfig.getEntityName());
        this.serviceInterfaceImports = interfaceImports;
        String environment = this.hussarProperties.getEnvironment();
        String pageLocal = "";
        pageLocal = "dyna".equals(environment) ? "\\src\\" : "\\src\\main\\java\\";
        this.servicePathTemplate = pageLocal + this.contextConfig.getProPackage().replaceAll("\\.", "\\\\") + "\\" + this.contextConfig.getModuleName() + "\\service\\I{}Service.java";
        this.serviceImplPathTemplate = pageLocal + this.contextConfig.getProPackage().replaceAll("\\.", "\\\\") + "\\" + this.contextConfig.getModuleName() + "\\service\\impl\\{}ServiceImpl.java";
        this.packageName = this.contextConfig.getProPackage() + "." + this.contextConfig.getModuleName() + ".service";
    }

    public String getServicePathTemplate() {
        return this.servicePathTemplate;
    }

    public void setServicePathTemplate(String servicePathTemplate) {
        this.servicePathTemplate = servicePathTemplate;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getServiceImplPathTemplate() {
        return this.serviceImplPathTemplate;
    }

    public void setServiceImplPathTemplate(String serviceImplPathTemplate) {
        this.serviceImplPathTemplate = serviceImplPathTemplate;
    }

    public List<String> getServiceImplImports() {
        return this.serviceImplImports;
    }

    public void setServiceImplImports(List<String> serviceImplImports) {
        this.serviceImplImports = serviceImplImports;
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public void setContextConfig(ContextConfig contextConfig) {
        this.contextConfig = contextConfig;
    }

    public List<String> getServiceInterfaceImports() {
        return this.serviceInterfaceImports;
    }

    public void setServiceInterfaceImports(List<String> serviceInterfaceImports) {
        this.serviceInterfaceImports = serviceInterfaceImports;
    }
}

