/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.idtable.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.toolkit.SqlRunner;
import com.jxdinfo.hussar.common.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.general.idtable.dao.SysTableMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class TableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableService.class);
    private static String dbName;
    private static String dbUrl;
    private static final String GET_ALL_TABLES_SQL = "select t.TABLE_NAME as TABLENAME,f.COMMENTS as TABLECOMMENT from all_tables t inner join user_tab_comments f on t.table_name = f.table_name WHERE t.owner='";
    public static final String CAST_OBJ_AS_VARCHAR_SQL = ",cast(obj_description(relfilenode,'pg_class') as varchar) as ";
    private static final String FILTER_REAL_NAME_SQL = " from pg_class where relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname";
    private static final String TABLE_NAME_FIELD = "\"TABLENAME\"";
    private static final String TABLE_COMMENT_FIELD = "\"TABLECOMMENT\"";
    @Resource
    private SysTableMapper tableMapper;
    @Autowired
    private SysDataSourceService dataSourceService;
    @Autowired
    private DruidProperties druidProperties;

    private void getString() throws SQLException {
        HussarTenantDefinition hussarTenantDefinition;
        dbName = this.druidProperties.getDbName();
        dbUrl = this.druidProperties.getUrl();
        HussarTenantDefinition hussarTenant = HussarContextHolder.getHussarTenant();
        if (HussarUtils.isNotEmpty((Object)hussarTenant) && StringUtils.isNotBlank((CharSequence)hussarTenant.getTenantCode()) && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)hussarTenant.getTenantCode())))) {
            SysDataSource one = (SysDataSource)this.dataSourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataSource::getConnName, (Object)hussarTenantDefinition.getConnName())).eq(SysDataSource::getDatasourceType, (Object)"1"));
            dbName = one.getDbName();
            dbUrl = one.getJdbcUrl();
        }
    }

    public List<Map<String, Object>> getAllTables() throws SQLException {
        String filterSysTableNameSQL = "' and t.TABLE_NAME not like 'SYS/_%' escape '/' and t.TABLE_NAME not like 'ACT/_%' escape '/' ";
        this.getString();
        String sql = dbUrl.startsWith("jdbc:mysql") ? "select TABLE_NAME as TABLENAME,TABLE_COMMENT as TABLECOMMENT from information_schema.`TABLES` where TABLE_SCHEMA = '" + dbName + "' and TABLE_NAME not like 'sys/_%' escape '/' and TABLE_NAME not like 'act/_%' escape '/'" : (dbUrl.startsWith("jdbc:oracle") ? GET_ALL_TABLES_SQL + dbName.toUpperCase() + filterSysTableNameSQL : (dbUrl.startsWith("jdbc:dm") ? GET_ALL_TABLES_SQL + dbName.toUpperCase() + filterSysTableNameSQL : (dbUrl.startsWith("jdbc:oscar") ? GET_ALL_TABLES_SQL + dbName.toUpperCase() + filterSysTableNameSQL : (dbUrl.startsWith("jdbc:kingbase") ? "select t.tablename as TABLENAME,f.COMMENTS as TABLECOMMENT from sys_tables t LEFT join user_tab_comments f on t.tablename = f.table_name AND f.table_type = 'TABLE' WHERE T .schemaname = 'public' and t.tablename not like 'SYS/_%' escape '/' and t.tablename not like 'ACT/_%' escape '/' and t.tablename not like 'SREF_CON_TAB%' escape '/'" : (dbUrl.startsWith("jdbc:postgresql") ? "select distinct relname as  \"TABLENAME\",cast(obj_description(relfilenode,'pg_class') as varchar) as \"TABLECOMMENT\" from pg_class where relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname" : (dbUrl.startsWith("jdbc:highgo") ? "select distinct relname as \"TABLENAME\",cast(obj_description(relfilenode,'pg_class') as varchar) as \"TABLECOMMENT\" from pg_class where relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname" : (dbUrl.startsWith("jdbc:sqlserver") ? "select TABLENAME,TABLECOMMENT from (select a.name AS TABLENAME,CONVERT(NVARCHAR(100),isnull(g.[value],'-')) AS TABLECOMMENT from sys.tables a left join sys.extended_properties g on (a.object_id = g.major_id AND g.minor_id = 0)) t where t.TABLENAME not like 'sys/_%' escape '/' and t.TABLENAME not like 'act/_%' escape '/'" : "")))))));
        LOGGER.info("sql:{}", (Object)sql);
        return SqlRunner.db().selectList(sql, new Object[0]);
    }

    public List<Map<String, Object>> getTables() throws SQLException {
        String sql;
        String selectDistinctRelNameSql = "select distinct relname as  ";
        this.getString();
        if (dbUrl.startsWith("jdbc:mysql")) {
            sql = "select TABLE_NAME as TABLENAME,TABLE_COMMENT as TABLECOMMENT from information_schema.`TABLES` where TABLE_SCHEMA = '" + dbName + "'";
        } else if (dbUrl.startsWith("jdbc:oracle")) {
            sql = GET_ALL_TABLES_SQL + dbName.toUpperCase() + "' ";
        } else if (dbUrl.startsWith("jdbc:dm")) {
            sql = GET_ALL_TABLES_SQL + dbName.toUpperCase() + "' ";
        } else if (dbUrl.startsWith("jdbc:oscar")) {
            sql = GET_ALL_TABLES_SQL + dbName.toUpperCase() + "' ";
        } else if (dbUrl.startsWith("jdbc:kingbase")) {
            sql = selectDistinctRelNameSql + TABLE_NAME_FIELD + CAST_OBJ_AS_VARCHAR_SQL + TABLE_COMMENT_FIELD + FILTER_REAL_NAME_SQL;
        } else if (dbUrl.startsWith("jdbc:postgresql")) {
            sql = selectDistinctRelNameSql + TABLE_NAME_FIELD + CAST_OBJ_AS_VARCHAR_SQL + TABLE_COMMENT_FIELD + FILTER_REAL_NAME_SQL;
        } else if (dbUrl.startsWith("jdbc:highgo")) {
            sql = "select distinct relname as \"TABLENAME\",cast(obj_description(relfilenode,'pg_class') as varchar) as \"TABLECOMMENT\" from pg_class where relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname";
        } else if (dbUrl.startsWith("jdbc:sqlserver")) {
            sql = "select a.name AS TABLENAME,CONVERT(NVARCHAR(100),isnull(g.[value],'-')) AS TABLECOMMENT from sys.tables a left join sys.extended_properties g on (a.object_id = g.major_id AND g.minor_id = 0)";
        } else {
            LOGGER.error("\u672a\u68c0\u6d4b\u5230\u5bf9\u5e94\u6570\u636e\u5e93");
            sql = "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty((Object)sql)) {
            map.put("getTables", sql);
            return this.tableMapper.getAllTables(map);
        }
        return new ArrayList<Map<String, Object>>();
    }
}

