/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.general.dict.dao.SysDicTypeMapper;
import com.jxdinfo.hussar.general.dict.dto.DicSingleDto;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.dict.service.SysDicFrontService;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.general.dict.vo.DictLevelTreeVo;
import com.jxdinfo.hussar.general.dict.vo.DictSingleVo;
import com.jxdinfo.hussar.general.dict.vo.DictVo;
import com.jxdinfo.hussar.general.dict.vo.DictionaryVo;
import com.jxdinfo.hussar.general.dict.vo.GroupDictVo;
import com.jxdinfo.hussar.general.enums.GeneralServicesTipsEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysDicRefServiceImpl
implements ISysDicRefService {
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicTypeService dicTypeService;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private SysDicTypeMapper sysDicTypeMapper;
    @Resource
    private SysDicSingleMapper sysDicSingleMapper;
    @Resource
    private ISysDicService dictService;
    @Resource
    private SysDicFrontService sysDicFrontService;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;
    private static final String SECURITY_LEVEL = "security_level";
    private static final String FLAG_OF_ADD = "0";
    private static Integer SYS_USER_SECURITY_LEVEL = 3;
    private static Integer PUBLIC_SECURITY_LEVEL = 50;

    public List<DicSingle> getDictByType(String typeName) {
        DicType type;
        List<Object> result = new ArrayList<DicSingle>();
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":list";
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)(type = this.getTypeInfo(typeName)))) {
            LambdaQueryWrapper wp = Wrappers.lambdaQuery();
            wp.isNull(DicSingle::getParentId);
            ((LambdaQueryWrapper)wp.eq(DicSingle::getTypeId, (Object)type.getId())).orderByAsc(DicSingle::getSort);
            result = this.dicSingleService.list((Wrapper)wp);
        }
        return result;
    }

    public List<DicSingle> getDictByType(String typeName, Long appId) {
        List<Object> result = new ArrayList<DicSingle>();
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":list";
        if (ToolUtil.isEmpty(result)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)appId)) {
                ((LambdaQueryWrapper)wrapper.eq(DicType::getTypeName, (Object)typeName)).eq(DicType::getAppId, (Object)appId);
            } else {
                wrapper.eq(DicType::getTypeName, (Object)typeName);
            }
            DicType type = (DicType)this.dicTypeService.getOne((Wrapper)wrapper);
            if (ToolUtil.isNotEmpty((Object)type)) {
                LambdaQueryWrapper wp = Wrappers.lambdaQuery();
                wp.isNull(DicSingle::getParentId);
                ((LambdaQueryWrapper)wp.eq(DicSingle::getTypeId, (Object)type.getId())).orderByAsc(DicSingle::getSort);
                result = this.dicSingleService.list((Wrapper)wp);
            }
        }
        return result;
    }

    public LinkedHashMap<String, Object> getDictMapByType(String typeName) {
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":map";
        LinkedHashMap<String, String> result = (LinkedHashMap<String, String>)HussarCacheUtil.get((String)"hussar_dict_of_type_cache", (Object)key);
        if (ToolUtil.isEmpty((Object)result)) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            List<DicSingle> list = this.getDictByType(typeName);
            for (DicSingle dicSingle : list) {
                linkedHashMap.put(dicSingle.getValue(), dicSingle.getLabel());
            }
            result = linkedHashMap;
            HussarCacheUtil.put((String)"hussar_dict_of_type_cache", (Object)key, linkedHashMap);
        }
        return result;
    }

    public List<DicVo> getDicListByType(String typeName) {
        DicType type;
        List<Object> result = new ArrayList();
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":allShow:" + lang;
        result = (List)HussarCacheUtil.get((String)"hussar_dict_of_type_cache", (Object)key);
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)(type = this.getTypeInfo(typeName)))) {
            result = this.dicSingleService.getDicListByType(type.getId());
            HussarCacheUtil.put((String)"hussar_dict_of_type_cache", (Object)key, result);
        }
        if (SECURITY_LEVEL.equals(typeName)) {
            Integer SECURITY_LEVEL = BaseSecurityUtil.getSecurityLevel();
            result = !SYS_USER_SECURITY_LEVEL.equals(SECURITY_LEVEL) && HussarUtils.isNotEmpty((Object)SECURITY_LEVEL) ? result.stream().filter(s -> Integer.parseInt(s.getValue()) <= SECURITY_LEVEL).collect(Collectors.toList()) : result.stream().filter(s -> Integer.parseInt(s.getValue()) == PUBLIC_SECURITY_LEVEL).collect(Collectors.toList());
        }
        TranslateUtil.translate(result, DicVo::getLabelLangKey, DicVo::setLabel);
        return result;
    }

    public List<DicVo> getCertainDictOptions(String typeName, String[] optionValues) {
        DicType type;
        List result = new ArrayList();
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":onlyShow";
        result = (List)HussarCacheUtil.get((String)"hussar_dict_of_type_cache", (Object)key);
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)(type = this.getTypeInfo(typeName)))) {
            result = this.dicSingleService.getCertainDictOptions(type.getId(), optionValues);
            HussarCacheUtil.put((String)"hussar_dict_of_type_cache", (Object)key, result);
        }
        return result;
    }

    public List<DicVo> getDictOptionsWithoutNotShows(String typeName, String[] notShows) {
        DicType type;
        List result = new ArrayList();
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":notShow";
        result = (List)HussarCacheUtil.get((String)"hussar_dict_of_type_cache", (Object)key);
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)(type = this.getTypeInfo(typeName)))) {
            result = this.dicSingleService.getDictOptionsWithoutNotShows(type.getId(), notShows);
            HussarCacheUtil.put((String)"hussar_dict_of_type_cache", (Object)key, result);
        }
        return result;
    }

    public String getDictLabel(String typeName, String value) {
        String result = "";
        DicType type = this.getTypeInfo(typeName);
        if (!ToolUtil.isOneEmpty((Object[])new Object[]{type, value})) {
            result = this.dicSingleService.getDictLabel(type.getId(), value);
        }
        return result;
    }

    public String getDictValue(String typeName, String label) {
        String result = "";
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            result = this.dicSingleService.getDictValue(type.getId(), label);
        }
        return result;
    }

    public String getDictOptionsInJson(String typeName) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        List<DicSingle> list = this.getDictByType(typeName);
        for (DicSingle dicSingle : list) {
            linkedHashMap.put(dicSingle.getLabel(), dicSingle.getValue());
        }
        return JSON.toJSONString(linkedHashMap);
    }

    public List<DicType> getLevelDictType(String selectType) {
        List result;
        switch (selectType) {
            case "1": {
                result = this.getOneLevel();
                break;
            }
            case "2": {
                result = this.getMultilevel();
                break;
            }
            case "3": {
                result = this.dicTypeService.selectListByParentId();
                break;
            }
            default: {
                throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_EXCEPTION_UCORRECT_QUERY_TYPE.getMessage()));
            }
        }
        return result;
    }

    public List<DicType> getLevelDictType(String selectType, Long appId) {
        List result;
        switch (selectType) {
            case "1": {
                result = this.getOneLevelByAppId(appId);
                break;
            }
            case "2": {
                result = this.getMultilevelByAppId(appId);
                break;
            }
            case "3": {
                result = this.dicTypeService.selectListByParentId(appId);
                break;
            }
            default: {
                throw new BaseException("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u67e5\u8be2\u7c7b\u578b");
            }
        }
        return result;
    }

    public List<DicType> getOneLevel() {
        return this.sysDicTypeMapper.getOneLevel();
    }

    public List<DicType> getOneLevelByAppId(Long appId) {
        return this.sysDicTypeMapper.getMultilevelByAppId(appId);
    }

    public List<DicType> getMultilevel() {
        return this.sysDicTypeMapper.getMultilevel();
    }

    public List<DicType> getMultilevelByAppId(Long appId) {
        return this.sysDicTypeMapper.getMultilevelByAppId(appId);
    }

    public List<DicLevelTreeVo> getLevelDictByType(Long typeId) {
        List<DicLevelTreeVo> levelDictSingleList = this.sysDicSingleMapper.getLevelDictSingleById(typeId);
        if (ToolUtil.isNotEmpty(levelDictSingleList)) {
            return this.mergeDicLevelTree(levelDictSingleList);
        }
        return levelDictSingleList;
    }

    public List<DicLevelTreeVo> getLevelDictByTypeName(String typeName) {
        List<DicLevelTreeVo> levelDictSingleList = this.sysDicSingleMapper.getLevelDictSingleByName(typeName);
        if (ToolUtil.isNotEmpty(levelDictSingleList)) {
            List<DicLevelTreeVo> levelDictTreeList = this.mergeDicLevelTree(levelDictSingleList);
            TranslateUtil.translate(levelDictTreeList, DicLevelTreeVo::getLabelLangKey, DicLevelTreeVo::setLabel);
            return levelDictTreeList;
        }
        return levelDictSingleList;
    }

    public List<DicLevelTreeVo> mergeDicLevelTree(List<DicLevelTreeVo> dicLevelTreeVoList) {
        HashMap<Long, DicLevelTreeVo> idAndItem = new HashMap<Long, DicLevelTreeVo>();
        for (DicLevelTreeVo dicLevelTreeVo : dicLevelTreeVoList) {
            idAndItem.put(dicLevelTreeVo.getId(), dicLevelTreeVo);
        }
        ArrayList<Long> highestIdList = new ArrayList<Long>();
        for (DicLevelTreeVo item : dicLevelTreeVoList) {
            DicLevelTreeVo temp = (DicLevelTreeVo)idAndItem.get(item.getParentId());
            if (ToolUtil.isNotEmpty((Object)temp)) {
                temp.getChildrenList().add(item);
                continue;
            }
            highestIdList.add(item.getId());
        }
        ArrayList<DicLevelTreeVo> arrayList = new ArrayList<DicLevelTreeVo>();
        for (Long single : highestIdList) {
            arrayList.add((DicLevelTreeVo)idAndItem.get(single));
        }
        return arrayList;
    }

    public List<GroupDictVo> getGroupDictByTypeName(String typeName) {
        return this.sysDicSingleMapper.getGroupDictByTypeName(typeName);
    }

    private DicType getTypeInfo(String typeName) {
        return (DicType)this.dicTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicType::getTypeName, (Object)typeName), false);
    }

    public List<DictVo> getDictVosByTypeNames(List<String> typeNames) {
        List<Object> dictVos = new ArrayList();
        if (ToolUtil.isNotEmpty(typeNames)) {
            dictVos = this.getDictVos(typeNames);
        }
        if (typeNames.contains(SECURITY_LEVEL) && this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            for (int i = 0; i < dictVos.size(); ++i) {
                if (!((DictVo)dictVos.get(i)).getTypeName().equals(SECURITY_LEVEL)) continue;
                Integer n = BaseSecurityUtil.getSecurityLevel();
                List list = ((DictVo)dictVos.get(i)).getSingleList();
                if (HussarUtils.isNotEmpty((Object)n)) {
                    List collect = list.stream().filter(dicSingle -> Integer.parseInt(dicSingle.getValue()) <= securityLevel1).collect(Collectors.toList());
                    ((DictVo)dictVos.get(i)).setSingleList(collect);
                    break;
                }
                ((DictVo)dictVos.get(i)).setSingleList(list);
                break;
            }
        }
        for (DictVo dictVo : dictVos) {
            TranslateUtil.translate((List)dictVo.getSingleList(), DicSingle::getLabelLangKey, DicSingle::setLabel);
        }
        return dictVos;
    }

    public List<DictVo> getDictVosByTypeNames(List<String> typeNames, Long appId) {
        List<DictVo> dictVos = new ArrayList<DictVo>();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            if (ToolUtil.isNotEmpty(typeNames)) {
                dictVos = this.sysDicSingleMapper.getDictVosByTypeNamesInApplication(typeNames, appId);
            }
        } else if (ToolUtil.isNotEmpty(typeNames)) {
            dictVos = this.sysDicSingleMapper.getDictVosByTypeNames(typeNames);
        }
        return dictVos;
    }

    public List<DictLevelTreeVo> getDictLevelTreeVosByTypeNames(List<String> typeNames) {
        AssertUtil.isNotEmpty(typeNames, (String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_TYPE_EMPTY.getMessage()));
        List<DictLevelTreeVo> vos = this.sysDicSingleMapper.getDictLevelTreeVosByTypeNames(typeNames);
        for (DictLevelTreeVo vo : vos) {
            vo.setLevelDictSingleList(this.mergeDicLevelTree(vo.getLevelDictSingleList()));
        }
        return vos;
    }

    public List<DictVo> getDictVosByTypeNamesByDictValue(List<String> typeNames, String dictValue) {
        List<Object> dictVos = new ArrayList();
        if (ToolUtil.isNotEmpty(typeNames)) {
            dictVos = this.getDictVos(typeNames);
        }
        for (int i = 0; i < dictVos.size(); ++i) {
            if (!((DictVo)dictVos.get(i)).getTypeName().equals(SECURITY_LEVEL)) continue;
            List list = ((DictVo)dictVos.get(i)).getSingleList();
            List collect = list.stream().filter(dicSingle -> Integer.parseInt(dicSingle.getValue()) <= Integer.parseInt(dictValue)).collect(Collectors.toList());
            ((DictVo)dictVos.get(i)).setSingleList(collect);
            break;
        }
        dictVos.forEach(dictVo -> TranslateUtil.translate((List)dictVo.getSingleList(), DicSingle::getLabelLangKey, DicSingle::setLabel));
        return dictVos;
    }

    private List<DictVo> getDictVos(List<String> typeNames) {
        List<Object> newDictVos = new ArrayList();
        ArrayList<DictVo> dictVos = new ArrayList<DictVo>();
        ArrayList<String> newTypeNames = new ArrayList<String>();
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        for (String typeName : typeNames) {
            String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":listVos:" + lang;
            DictionaryVo result = (DictionaryVo)HussarCacheUtil.get((String)"hussar_dict_of_type_cache", (Object)key);
            if (HussarUtils.isEmpty((Object)result)) {
                newTypeNames.add(typeName);
                continue;
            }
            DictVo dictVo = new DictVo();
            ArrayList<DicSingle> singleList = new ArrayList<DicSingle>();
            dictVo.setTypeName(result.getTypeName());
            for (DictSingleVo dictSingleVo : result.getDictSingleVoList()) {
                DicSingle dicSingle = new DicSingle();
                HussarUtils.copy((Object)dictSingleVo, (Object)dicSingle);
                singleList.add(dicSingle);
            }
            dictVo.setSingleList(singleList);
            dictVos.add(dictVo);
        }
        if (HussarUtils.isNotEmpty(newTypeNames)) {
            newDictVos = this.sysDicSingleMapper.getDictVosByTypeNames(newTypeNames);
        }
        if (HussarUtils.isNotEmpty(newDictVos)) {
            for (DictVo dictVo : newDictVos) {
                DictionaryVo dictionaryVo = new DictionaryVo();
                ArrayList<DictSingleVo> dictSingleVoList = new ArrayList<DictSingleVo>();
                dictionaryVo.setTypeName(dictVo.getTypeName());
                for (DicSingle dicSingle : dictVo.getSingleList()) {
                    DictSingleVo dictSingleVo = new DictSingleVo();
                    HussarUtils.copy((Object)dicSingle, (Object)dictSingleVo);
                    dictSingleVoList.add(dictSingleVo);
                }
                dictionaryVo.setDictSingleVoList(dictSingleVoList);
                String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + dictionaryVo.getTypeName() + ":listVos:" + lang;
                HussarCacheUtil.put((String)"hussar_dict_of_type_cache", (Object)key, (Object)dictionaryVo);
            }
            dictVos.addAll(newDictVos);
        }
        return dictVos;
    }

    public ApiResponse addGroup(DicGroup dicGroup) {
        return this.dictService.saveDicGroup(dicGroup);
    }

    public ApiResponse add(DicType dicType) {
        Long parentId = dicType.getParentId();
        if (HussarUtils.isNotEmpty((Object)TranslateUtil.getDefaultTranslateName((String)dicType.getDescriptionLangKey()))) {
            dicType.setTypeDescription(TranslateUtil.getDefaultTranslateName((String)dicType.getDescriptionLangKey()));
        }
        String dictTypeDesc = dicType.getTypeDescription();
        String dictTypeName = dicType.getTypeName();
        String dictValues = null;
        String descriptionLangKey = dicType.getDescriptionLangKey();
        Long appId = dicType.getAppId();
        return this.dictService.addDictType(parentId, dictTypeDesc, dictTypeName, dictValues, descriptionLangKey, appId);
    }

    public ApiResponse addSingle(DicSingleDto dicSingleDto) {
        Long dictId = dicSingleDto.getId();
        Long dictTypeId = dicSingleDto.getTypeId();
        if (HussarUtils.isNotEmpty((Object)TranslateUtil.getDefaultTranslateName((String)dicSingleDto.getLabelLangKey()))) {
            dicSingleDto.setLabel(TranslateUtil.getDefaultTranslateName((String)dicSingleDto.getLabelLangKey()));
        }
        String dictName = dicSingleDto.getLabel();
        String labelLangKey = dicSingleDto.getLabelLangKey();
        String dictValue = dicSingleDto.getValue();
        String flag = dicSingleDto.getFlag();
        if (FLAG_OF_ADD.equals(flag)) {
            return this.dictService.saveDicSingle(dictId, dictTypeId, dictName, dictValue, labelLangKey);
        }
        return this.dictService.saveSingleChild(dictId, dictTypeId, dictName, dictValue, labelLangKey);
    }

    public ApiResponse<List<JSTreeModel>> dicTypeTreeData() {
        return ApiResponse.success((Object)this.sysDicFrontService.queryDicTypeTreeData(null));
    }

    public DicType getByTypeName(String typeName) {
        return (DicType)this.dicTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicType::getTypeName, (Object)typeName));
    }

    public DicSingle getDicSingleById(Long dictSignId) {
        return (DicSingle)this.sysDicSingleMapper.selectById(dictSignId);
    }

    public List<DicVo> getAttachmentSecurityLevel(String typeName, Integer dataSecurityLevel) {
        DicType type;
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":allShow:" + lang;
        List result = (List)HussarCacheUtil.get((String)"hussar_dict_of_type_cache", (Object)key);
        if (ToolUtil.isEmpty((Object)result) && ToolUtil.isNotEmpty((Object)(type = this.getTypeInfo(typeName)))) {
            result = this.dicSingleService.getDicListByType(type.getId());
            HussarCacheUtil.put((String)"hussar_dict_of_type_cache", (Object)key, result);
        }
        if (SECURITY_LEVEL.equals(typeName)) {
            Integer securityLevel;
            result = HussarUtils.isNotEmpty((Object)dataSecurityLevel) ? result.stream().filter(s -> Integer.parseInt(s.getValue()) <= dataSecurityLevel).collect(Collectors.toList()) : (!SYS_USER_SECURITY_LEVEL.equals(securityLevel = BaseSecurityUtil.getSecurityLevel()) && HussarUtils.isNotEmpty((Object)securityLevel) ? result.stream().filter(s -> Integer.parseInt(s.getValue()) <= securityLevel).collect(Collectors.toList()) : result.stream().filter(s -> Integer.parseInt(s.getValue()) == PUBLIC_SECURITY_LEVEL).collect(Collectors.toList()));
        }
        TranslateUtil.translate((List)result, DicVo::getLabelLangKey, DicVo::setLabel);
        return result;
    }

    public String getDictLabelTranslate(String typeName, String value) {
        String result = "";
        DicType type = this.getTypeInfo(typeName);
        if (!ToolUtil.isOneEmpty((Object[])new Object[]{type, value})) {
            result = this.dicSingleService.getDictLabelTranslate(type.getId(), value);
        }
        return result;
    }
}

