/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.service.impl;

import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.excel.builder.ConcreteExcelBuilder;
import com.jxdinfo.hussar.excel.builder.ExcelProduct;
import com.jxdinfo.hussar.excel.constants.ExcelConstants;
import com.jxdinfo.hussar.excel.handler.CustomSheetWriteHandler;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.model.ImportSheetMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.excel.util.CustomMergeStrategy;
import com.jxdinfo.hussar.excel.util.CustomVerticalCellStyleStrategy;
import com.jxdinfo.hussar.general.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.general.dict.dao.SysDicTypeMapper;
import com.jxdinfo.hussar.general.dict.model.DicExcelExportDesc;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.model.DictExcel;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.enums.GeneralServicesTipsEnum;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.FileAddition;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.general.dict.service.impl.SysDicTypeServiceImpl")
public class SysDicTypeServiceImpl
extends HussarServiceImpl<SysDicTypeMapper, DicType>
implements ISysDicTypeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysDicTypeServiceImpl.class);
    @Resource
    private SysDicTypeMapper sysDicTypeMapper;
    @Resource
    private SysDicSingleMapper singleMapper;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicTypeService dicTypeService;
    @Resource
    private IHussarBaseExcelService hussarBaseExcelServiceImpl;
    @Autowired
    private IHussarBaseExcelService hussarBaseExcelService;
    @Resource(name="com.jxdinfo.hussar.general.dict.service.impl.SysDicServiceImpl")
    private IHussarBaseCustomExcelService hussarBaseCustomExcelServiceImpl;
    @Resource
    private ISysExcelTaskService sysExcelTaskServiceImpl;
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService iSysExcelTaskService;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    protected IProtectionStatusConfigBoService protectionStatusConfigBoService;
    @Resource
    protected ISysDicRefService sysDicRefService;
    protected static final String SECURITY_LEVEL = "security_level";

    public void evictTypeCacheById(Long id) {
        DicType type = (DicType)this.getById(id);
        if (ToolUtil.isNotEmpty((Object)type)) {
            HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)("dict_of_type:" + type.getTypeName() + ":*"));
        }
    }

    public List<JSTreeModel> dicExportTreeData() {
        return this.sysDicTypeMapper.dicExportTreeData();
    }

    public List<JSTreeModel> getDicExportTreeDataByGroupId(Long groupId) {
        List<JSTreeModel> dicTreeList = this.sysDicTypeMapper.getDicExportTreeDataByGroupId(groupId);
        TranslateUtil.translate(dicTreeList, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        return dicTreeList;
    }

    public void exportDict(List<String> idList, HttpServletResponse response) {
        List<Long> convertIds = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List group = this.dicGroupService.getGroupBytypeIds(convertIds);
        List type = this.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(DicType::getId, convertIds));
        List<Long> singleIdList = this.getSingleIdByTypeId(convertIds, new ArrayList<Long>());
        List single = new ArrayList();
        if (singleIdList.size() > 0) {
            single = this.dicSingleService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(DicSingle::getId, singleIdList));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", type);
        data.put("single", single);
        data.put("group", group);
        data.put("export_type", "dictionary");
        byte[] serializeData = new byte[]{};
        try {
            serializeData = SerializeUtils.serialize(data);
        }
        catch (Exception e) {
            LOGGER.error("\u5e8f\u5217\u5316\u51fa\u9519", (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.SERIAL_ERR.getMessage()));
        }
        String fileName = "dict_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    private List<Long> getSingleIdByTypeId(List<Long> typeIdList, List<Long> resultList) {
        List splitIdList = LambdaQueryUtil.getSplitList(typeIdList);
        List<Long> singleIdList = this.singleMapper.getSingleIdByTypeId(splitIdList);
        if (ToolUtil.isNotEmpty(singleIdList)) {
            resultList.addAll(singleIdList);
            this.getSingleIdByTypeId(singleIdList, resultList);
        }
        return resultList;
    }

    public JSONObject importDictData(byte[] content) {
        Map data;
        JSONObject result = new JSONObject();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            LOGGER.error("\u53cd\u5e8f\u5217\u5316\u6570\u636e\u51fa\u9519", (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_IMPORT_ERROR.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_IMPORT_ERROR.getMessage()));
        }
        String exportType = (String)data.get("export_type");
        if (!"dictionary".equals(exportType)) {
            result.put("success", (Object)"false");
            result.put("importType", (Object)exportType);
            result.put("trueType", (Object)"dictionary");
            return result;
        }
        List group = (List)data.get("group");
        List type = (List)data.get("type");
        List single = (List)data.get("single");
        Map<String, Integer> groupCount = this.insertOrUpdateList(group);
        Map<String, Integer> typeCount = this.insertOrUpdateList(type);
        Map<String, Integer> singleCount = this.insertOrUpdateList(single);
        result.put("success", (Object)"true");
        result.put("groupInsert", (Object)groupCount.get("insert"));
        result.put("groupUpdate", (Object)groupCount.get("update"));
        result.put("typeInsert", (Object)typeCount.get("insert"));
        result.put("typeUpdate", (Object)typeCount.get("update"));
        result.put("singleInsert", (Object)singleCount.get("insert"));
        result.put("singleUpdate", (Object)singleCount.get("update"));
        return result;
    }

    public Map<String, Integer> insertOrUpdateList(List<?> list) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(list)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object obj = list.get(i);
                if (obj instanceof DicGroup) {
                    DicGroup dicGroup = (DicGroup)obj;
                    if (this.dicGroupService.updateById((Object)dicGroup)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.dicGroupService.save((Object)dicGroup);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof DicType) {
                    DicType dicType = (DicType)obj;
                    if (super.updateById((BaseEntity)dicType)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        super.save((BaseEntity)dicType);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof DicSingle) {
                    DicSingle dicSingle = (DicSingle)obj;
                    if (this.dicSingleService.updateById((Object)dicSingle)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.dicSingleService.save((Object)dicSingle);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_INSERT_OR_UPDATE_ERROR.getMessage()), e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    public IPage<DicType> queryList(Page page, String rangeType) {
        String rootRange = "root";
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        HashMap result = new HashMap(5);
        if (ToolUtil.isNotEmpty((Object)rangeType) && !rootRange.equals(rangeType)) {
            ew.eq(DicType::getRangeType, (Object)rangeType);
        }
        ew.orderByAsc(DicType::getSort);
        List list2 = ((Page)this.page((IPage)page, (Wrapper)ew)).getRecords();
        TranslateUtil.translate((List)list2, DicType::getDescriptionLangKey, DicType::setTypeDescription);
        page.setRecords(list2);
        return page;
    }

    public List<DicType> selectListByParentId() {
        List list = this.list((Wrapper)new LambdaQueryWrapper().orderByAsc(DicType::getSort));
        TranslateUtil.translate((List)list, DicType::getDescriptionLangKey, DicType::setTypeDescription);
        return list;
    }

    public List<DicType> selectListByParentId(Long appId) {
        return this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicType::getAppId, (Object)appId)).orderByAsc(DicType::getSort));
    }

    public List<DicSingle> selectChildsById(String id) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(id != null, DicType::getId, (Object)id));
        List dicSingles = list.size() > 0 ? this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)id)).orderByAsc(DicSingle::getSort)) : this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getParentId, (Object)id)).orderByAsc(DicSingle::getSort));
        return dicSingles;
    }

    private void warpTheObjectToMap(DicType dt, List<Map<String, Object>> list) {
        StringBuilder detail = new StringBuilder();
        Long typeId = dt.getId();
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("id", typeId);
        map.put("parentId", dt.getParentId());
        map.put("typeName", dt.getTypeName());
        map.put("typeDescription", dt.getTypeDescription());
        map.put("rangeType", dt.getRangeType());
        List dicts = this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)typeId)).orderByAsc(DicSingle::getSort));
        if (dicts != null) {
            for (DicSingle dict : dicts) {
                detail.append(dict.getValue()).append(":").append(dict.getLabel()).append(", ");
            }
            map.put("detail", ToolUtil.removeSuffix((String)detail.toString(), (String)", "));
        }
        list.add(map);
    }

    public List<DicType> selectDicTypeByDouble(List<DicType> dicTypeList) {
        ArrayList<DicType> returnList = new ArrayList<DicType>();
        LambdaQueryWrapper dicTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < dicTypeList.size(); i += 699) {
            List<DicType> temp;
            if (i + 699 >= dicTypeList.size()) {
                temp = dicTypeList.subList(i, dicTypeList.size());
                dicTypeLambdaQueryWrapper.clear();
                for (DicType dicType : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)dicTypeLambdaQueryWrapper.or()).eq(DicType::getId, (Object)dicType.getId())).ne(DicType::getTypeName, (Object)dicType.getTypeName());
                }
                returnList.addAll(this.sysDicTypeMapper.selectList((Wrapper)dicTypeLambdaQueryWrapper));
                continue;
            }
            temp = dicTypeList.subList(i, i + 699);
            dicTypeLambdaQueryWrapper.clear();
            for (DicType dicType : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)dicTypeLambdaQueryWrapper.or()).eq(DicType::getId, (Object)dicType.getId())).ne(DicType::getTypeName, (Object)dicType.getTypeName());
            }
            returnList.addAll(this.sysDicTypeMapper.selectList((Wrapper)dicTypeLambdaQueryWrapper));
        }
        return returnList;
    }

    public List<DicType> selectDicTypeByTypeIds(List<Long> ids) {
        LambdaQueryWrapper dicTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)dicTypeLambdaQueryWrapper, DicType::getId, ids);
        dicTypeLambdaQueryWrapper.orderByAsc(DicType::getSort);
        return this.list((Wrapper)dicTypeLambdaQueryWrapper);
    }

    public List<DicType> selectDicTypeByTypeNames(List<String> typeNames) {
        LambdaQueryWrapper dicTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty(typeNames)) {
            return Collections.emptyList();
        }
        for (String name : typeNames) {
            ((LambdaQueryWrapper)dicTypeLambdaQueryWrapper.or()).eq(DicType::getTypeName, (Object)name);
        }
        dicTypeLambdaQueryWrapper.orderByAsc(DicType::getSort);
        return this.list((Wrapper)dicTypeLambdaQueryWrapper);
    }

    public List<DicType> getAllDicTypeInDB() {
        return this.sysDicTypeMapper.getAllDicTypeInDB();
    }

    public void exportDictExcel(String ids, Long taskId, boolean exportKey) throws Exception {
        if (HussarUtils.isEmpty((Object)ids)) {
            throw new Exception(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_EXPORT_DATA_EMPTY_ERROR.getMessage()));
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        List<String> idList = Arrays.asList(ids.split(","));
        List typeIds = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List types = this.list((Wrapper)((LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(DicType::getId, typeIds).orderByAsc(HussarBaseEntity::getCreateTime)).orderByAsc(DicType::getSort));
        List singles = this.dicSingleService.getDicSinglesByTypeIdsOrderByTypeSort(typeIds);
        TranslateUtil.translate((List)types, DicType::getDescriptionLangKey, DicType::setTypeDescription);
        TranslateUtil.translate((List)singles, DicSingle::getLabelLangKey, DicSingle::setLabel);
        ArrayList<DictExcel> dicExcels = new ArrayList<DictExcel>();
        ArrayList<Integer> singleNumInSameType = new ArrayList<Integer>();
        if (HussarUtils.isNotEmpty((Object)singles)) {
            LinkedHashMap dictTypeMap = new LinkedHashMap();
            types.forEach(type -> dictTypeMap.put(type.getId(), type));
            LinkedHashMap<Long, DicSingle> dictSingleMap = new LinkedHashMap<Long, DicSingle>();
            singles.forEach(single -> dictSingleMap.put(single.getId(), (DicSingle)single));
            for (DicType type2 : types) {
                Long typeId = type2.getId();
                Integer count = 0;
                for (int i = 0; i < singles.size(); ++i) {
                    DicSingle single2 = (DicSingle)singles.get(i);
                    if (!single2.getTypeId().equals(typeId)) continue;
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    DictExcel dictExcel = new DictExcel();
                    dictExcel.setTypeDesc(type2.getTypeDescription());
                    dictExcel.setTypeCode(type2.getTypeName());
                    dictExcel.setSingleLabel(single2.getLabel());
                    dictExcel.setSingleValue(single2.getValue());
                    dictExcel.setExcelTypeId(String.valueOf(typeId));
                    dictExcel.setExcelSingleId(String.valueOf(single2.getId()));
                    dictExcel.setIfUse(single2.getIfUse());
                    if (HussarUtils.isNotEmpty((Object)single2.getParentId())) {
                        Long parentSingleId = single2.getParentId();
                        String parentSingleLabels = this.getParentSingleLabels(dictSingleMap, parentSingleId, "");
                        dictExcel.setParentSingleLabels(parentSingleLabels);
                    }
                    dicExcels.add(dictExcel);
                    singles.remove(single2);
                    --i;
                }
                if (count.equals(0)) {
                    DictExcel dictExcel = new DictExcel();
                    dictExcel.setTypeDesc(type2.getTypeDescription());
                    dictExcel.setTypeCode(type2.getTypeName());
                    dictExcel.setExcelTypeId(exportKey ? String.valueOf(typeId) : null);
                    dicExcels.add(dictExcel);
                    count = 1;
                }
                singleNumInSameType.add(count);
            }
        } else {
            for (DicType type3 : types) {
                DictExcel dictExcel = new DictExcel();
                dictExcel.setTypeDesc(type3.getTypeDescription());
                dictExcel.setTypeCode(type3.getTypeName());
                dicExcels.add(dictExcel);
            }
        }
        ClassSheetMsg classSheetMsg1 = new ClassSheetMsg(DictExcel.class, dicExcels, TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_EXPORT_EXCEL_SHEETNAME.getMessage()), 0);
        if (!exportKey) {
            classSheetMsg1.setExcludeColumnIndexes(Arrays.asList(6, 7));
        }
        List mergeColIndexList = Stream.of(0, 1, 7).collect(Collectors.toList());
        ArrayList<ArrayList<Integer>> mergeColDataGroupCountList = new ArrayList<ArrayList<Integer>>();
        mergeColDataGroupCountList.add(singleNumInSameType);
        mergeColDataGroupCountList.add(singleNumInSameType);
        mergeColDataGroupCountList.add(singleNumInSameType);
        CustomMergeStrategy customMergeStrategy = new CustomMergeStrategy(mergeColIndexList, mergeColDataGroupCountList, Integer.valueOf(1));
        classSheetMsg1.addHandler((WriteHandler)customMergeStrategy);
        List<String> alignList = Arrays.asList(new String[6]);
        alignList.set(4, "left");
        CustomVerticalCellStyleStrategy customVerticalCellStyleStrategy = new CustomVerticalCellStyleStrategy(alignList, false);
        classSheetMsg1.addHandler((WriteHandler)customVerticalCellStyleStrategy);
        HashMap<Integer, Short> styleMap = new HashMap<Integer, Short>();
        styleMap.put(0, (short)49);
        styleMap.put(1, (short)49);
        styleMap.put(2, (short)49);
        styleMap.put(3, (short)49);
        styleMap.put(4, (short)49);
        styleMap.put(5, (short)49);
        styleMap.put(6, (short)49);
        styleMap.put(7, (short)49);
        classSheetMsg1.addHandler((WriteHandler)new CustomSheetWriteHandler(styleMap));
        DicExcelExportDesc dicExcelExportDesc = new DicExcelExportDesc();
        dicExcelExportDesc.setExportOperator(securityUser.getUserName());
        String exportTime = Java8DateUtils.getCurrentDateDTimeStr();
        dicExcelExportDesc.setExportTime(Java8DateUtils.getCurrentDateTimeStr());
        ArrayList<DicExcelExportDesc> dicExcelExportDescList = new ArrayList<DicExcelExportDesc>();
        dicExcelExportDescList.add(dicExcelExportDesc);
        ClassSheetMsg classSheetMsg2 = new ClassSheetMsg(DicExcelExportDesc.class, dicExcelExportDescList, TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_EXPORT_DESCRIPTION.getMessage()), 1);
        Locale locale = LocaleContextHolder.getLocale();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseExcelExecutor != null) {
            hussarBaseExcelExecutor.execute(() -> {
                ExcelProduct excelProduct = null;
                try {
                    excelProduct = new ConcreteExcelBuilder(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_EXPORT_EXCEL_SHEETNAME.getMessage()) + exportTime + ".xlsx", taskId, this.hussarBaseExcelServiceImpl).makeClassSheet(classSheetMsg1).makeClassSheet(classSheetMsg2).buildExcelProduct();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.sysExcelTaskServiceImpl.updateById((Object)excelProduct.getTask());
            });
        }
    }

    public void exportDictExcelWithSecurity(String ids, Long taskId, String securityLevel, boolean exportKey) throws Exception {
        if (HussarUtils.isEmpty((Object)ids)) {
            throw new Exception(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_EXPORT_DATA_EMPTY_ERROR.getMessage()));
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        List<String> idList = Arrays.asList(ids.split(","));
        List typeIds = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List types = this.list((Wrapper)((LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(DicType::getId, typeIds).orderByAsc(HussarBaseEntity::getCreateTime)).orderByAsc(DicType::getSort));
        List singles = this.dicSingleService.getDicSinglesByTypeIdsOrderByTypeSort(typeIds);
        TranslateUtil.translate((List)types, DicType::getDescriptionLangKey, DicType::setTypeDescription);
        TranslateUtil.translate((List)singles, DicSingle::getLabelLangKey, DicSingle::setLabel);
        ArrayList<DictExcel> dicExcels = new ArrayList<DictExcel>();
        ArrayList<Integer> singleNumInSameType = new ArrayList<Integer>();
        if (HussarUtils.isNotEmpty((Object)singles)) {
            LinkedHashMap dictTypeMap = new LinkedHashMap();
            types.forEach(type -> dictTypeMap.put(type.getId(), type));
            LinkedHashMap<Long, DicSingle> dictSingleMap = new LinkedHashMap<Long, DicSingle>();
            singles.forEach(single -> dictSingleMap.put(single.getId(), (DicSingle)single));
            for (DicType type2 : types) {
                Long typeId = type2.getId();
                Integer count = 0;
                for (int i = 0; i < singles.size(); ++i) {
                    DicSingle single2 = (DicSingle)singles.get(i);
                    if (!single2.getTypeId().equals(typeId)) continue;
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    DictExcel dictExcel = new DictExcel();
                    dictExcel.setTypeDesc(type2.getTypeDescription());
                    dictExcel.setTypeCode(type2.getTypeName());
                    dictExcel.setSingleLabel(single2.getLabel());
                    dictExcel.setSingleValue(single2.getValue());
                    dictExcel.setExcelTypeId(String.valueOf(typeId));
                    dictExcel.setExcelSingleId(String.valueOf(single2.getId()));
                    dictExcel.setIfUse(single2.getIfUse());
                    if (HussarUtils.isNotEmpty((Object)single2.getParentId())) {
                        Long parentSingleId = single2.getParentId();
                        String parentSingleLabels = this.getParentSingleLabels(dictSingleMap, parentSingleId, "");
                        dictExcel.setParentSingleLabels(parentSingleLabels);
                    }
                    dicExcels.add(dictExcel);
                    singles.remove(single2);
                    --i;
                }
                if (count.equals(0)) {
                    DictExcel dictExcel = new DictExcel();
                    dictExcel.setTypeDesc(type2.getTypeDescription());
                    dictExcel.setTypeCode(type2.getTypeName());
                    dictExcel.setExcelTypeId(exportKey ? String.valueOf(typeId) : null);
                    dicExcels.add(dictExcel);
                    count = 1;
                }
                singleNumInSameType.add(count);
            }
        } else {
            for (DicType type3 : types) {
                DictExcel dictExcel = new DictExcel();
                dictExcel.setTypeDesc(type3.getTypeDescription());
                dictExcel.setTypeCode(type3.getTypeName());
                dicExcels.add(dictExcel);
            }
        }
        ClassSheetMsg classSheetMsg1 = new ClassSheetMsg(DictExcel.class, dicExcels, TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_EXPORT_EXCEL_SHEETNAME.getMessage()), 0);
        if (!exportKey) {
            classSheetMsg1.setExcludeColumnIndexes(Arrays.asList(6, 7));
        }
        List mergeColIndexList = Stream.of(0, 1, 7).collect(Collectors.toList());
        ArrayList<ArrayList<Integer>> mergeColDataGroupCountList = new ArrayList<ArrayList<Integer>>();
        mergeColDataGroupCountList.add(singleNumInSameType);
        mergeColDataGroupCountList.add(singleNumInSameType);
        mergeColDataGroupCountList.add(singleNumInSameType);
        CustomMergeStrategy customMergeStrategy = new CustomMergeStrategy(mergeColIndexList, mergeColDataGroupCountList, Integer.valueOf(1));
        classSheetMsg1.addHandler((WriteHandler)customMergeStrategy);
        List<String> alignList = Arrays.asList(new String[6]);
        alignList.set(4, "left");
        CustomVerticalCellStyleStrategy customVerticalCellStyleStrategy = new CustomVerticalCellStyleStrategy(alignList, false);
        classSheetMsg1.addHandler((WriteHandler)customVerticalCellStyleStrategy);
        HashMap<Integer, Short> styleMap = new HashMap<Integer, Short>();
        styleMap.put(0, (short)49);
        styleMap.put(1, (short)49);
        styleMap.put(2, (short)49);
        styleMap.put(3, (short)49);
        styleMap.put(4, (short)49);
        styleMap.put(5, (short)49);
        styleMap.put(6, (short)49);
        styleMap.put(7, (short)49);
        classSheetMsg1.addHandler((WriteHandler)new CustomSheetWriteHandler(styleMap));
        DicExcelExportDesc dicExcelExportDesc = new DicExcelExportDesc();
        dicExcelExportDesc.setExportOperator(securityUser.getUserName());
        String exportTime = Java8DateUtils.getCurrentDateDTimeStr();
        dicExcelExportDesc.setExportTime(Java8DateUtils.getCurrentDateTimeStr());
        ArrayList<DicExcelExportDesc> dicExcelExportDescList = new ArrayList<DicExcelExportDesc>();
        dicExcelExportDescList.add(dicExcelExportDesc);
        ClassSheetMsg classSheetMsg2 = new ClassSheetMsg(DicExcelExportDesc.class, dicExcelExportDescList, TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_EXPORT_DESCRIPTION.getMessage()), 1);
        Locale locale = LocaleContextHolder.getLocale();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            LocaleContextHolder.setLocale((Locale)locale);
            ExcelProduct excelProduct = null;
            try {
                String excelFileName = TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_EXPORT_EXCEL_SHEETNAME.getMessage()) + exportTime + ".xlsx";
                if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue() && HussarUtils.isNotEmpty((Object)securityLevel)) {
                    String securityLabel = this.sysDicRefService.getDictLabelTranslate(SECURITY_LEVEL, securityLevel);
                    if (HussarUtils.isEmpty((Object)securityLabel)) {
                        securityLabel = TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.TRANSLATE_DICT_CONSTANT_PUBLIC.getMessage());
                    }
                    excelFileName = "\uff08" + securityLabel + "\uff09" + "-" + excelFileName;
                }
                excelProduct = new ConcreteExcelBuilder(excelFileName, taskId, this.hussarBaseExcelServiceImpl).makeClassSheet(classSheetMsg1).makeClassSheet(classSheetMsg2).buildExcelProduct();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.sysExcelTaskServiceImpl.updateById((Object)excelProduct.getTask());
        });
    }

    public void downloadDictExcelImpTpl(HttpServletResponse response, String fileKey) {
        this.hussarBaseExcelServiceImpl.downloadImportTpl(response, TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_DOWNLOAD_FILE_NAME.getMessage()), fileKey);
    }

    public void checkDictExcel(MultipartFile dictFile, String scenario, Long taskId, Long groupId) {
        InputStream input;
        try {
            input = dictFile.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fileName = dictFile.getOriginalFilename();
        ApiResponse fileResponse = this.ossService.backgroundUpload(dictFile);
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setCheckScenario(scenario);
        task.setFileName(fileName);
        task.setTaskFile((Long)fileResponse.getData());
        this.iSysExcelTaskService.updateById((Object)task);
        Locale locale = LocaleContextHolder.getLocale();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (hussarBaseExcelExecutor != null) {
            hussarBaseExcelExecutor.execute(() -> {
                ImportSheetMsg importSheetMsg1 = new ImportSheetMsg(Integer.valueOf(0), DictExcel.class, this.hussarBaseCustomExcelServiceImpl);
                LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
                importSheetMsgs.add(importSheetMsg1);
                ArrayList<Long> otherParams = new ArrayList<Long>();
                otherParams.add(groupId);
                this.hussarBaseExcelService.checkExcelSheets(input, importSheetMsgs, scenario, taskId, otherParams, this.getExcludeColumnIndexesMap(), null);
            });
        }
    }

    public void checkDictExcelWithSecurity(MultipartFile dictFile, String scenario, Long taskId, Long groupId, String securityLevel) {
        ApiResponse fileResponse;
        InputStream input;
        try {
            input = dictFile.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fileName = dictFile.getOriginalFilename();
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            FileAddition addition = new FileAddition();
            addition.setSecurityLevel(securityLevel);
            String securityAddition = JsonUtil.toJson((Object)addition);
            fileResponse = this.ossService.backgroundUploadWithAddition(dictFile, securityAddition);
        } else {
            fileResponse = this.ossService.backgroundUpload(dictFile);
        }
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setCheckScenario(scenario);
        task.setFileName(fileName);
        task.setTaskFile((Long)fileResponse.getData());
        this.iSysExcelTaskService.updateById((Object)task);
        Locale locale = LocaleContextHolder.getLocale();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            LocaleContextHolder.setLocale((Locale)locale);
            ImportSheetMsg importSheetMsg1 = new ImportSheetMsg(Integer.valueOf(0), DictExcel.class, this.hussarBaseCustomExcelServiceImpl);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg1);
            ArrayList<Long> otherParams = new ArrayList<Long>();
            otherParams.add(groupId);
            this.hussarBaseExcelService.checkExcelSheets(input, importSheetMsgs, scenario, taskId, otherParams, this.getExcludeColumnIndexesMap(), null);
        });
    }

    public void importDictExcel(String scenario, Long taskId, Long dictGroupId) {
        Locale locale = LocaleContextHolder.getLocale();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            LocaleContextHolder.setLocale((Locale)locale);
            ImportSheetMsg importSheetMsg1 = new ImportSheetMsg(Integer.valueOf(0), DictExcel.class, this.hussarBaseCustomExcelServiceImpl);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg1);
            ArrayList<Long> otherParams = new ArrayList<Long>();
            otherParams.add(dictGroupId);
            this.hussarBaseExcelService.importExcelSheets(importSheetMsgs, scenario, taskId, otherParams, this.getExcludeColumnIndexesMap());
        });
    }

    public String getParentSingleLabels(Map<Long, DicSingle> dictSingleMap, Long parentSingleId, String singleLabels) {
        DicSingle parentSingle = dictSingleMap.get(parentSingleId);
        String parentSingleLabels = "/" + parentSingle.getLabel() + singleLabels;
        if (HussarUtils.notNull((Object)parentSingle.getParentId())) {
            parentSingleId = parentSingle.getParentId();
            parentSingleLabels = this.getParentSingleLabels(dictSingleMap, parentSingleId, parentSingleLabels);
        }
        return parentSingleLabels;
    }

    private Map<String, Integer> getExcludeColumnIndexesMap() {
        LinkedHashMap<String, Integer> excludeColumnIndexesMap = new LinkedHashMap<String, Integer>();
        excludeColumnIndexesMap.put(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_COLUMN_PRIMARY_KEY.getMessage()), 6);
        excludeColumnIndexesMap.put(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_PRIMARY_KEY.getMessage()), 7);
        return excludeColumnIndexesMap;
    }

    static {
        ExcelConstants.TemplateMap.put("dictExportTpl", "static/dictExportTpl.xlsx");
        ExcelConstants.TemplateMap.put("dictImportTpl", "static/dictImportTpl.xlsx");
        ExcelConstants.TemplateMap.put("dictImportTplWithKey", "static/dictImportTplWithKey.xlsx");
    }
}

