/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.idtable.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.enums.GeneralServicesTipsEnum;
import com.jxdinfo.hussar.general.idtable.dao.SysIdtableInfoMapper;
import com.jxdinfo.hussar.general.idtable.dao.SysIdtableMapper;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.model.SysIdtableInfo;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@HussarTokenDs
@Service
public class SysIdtableServiceImpl
extends HussarServiceImpl<SysIdtableMapper, SysIdtable>
implements ISysIdtableService {
    private Logger logger = LoggerFactory.getLogger(SysIdtableServiceImpl.class);
    @Resource
    SysIdtableMapper sysIdtableMapper;
    @Resource
    SysIdtableInfoMapper sysIdtableInfoMapper;
    @Autowired
    private ISysCodeRuleService sysCodeRuleService;
    @Autowired
    protected IHussarValidateService validateService;

    public IPage<SysIdtable> queryList(Page page, SysIdtable sysIdtable) {
        if (ToolUtil.isEmpty((Object)sysIdtable) || ToolUtil.isEmpty((Object)page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_SEARCH_CONDITION_EMPTY.getMessage()));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.like(!StringUtils.isEmpty((Object)sysIdtable.getFieldName()), SysIdtable::getFieldName, (Object)sysIdtable.getFieldName())).like(!StringUtils.isEmpty((Object)sysIdtable.getTableName()), SysIdtable::getTableName, (Object)sysIdtable.getTableName())).orderByDesc(SysIdtable::getCreateTime);
        IPage sysIdtableIPage = this.sysIdtableMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return sysIdtableIPage;
    }

    public ApiResponse saveIdtable(SysIdtable sysIdtable) {
        if (ToolUtil.isEmpty((Object)sysIdtable.getFieldName())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_BUSINESS_NAME_EMPTY.getMessage()));
        }
        if (sysIdtable.getFieldName().length() > 30) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_NAME_MORE_THAN_30_CHARACTERS.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysIdtable.getIdDesc())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_CHINESE_NAME_EMPTY.getMessage()));
        }
        if (sysIdtable.getFieldName().length() > 30) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_CHINESE_NAME_MORE_THAN_30_CHARACTERS.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysIdtable.getTableName())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_TABLE_NAME_EMPTY.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysIdtable.getIdLength())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_NUMBER_LENGTH_EMPTY.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysIdtable.getCacheSize())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_INCREMENTAL_VALUE_EMPTY.getMessage()));
        }
        String validate = this.validateService.validate((Object)sysIdtable);
        if (ToolUtil.isNotEmpty((Object)validate)) {
            throw new BaseException(validate);
        }
        String fieldName = sysIdtable.getFieldName();
        String tableName = sysIdtable.getTableName();
        sysIdtable.setIsGlobal("0");
        sysIdtable.setTableName(tableName.toUpperCase());
        sysIdtable.setFieldName(fieldName.toUpperCase());
        SysIdtable idtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)idtable)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_BUSINESS_NAME_AND_TABLE_EXIST.getMessage()));
        }
        Integer num = 0;
        sysIdtable.setIdValue(num);
        if (!this.save((BaseEntity)sysIdtable)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_ADD_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_ADD_SUCCESS.getMessage()));
    }

    public ApiResponse updateIdtable(SysIdtable sysIdtable) {
        String fieldName = sysIdtable.getFieldName();
        String tableName = sysIdtable.getTableName();
        sysIdtable.setTableName(tableName.toUpperCase());
        SysIdtable idtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)idtable) && !idtable.getId().equals(sysIdtable.getId())) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_SAVE_FAIL.getMessage()));
        }
        if (!this.updateById((BaseEntity)sysIdtable)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_UPDATE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_UPDATE_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public ApiResponse deleteByLongIds(List<Long> ids) {
        if (ToolUtil.isEmpty(ids)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DELETE_PARAM_EMPTY.getMessage()));
        }
        ArrayList<Long> ids2 = new ArrayList<Long>();
        for (int i = 0; i < ids.size(); ++i) {
            ids2.add(i, ids.get(i));
        }
        if (!this.removeByIds(ids2)) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_DELETE_FAIL.getMessage()));
        }
        this.sysIdtableInfoMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysIdtableInfo::getIdtableId, ids2));
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_DELETE_SUCCESS.getMessage()));
    }

    public ApiResponse deleteByIds(List<String> ids) {
        List<Long> longIds = ids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return this.deleteByLongIds(longIds);
    }

    @HussarTransactional
    public synchronized String getCurrentCode(String fieldName, String tableName) {
        String ruleCode = tableName + ":" + fieldName;
        CodePlusDto codePlusDto = new CodePlusDto();
        codePlusDto.setRuleCode(ruleCode);
        String currentCodeNew = this.sysCodeRuleService.getCurrentCode(codePlusDto);
        if (!StringUtils.isEmpty((Object)currentCodeNew)) {
            return currentCodeNew;
        }
        SysIdtable sysIdtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)sysIdtable)) {
            String isPrefix = sysIdtable.getIsPrefix();
            String idPrefix = sysIdtable.getIdPrefix();
            String isSuffix = sysIdtable.getIsSuffix();
            String idSuffix = sysIdtable.getIdSuffix();
            StringBuilder currentCode = new StringBuilder();
            if ("1".equals(isPrefix)) {
                String lastDate;
                if (idPrefix.indexOf("[") == 0 && idPrefix.indexOf("]") == idPrefix.length() - 1) {
                    idPrefix = idPrefix.substring(1, idPrefix.length());
                    idPrefix = idPrefix.substring(0, idPrefix.length() - 1);
                    SimpleDateFormat sdf = new SimpleDateFormat(idPrefix);
                    idPrefix = sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                }
                if (!ToolUtil.equals((Object)(lastDate = sysIdtable.getLastDate()), (Object)idPrefix)) {
                    sysIdtable.setLastDate(idPrefix);
                    super.updateById((BaseEntity)sysIdtable);
                    sysIdtable.setIdValue(Integer.valueOf(0));
                }
                currentCode.append(idPrefix);
            }
            Integer result = sysIdtable.getIdValue() + sysIdtable.getCacheSize();
            Integer length = sysIdtable.getIdLength();
            String idLength = length.toString();
            String resultCode = result.toString();
            int zeroLength = Integer.valueOf(idLength) - resultCode.length();
            if (zeroLength < 0) {
                throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_CODE_EXCEEDS_SPECIFIED_LENGTH.getMessage()));
            }
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(result);
            if ("1".equals(isSuffix)) {
                currentCode.append(idSuffix);
            }
            sysIdtable.setIdValue(result);
            this.sysIdtableMapper.updateById(sysIdtable);
            return currentCode.toString();
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_NO_ENCODING_RULE_FOUND.getMessage()));
    }

    @HussarTransactional
    public synchronized String getCurrentCodeEy(String fieldName, String tableName) {
        SysIdtable sysIdtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)sysIdtable)) {
            String isPrefix = sysIdtable.getIsPrefix();
            String idPrefix = sysIdtable.getIdPrefix();
            String isSuffix = sysIdtable.getIsSuffix();
            String idSuffix = sysIdtable.getIdSuffix();
            StringBuilder currentCode = new StringBuilder();
            if ("1".equals(isPrefix)) {
                String lastDate;
                if (idPrefix.indexOf("[") == 0 && idPrefix.indexOf("]") == idPrefix.length() - 1) {
                    idPrefix = idPrefix.substring(1, idPrefix.length());
                    idPrefix = idPrefix.substring(0, idPrefix.length() - 1);
                    SimpleDateFormat sdf = new SimpleDateFormat(idPrefix);
                    idPrefix = sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                }
                if (!ToolUtil.equals((Object)(lastDate = sysIdtable.getLastDate()), (Object)idPrefix)) {
                    sysIdtable.setLastDate(idPrefix);
                    super.updateById((BaseEntity)sysIdtable);
                    sysIdtable.setIdValue(Integer.valueOf(0));
                }
                currentCode.append(idPrefix);
            }
            Integer result = sysIdtable.getIdValue() + sysIdtable.getCacheSize();
            Integer length = sysIdtable.getIdLength();
            String idLength = length.toString();
            String resultCode = result.toString();
            int zeroLength = Integer.valueOf(idLength) - resultCode.length();
            if (zeroLength < 0) {
                throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
            }
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(result);
            if ("1".equals(isSuffix)) {
                currentCode.append(idSuffix);
            }
            sysIdtable.setIdValue(result);
            this.sysIdtableMapper.updateById(sysIdtable);
            return currentCode.toString();
        }
        throw new BaseException("\u672a\u627e\u5230\u7f16\u7801\u89c4\u5219");
    }

    @HussarTransactional
    public synchronized String getCurrentCode(String fieldName, String tableName, String parentNumber) {
        String ruleCode = tableName + ":" + fieldName;
        CodePlusDto codePlusDto = new CodePlusDto();
        codePlusDto.setLevel("1");
        codePlusDto.setParentNumber(parentNumber);
        codePlusDto.setRuleCode(ruleCode);
        String currentCodeNew = this.sysCodeRuleService.getCurrentCode(codePlusDto);
        if (!StringUtils.isEmpty((Object)currentCodeNew)) {
            return currentCodeNew;
        }
        SysIdtable sysIdtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)sysIdtable)) {
            if (ToolUtil.equals((Object)sysIdtable.getIsLevel(), (Object)"0")) {
                throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_ENCODING_RULES_ARE_NOT_HIERARCHICAL_CODES.getMessage()));
            }
            List<SysIdtableInfo> list = this.sysIdtableMapper.getIdTableByParentNumber(fieldName, tableName, parentNumber);
            if (list.size() == 0) {
                SysIdtableInfo sysIdtableInfo = new SysIdtableInfo();
                sysIdtableInfo.setId(null);
                sysIdtableInfo.setIdtableId(sysIdtable.getId());
                sysIdtableInfo.setIdValue("1");
                sysIdtableInfo.setParentNumber(parentNumber);
                this.sysIdtableInfoMapper.insert(sysIdtableInfo);
                Integer length = sysIdtable.getIdLength();
                String idLength = length.toString();
                int zeroLength = Integer.valueOf(idLength) - sysIdtableInfo.getIdValue().length();
                StringBuffer currentCode = new StringBuffer();
                if (ToolUtil.isNotEmpty((Object)parentNumber)) {
                    currentCode.append(parentNumber);
                }
                for (int i = 0; i < zeroLength; ++i) {
                    currentCode.append("0");
                }
                if (zeroLength < 0) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_CODE_EXCEEDS_SPECIFIED_LENGTH.getMessage()));
                }
                currentCode.append(sysIdtableInfo.getIdValue());
                return currentCode.toString();
            }
            int result = Integer.parseInt(list.get(0).getIdValue()) + sysIdtable.getCacheSize();
            Integer length = sysIdtable.getIdLength();
            String idLength = length.toString();
            String resultCode = String.valueOf(result);
            int zeroLength = Integer.valueOf(idLength) - resultCode.length();
            StringBuilder currentCode = new StringBuilder();
            if (ToolUtil.isNotEmpty((Object)parentNumber)) {
                currentCode.append(parentNumber);
            }
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            if (zeroLength < 0) {
                throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_CODE_EXCEEDS_SPECIFIED_LENGTH.getMessage()));
            }
            currentCode.append(result);
            SysIdtableInfo sysIdtableInfo = new SysIdtableInfo();
            sysIdtableInfo.setId(list.get(0).getId());
            sysIdtableInfo.setIdValue(resultCode);
            this.sysIdtableInfoMapper.updateById(sysIdtableInfo);
            return currentCode.toString();
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_NO_ENCODING_RULE_FOUND.getMessage()));
    }

    @HussarTransactional
    public synchronized String getCurrentCodeEy(String fieldName, String tableName, String parentNumber) {
        SysIdtable sysIdtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)sysIdtable)) {
            if (ToolUtil.equals((Object)sysIdtable.getIsLevel(), (Object)"0")) {
                throw new BaseException("\u7f16\u7801\u89c4\u5219\u4e0d\u662f\u5c42\u7ea7\u7801");
            }
            List<SysIdtableInfo> list = this.sysIdtableMapper.getIdTableByParentNumber(fieldName, tableName, parentNumber);
            if (list.size() == 0) {
                SysIdtableInfo sysIdtableInfo = new SysIdtableInfo();
                sysIdtableInfo.setId(null);
                sysIdtableInfo.setIdtableId(sysIdtable.getId());
                sysIdtableInfo.setIdValue("1");
                sysIdtableInfo.setParentNumber(parentNumber);
                this.sysIdtableInfoMapper.insert(sysIdtableInfo);
                Integer length = sysIdtable.getIdLength();
                String idLength = length.toString();
                int zeroLength = Integer.valueOf(idLength) - sysIdtableInfo.getIdValue().length();
                StringBuffer currentCode = new StringBuffer();
                if (ToolUtil.isNotEmpty((Object)parentNumber)) {
                    currentCode.append(parentNumber);
                }
                for (int i = 0; i < zeroLength; ++i) {
                    currentCode.append("0");
                }
                if (zeroLength < 0) {
                    throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
                }
                currentCode.append(sysIdtableInfo.getIdValue());
                return currentCode.toString();
            }
            int result = Integer.parseInt(list.get(0).getIdValue()) + sysIdtable.getCacheSize();
            Integer length = sysIdtable.getIdLength();
            String idLength = length.toString();
            String resultCode = String.valueOf(result);
            int zeroLength = Integer.valueOf(idLength) - resultCode.length();
            StringBuilder currentCode = new StringBuilder();
            if (ToolUtil.isNotEmpty((Object)parentNumber)) {
                currentCode.append(parentNumber);
            }
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            if (zeroLength < 0) {
                throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
            }
            currentCode.append(result);
            SysIdtableInfo sysIdtableInfo = new SysIdtableInfo();
            sysIdtableInfo.setId(list.get(0).getId());
            sysIdtableInfo.setIdValue(resultCode);
            this.sysIdtableInfoMapper.updateById(sysIdtableInfo);
            return currentCode.toString();
        }
        throw new BaseException("\u672a\u627e\u5230\u7f16\u7801\u89c4\u5219");
    }

    public SysIdtable getIdtableByQuery(String fieldName, String tableName) {
        return this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
    }

    public void exportData(List<String> idList, HttpServletResponse response) {
        List cdids = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List idTable = this.sysIdtableMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysIdtable::getId, cdids));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("idTable", idTable);
        data.put("export_type", "idTable");
        byte[] serializeData = new byte[]{};
        try {
            serializeData = SerializeUtils.serialize(data);
        }
        catch (Exception e) {
            this.logger.error("\u5e8f\u5217\u5316\u51fa\u9519", (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_SERIALIZATION_ERROR.getMessage()));
        }
        String fileName = "idtable_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    public JSONObject importIdTableData(byte[] content) {
        Map data;
        JSONObject result = new JSONObject();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            this.logger.error("\u53cd\u5e8f\u5217\u5316\u6570\u636e\u51fa\u9519", (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_IMPORT_FAILS_NOT_PLATFORM_DATA.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.IDTABLE_EXCEPTION_IMPORT_FAILS_NOT_PLATFORM_DATA.getMessage()));
        }
        String export_type = (String)data.get("export_type");
        if (!"idTable".equals(export_type)) {
            result.put("success", (Object)"false");
            result.put("importType", (Object)export_type);
            result.put("trueType", (Object)"idTable");
            return result;
        }
        List idtable = (List)data.get("idTable");
        Map<String, Integer> count = this.insertOrUpdateList(idtable);
        result.put("success", (Object)"true");
        result.put("insertCount", (Object)count.get("insert"));
        result.put("updateCount", (Object)count.get("update"));
        return result;
    }

    public Map<String, Integer> insertOrUpdateList(List<SysIdtable> idTableList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(idTableList)) {
            throw new IllegalArgumentException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_ENTITY_LIST_EMPTY.getMessage()));
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = idTableList.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                if (super.updateById((BaseEntity)idTableList.get(i))) {
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    super.save((BaseEntity)idTableList.get(i));
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_INSERT_OR_UPDATE_ERROR.getMessage()), e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }
}

