/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.calendar.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.calendar.dao.SysCalendarMapper;
import com.jxdinfo.hussar.general.calendar.model.SysCalendar;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarService;
import com.jxdinfo.hussar.general.enums.GeneralServicesTipsEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysCalendarServiceImpl
extends HussarServiceImpl<SysCalendarMapper, SysCalendar>
implements ISysCalendarService {
    @Resource
    private SysCalendarMapper sysCalendarMapper;

    public List<SysCalendar> getEventsList() {
        return this.sysCalendarMapper.getEventsList();
    }

    public List<SysCalendar> queryEventsBetweenDate(Date startTime, Date endTime) {
        return this.sysCalendarMapper.getEventsBetweenDate(startTime, endTime);
    }

    @HussarTransactional
    public ApiResponse saveEvent(SysCalendar sysCalendar) {
        List<SysCalendar> calendarList = this.queryEventsBetweenDate(Date.from(sysCalendar.getStartTime().atZone(ZoneId.systemDefault()).toInstant()), Date.from(sysCalendar.getEndTime().atZone(ZoneId.systemDefault()).toInstant()));
        if (ToolUtil.isNotEmpty(calendarList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.EVENT_ANERDY_EXISTS.getMessage()));
        }
        List<Date> list = this.getBetweenDates(Date.from(sysCalendar.getStartTime().atZone(ZoneId.systemDefault()).toInstant()), Date.from(sysCalendar.getEndTime().atZone(ZoneId.systemDefault()).toInstant()));
        if (list.size() > 31) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.TIME_RANGE_EXCEED_ONE_MONTH.getMessage()));
        }
        ArrayList<SysCalendar> sysCalendarList = new ArrayList<SysCalendar>();
        for (Date start : list) {
            SysCalendar cal = new SysCalendar();
            cal.setTitle(sysCalendar.getTitle());
            cal.setClassName(sysCalendar.getClassName());
            cal.setRemark(sysCalendar.getRemark());
            cal.setStartTime(start.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            sysCalendarList.add(cal);
        }
        if (ToolUtil.isEmpty(sysCalendarList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_ADD_FAIL.getMessage()));
        }
        if (!this.saveBatch(sysCalendarList, sysCalendarList.size())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_ADD_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_ADD_SUCCESS.getMessage()));
    }

    public ApiResponse saveOneEvent(SysCalendar sysCalendar) {
        if (this.checkHaveEventForAddOne(sysCalendar)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.EVENT_ANERDY_EXISTS.getMessage()));
        }
        if (!this.save((BaseEntity)sysCalendar)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_ADD_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_ADD_SUCCESS.getMessage()));
    }

    public boolean checkHaveEventForAddOne(SysCalendar sysCalendar) {
        boolean flag = false;
        QueryWrapper sysCalendarQueryWrapper = new QueryWrapper();
        List sysCalendarList = this.list((Wrapper)sysCalendarQueryWrapper);
        List SysCalendarForOne = sysCalendarList.stream().filter(o -> o.getStartTime().isEqual(sysCalendar.getStartTime()) && o.getEndTime() == null).collect(Collectors.toList());
        List SysCalendarForList = sysCalendarList.stream().filter(o -> ToolUtil.isNotEmpty((Object)o.getEndTime())).collect(Collectors.toList());
        SysCalendarForList = SysCalendarForList.stream().filter(o -> o.getStartTime().isBefore(sysCalendar.getStartTime()) && o.getEndTime().isAfter(sysCalendar.getStartTime()) || o.getStartTime().isEqual(sysCalendar.getStartTime()) || o.getEndTime().isEqual(sysCalendar.getStartTime())).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(SysCalendarForOne) || ToolUtil.isNotEmpty(SysCalendarForList)) {
            flag = true;
        }
        return flag;
    }

    public ApiResponse<SysCalendar> updateEvent(SysCalendar sysCalendar) {
        if (!this.updateById((BaseEntity)sysCalendar)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_UPDATE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_UPDATE_SUCCESS.getMessage()));
    }

    public ApiResponse<SysCalendar> queryOneEvent(Date start) {
        SysCalendar sysCalendar = (SysCalendar)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysCalendar::getStartTime, (Object)start));
        return ApiResponse.success((Object)sysCalendar);
    }

    public ApiResponse deleteEvent(SysCalendar sysCalendar) {
        List sysCalendarList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(SysCalendar::getStartTime, (Object)sysCalendar.getStartTime())).le(SysCalendar::getStartTime, (Object)sysCalendar.getEndTime())).in(SysCalendar::getClassName, new Object[]{sysCalendar.getClassName()}));
        if (sysCalendarList.size() == 0) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.EVENT_NOT_FOUND_IN_THE_MONTH.getMessage()));
        }
        boolean flag = this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(SysCalendar::getStartTime, (Object)sysCalendar.getStartTime())).le(SysCalendar::getStartTime, (Object)sysCalendar.getEndTime())).in(SysCalendar::getClassName, new Object[]{sysCalendar.getClassName()}));
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_DELETE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_DELETE_SUCCESS.getMessage()));
    }

    public ApiResponse deleteOneEvent(SysCalendar sysCalendar) {
        if (!this.removeById(sysCalendar.getId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_DELETE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_DELETE_SUCCESS.getMessage()));
    }

    private List<Date> getBetweenDates(Date startDate, Date endDate) {
        Date newStartDate = startDate;
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(newStartDate);
        while (newStartDate.getTime() <= endDate.getTime()) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
            newStartDate = tempStart.getTime();
        }
        return result;
    }
}

