/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.validate.HussarBaseExcelValidateHelper;
import com.jxdinfo.hussar.general.dict.constant.DictConstant;
import com.jxdinfo.hussar.general.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.general.dict.dto.DicDto;
import com.jxdinfo.hussar.general.dict.dto.DicSingleDto;
import com.jxdinfo.hussar.general.dict.migration.DictMigrationPlugin;
import com.jxdinfo.hussar.general.dict.model.DicExcelCheckResult;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.model.DictExcel;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.dict.vo.DictMigrationDumpVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.general.dict.service.impl.SysDicServiceImpl")
public class SysDicServiceImpl
implements ISysDicService,
IHussarBaseCustomExcelService<DictExcel> {
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private SysDicSingleMapper sysDicSingleMapper;
    @Resource
    private DictMigrationPlugin dictMigrationPlugin;
    @Resource
    private ISysDicTypeService dicTypeService;
    private String pseudoRootSys = "sys";
    private String pseudoRootBiz = "biz";
    private String pseudoRootDic = "dict";
    private String flagOfExecuteType = "haveType";

    public ApiResponse saveDicGroup(DicGroup dicGroup) {
        Long groupParentId = dicGroup.getParentId();
        String groupName = dicGroup.getGroupDescription();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{groupParentId, groupName})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u65b0\u589e");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        if (this.checkDicGroupDuplicated(groupParentId, groupName)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u5206\u7ec4\u5df2\u5b58\u5728\uff01\uff09");
        }
        DicGroup lastOne = (DicGroup)this.dicGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicGroup::getParentId, (Object)groupParentId)).orderByDesc(DicGroup::getSort), false);
        dicGroup.setRangeType(this.pseudoRootDic);
        if (ToolUtil.isEmpty((Object)lastOne)) {
            dicGroup.setSort(Integer.valueOf(3));
        } else {
            dicGroup.setSort(Integer.valueOf(lastOne.getSort() + 1));
        }
        if (this.dicGroupService.save((Object)dicGroup)) {
            return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
        }
        return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25\uff01");
    }

    public ApiResponse updateDictGroup(DicGroup dicGroup) {
        Long groupId = dicGroup.getId();
        String groupName = dicGroup.getGroupDescription();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{groupId, groupName})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u4fee\u6539");
        }
        if (this.checkDicGroupDuplicated(groupId, groupName)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u5206\u7ec4\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (!this.dicGroupService.saveOrUpdate((Object)dicGroup)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<List<JSTreeModel>> queryExportTreeData(Long dictGroupId) {
        ArrayList<Object> result = new ArrayList<Object>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setText("\u6570\u636e\u5b57\u5178");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("root");
        root.setImgUrl("tree-com");
        result.add(root);
        ArrayList<JSTreeModel> mapList = new ArrayList<JSTreeModel>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)dictGroupId)) {
            queryWrapper.eq(DicGroup::getId, (Object)dictGroupId);
        }
        queryWrapper.orderByAsc(DicGroup::getSort);
        List groups = this.dicGroupService.list((Wrapper)queryWrapper);
        if (groups != null && groups.size() > 0) {
            for (DicGroup group : groups) {
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(group.getId());
                tempObject.setParent(group.getParentId());
                tempObject.setText(group.getGroupDescription());
                tempObject.setType("zidian");
                tempObject.setImgUrl("tree-folder");
                tempObject.setSeq(group.getSort().toString());
                tempObject.setRangeType(group.getRangeType());
                mapList.add(tempObject);
            }
        }
        result.addAll(mapList);
        result.addAll(this.dicTypeService.getDicExportTreeDataByGroupId(dictGroupId));
        return ApiResponse.success((Object)TreeModelUtils.merge(result));
    }

    public IPage<DicSingle> queryListSingle(Page page, Long dictTypeId) {
        if (ToolUtil.isEmpty((Object)dictTypeId)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u67e5\u8be2");
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(DicSingle::getTypeId, (Object)dictTypeId)).orderByAsc(DicSingle::getSort);
        IPage dicSingleIPage = this.sysDicSingleMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return dicSingleIPage;
    }

    public IPage<DicSingle> queryListSingle(Page page, String dictTypeId) {
        return this.queryListSingle(page, Long.parseLong(dictTypeId));
    }

    @HussarTransactional
    public ApiResponse updateMoveNode(DicSingleDto singleDto) {
        boolean isUp;
        Long dictId = singleDto.getId();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{dictId, isUp = singleDto.getIsUp()})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u6392\u5e8f");
        }
        this.dicSingleService.evictTypeCacheBySingleId(dictId);
        DicSingle thisDic = (DicSingle)this.dicSingleService.getById((Serializable)dictId);
        LambdaQueryWrapper ew = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)thisDic.getTypeId());
        if (null == thisDic.getParentId()) {
            ew.isNull(DicSingle::getParentId);
        } else {
            ew.eq(DicSingle::getParentId, (Object)thisDic.getParentId());
        }
        if (isUp) {
            ((LambdaQueryWrapper)ew.lt(DicSingle::getSort, (Object)thisDic.getSort())).orderByDesc(DicSingle::getSort);
        } else {
            ((LambdaQueryWrapper)ew.gt(DicSingle::getSort, (Object)thisDic.getSort())).orderByAsc(DicSingle::getSort);
        }
        DicSingle thatDic = (DicSingle)this.dicSingleService.getOne((Wrapper)ew, false);
        if (thatDic == null) {
            throw new BaseException("\u6b64\u6761\u76ee\u5df2\u7ecf\u4e3a" + (isUp ? "\u7b2c\u4e00\u6761\uff01" : "\u6700\u540e\u4e00\u6761\uff01"));
        }
        int temp = thisDic.getSort();
        thisDic.setSort(thatDic.getSort());
        thatDic.setSort(Integer.valueOf(temp));
        if (!this.dicSingleService.updateById((Object)thisDic) || !this.dicSingleService.updateById((Object)thatDic)) {
            throw new BaseException("\u4fdd\u5b58\u5b57\u5178\u987a\u5e8f\u5931\u8d25\uff01");
        }
        this.dicTypeService.evictTypeCacheById(thisDic.getTypeId());
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    public IPage<DicSingle> queryListSingle(Page page, String dictTypeId, String parentId) {
        if (ToolUtil.isEmpty((Object)dictTypeId)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u67e5\u8be2");
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            queryWrapper.eq(DicSingle::getParentId, (Object)Long.parseLong(parentId));
        } else {
            queryWrapper.isNull(DicSingle::getParentId);
        }
        Long tmpId = 0L;
        if ("child".equalsIgnoreCase(dictTypeId)) {
            tmpId = this.getTypeId(Long.parseLong(parentId));
            ((LambdaQueryWrapper)queryWrapper.eq(DicSingle::getTypeId, (Object)tmpId)).orderByAsc(DicSingle::getSort);
        } else {
            ((LambdaQueryWrapper)queryWrapper.eq(DicSingle::getTypeId, (Object)Long.parseLong(dictTypeId))).orderByAsc(DicSingle::getSort);
        }
        IPage dicSingleIPage = this.sysDicSingleMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        DicType typeEntity = null;
        typeEntity = "child".equalsIgnoreCase(dictTypeId) ? (DicType)this.dicTypeService.getById((Serializable)tmpId) : (DicType)this.dicTypeService.getById((Serializable)Long.valueOf(Long.parseLong(dictTypeId)));
        if (CollectionUtils.isNotEmpty((Collection)dicSingleIPage.getRecords())) {
            for (DicSingle ds : dicSingleIPage.getRecords()) {
                ds.setTypeName(typeEntity.getTypeName());
                ds.setTypeDesc(typeEntity.getTypeDescription());
            }
        }
        return dicSingleIPage;
    }

    public List<DictMigrationDumpVo> getDictOutSys() {
        ArrayList<DictMigrationDumpVo> dictMigrationDumpVos = new ArrayList<DictMigrationDumpVo>();
        DictMigrationDumpVo root = new DictMigrationDumpVo();
        root.setId(Constants.ROOT_NODE_ID);
        root.setLabel("\u6570\u636e\u5b57\u5178");
        root.setParentId(Constants.ROOT_NODE_PARENT);
        root.setType(0);
        root.setHasChildren(Boolean.valueOf(false));
        root.setIcon("tree-com");
        dictMigrationDumpVos.add(root);
        List dicGroups = this.dicGroupService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(DicGroup::getRangeType, (Object)"sys")).orderByAsc(DicGroup::getSort));
        if (HussarUtils.isEmpty((Object)dicGroups)) {
            return dictMigrationDumpVos;
        }
        for (DicGroup dicGroup : dicGroups) {
            DictMigrationDumpVo dictVo = new DictMigrationDumpVo();
            dictVo.setId(dicGroup.getId());
            dictVo.setParentId(dicGroup.getParentId());
            dictVo.setType(1);
            dictVo.setLabel(dicGroup.getGroupDescription());
            dictVo.setIcon("tree-folder");
            dictMigrationDumpVos.add(dictVo);
        }
        List dicTypes = this.dicTypeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(DicType::getRangeType, (Object)"sys")).orderByAsc(DicType::getSort));
        ArrayList<Long> typeIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)dicTypes)) {
            for (Object dicType : dicTypes) {
                DictMigrationDumpVo dictVo = new DictMigrationDumpVo();
                dictVo.setId(dicType.getId());
                dictVo.setType(2);
                dictVo.setParentId(dicType.getParentId());
                dictVo.setLabel(dicType.getTypeDescription());
                dictVo.setValue(dicType.getTypeName());
                dictVo.setIcon("zidian");
                typeIds.add(dicType.getId());
                dictMigrationDumpVos.add(dictVo);
            }
        }
        List dicSingles = new ArrayList();
        if (HussarUtils.isNotEmpty(typeIds)) {
            dicSingles = this.dicSingleService.getDicSingleByTypeIds(typeIds, 2);
        }
        if (HussarUtils.isNotEmpty(dicSingles)) {
            for (DicSingle dicSingle : dicSingles) {
                DictMigrationDumpVo dictVo = new DictMigrationDumpVo();
                dictVo.setId(dicSingle.getId());
                dictVo.setParentId(HussarUtils.isEmpty((Object)dicSingle.getParentId()) ? dicSingle.getTypeId() : dicSingle.getParentId());
                dictVo.setType(3);
                dictVo.setValue(dicSingle.getValue());
                dictVo.setLabel(dicSingle.getLabel());
                dictVo.setIcon("dict");
                dictMigrationDumpVos.add(dictVo);
            }
        }
        List dictTree = HussarTreeParser.getTreeList(dictMigrationDumpVos);
        this.fillDictHasChildren((DictMigrationDumpVo)dictTree.get(0));
        return dictTree;
    }

    public void fillDictHasChildren(DictMigrationDumpVo dictTree) {
        if (HussarUtils.isNotEmpty((Object)dictTree)) {
            List children = dictTree.getChildren();
            if (HussarUtils.isNotEmpty((Object)children)) {
                dictTree.setHasChildren(Boolean.valueOf(true));
                for (DictMigrationDumpVo dictDumpVo : children) {
                    this.fillDictHasChildren(dictDumpVo);
                }
            } else {
                dictTree.setHasChildren(Boolean.valueOf(false));
            }
        }
    }

    @HussarTransactional
    public ApiResponse addDictType(Long parentId, String dictName, String dictTypeCode, String dictValues) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{parentId, dictName, dictTypeCode})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u65b0\u589e");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        if (this.checkDicTypeDuplicated(parentId, dictName, dictTypeCode).equals("TypeNameRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u6807\u8bc6\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (this.checkDicTypeDuplicated(parentId, dictName, dictTypeCode).equals("TypeDescriptionRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        }
        DicType lastOne = (DicType)this.dicTypeService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicType::getParentId, (Object)parentId)).orderByDesc(DicType::getSort), false);
        DicType dict = new DicType();
        dict.setParentId(parentId);
        dict.setTypeName(dictTypeCode);
        dict.setTypeDescription(dictName);
        DicGroup parentGroup = (DicGroup)this.dicGroupService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicGroup::getId, (Object)parentId));
        if (ToolUtil.isNotEmpty((Object)parentGroup)) {
            String parentRangeType = parentGroup.getRangeType();
            if (!this.pseudoRootBiz.equals(parentRangeType) && !this.pseudoRootSys.equals(parentRangeType)) {
                dict.setRangeType(String.valueOf(parentId));
            } else {
                dict.setRangeType(parentRangeType);
            }
        } else {
            dict.setRangeType(String.valueOf(parentId));
        }
        if (ToolUtil.isEmpty((Object)lastOne)) {
            dict.setSort(Integer.valueOf(1));
        } else {
            dict.setSort(Integer.valueOf(lastOne.getSort() + 1));
        }
        if (this.dicTypeService.save((Object)dict)) {
            return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
        }
        throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
    }

    private boolean addDictTypeChildren(Long typeId, String dictValues) {
        if (ToolUtil.isNotEmpty((Object)dictValues)) {
            JSONArray jsonArray = JSON.parseArray((String)dictValues);
            ArrayList<DicSingle> addList = new ArrayList<DicSingle>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Map map = (Map)JSON.parse((String)jsonArray.getString(i));
                String value = (String)map.get("num");
                String label = (String)map.get("name");
                if (ToolUtil.isOneEmpty((Object[])new Object[]{value, label})) continue;
                DicSingle itemDict = new DicSingle();
                itemDict.setValue(value);
                itemDict.setLabel(label);
                itemDict.setTypeId(typeId);
                itemDict.setSort(Integer.valueOf(i + 1));
                addList.add(itemDict);
            }
            if (ToolUtil.isNotEmpty(addList)) {
                return this.dicSingleService.saveBatch(addList);
            }
        }
        return false;
    }

    public void editDict(Long dictTypeId, String dictName, String dictTypeCode, String dictValues) {
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        this.checkDicTypeRange(dictTypeId);
        String checkResult = this.checkDicTypeDuplicated(dictTypeId, dictName, dictTypeCode);
        if (checkResult.equals("TypeNameRepeat")) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u6807\u8bc6\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (checkResult.equals("TypeDescriptionRepeat")) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        }
        DicSingle finder = new DicSingle();
        finder.setTypeId(dictTypeId);
        this.dicSingleService.remove((Wrapper)new QueryWrapper((Object)finder));
        this.addDictTypeChildren(dictTypeId, dictValues);
        DicType type = (DicType)this.dicTypeService.getById((Serializable)dictTypeId);
        type.setTypeName(dictTypeCode);
        type.setTypeDescription(dictName);
        this.dicTypeService.updateById((Object)type);
    }

    @HussarTransactional
    public ApiResponse updateNewDict(DicDto dicDto) {
        String info = dicDto.getInfo();
        String dictValues = dicDto.getDictValues();
        String delIdString = dicDto.getDelIdString();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{dicDto.getDictId(), dicDto.getDictName(), dicDto.getDictTypeCode()})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u4fee\u6539");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        Long dictId = dicDto.getDictId();
        String dictName = dicDto.getDictName();
        String dictTypeCode = dicDto.getDictTypeCode();
        String flag = dicDto.getFlag();
        List list = (List)JSON.parse((String)delIdString);
        if (ToolUtil.isNotEmpty((Object)list)) {
            this.dicSingleService.removeByIds((Collection)list);
        }
        if (this.flagOfExecuteType.equals(flag)) {
            DicType dicType = new DicType();
            dicType.setTypeName(dictTypeCode);
            dicType.setTypeDescription(dictName);
            DicType type = (DicType)this.dicTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicType::getId, (Object)dictId), false);
            Long id = type.getId();
            String checkResult = this.checkDicTypeDuplicated(id, dictName, dictTypeCode);
            if (checkResult.equals("TypeNameRepeat")) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u6807\u8bc6\u5df2\u5b58\u5728\uff01\uff09");
            }
            if (checkResult.equals("TypeDescriptionRepeat")) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
            }
            this.dicTypeService.update((Object)dicType, (Wrapper)new LambdaQueryWrapper().eq(DicType::getId, (Object)dictId));
        } else {
            DicSingle dicSingle = new DicSingle();
            dicSingle.setValue(dictTypeCode);
            dicSingle.setLabel(dictName);
            DicSingle single = (DicSingle)this.dicSingleService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getId, (Object)dictId), false);
            Long typeId = single.getTypeId();
            Long parentId = single.getParentId();
            if (this.checkDicSingleDuplicated(dictId, typeId, dictName, dictTypeCode, parentId).equals("LabelRepeat")) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u5b57\u6bb5\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
            }
            if (this.checkDicSingleDuplicated(dictId, typeId, dictName, dictTypeCode, parentId).equals("ValueRepeat")) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u5f53\u524d\u7c7b\u578b\u4e0b\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\uff01\uff09");
            }
            this.dicSingleService.update((Object)dicSingle, (Wrapper)new LambdaQueryWrapper().eq(DicSingle::getId, (Object)dictId));
        }
        JSONArray jsonArray = JSON.parseArray((String)dictValues);
        ArrayList<DicSingle> addList = new ArrayList<DicSingle>();
        ArrayList<DicSingle> updateList = new ArrayList<DicSingle>();
        if (ToolUtil.isNotEmpty((Object)jsonArray)) {
            int arr = 1;
            DicSingle lastOne = new DicSingle();
            lastOne = this.flagOfExecuteType.equals(flag) ? (DicSingle)this.dicSingleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)dictId)).orderByDesc((Object)"SORT"), false) : (DicSingle)this.dicSingleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)dictId)).orderByDesc((Object)"SORT"), false);
            if (ToolUtil.isNotEmpty((Object)lastOne)) {
                arr = lastOne.getSort() + 1;
            }
            for (int i = 0; i < jsonArray.size(); ++i) {
                Map map = (Map)JSON.parse((String)jsonArray.getString(i));
                DicSingle dicSingle = new DicSingle();
                dicSingle.setValue((String)map.get("num"));
                dicSingle.setLabel((String)map.get("name"));
                dicSingle.setTypeId(dictId);
                if (!this.flagOfExecuteType.equals(flag)) {
                    dicSingle.setParentId(dictId);
                }
                if (ToolUtil.isEmpty(map.get("id"))) {
                    dicSingle.setSort(Integer.valueOf(arr++));
                }
                if (ToolUtil.isEmpty(map.get("id"))) {
                    addList.add(dicSingle);
                    continue;
                }
                dicSingle.setId(Long.valueOf((String)map.get("id")));
                updateList.add(dicSingle);
            }
            if (ToolUtil.isNotEmpty(addList)) {
                this.dicSingleService.saveBatch(addList);
            }
            if (ToolUtil.isNotEmpty(updateList)) {
                this.dicSingleService.updateBatchById(updateList);
            }
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public List<Map<String, Object>> dicTypeTreeData() {
        List dicChilds;
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        List types = this.dicTypeService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"SORT"));
        if (types != null && types.size() > 0) {
            for (DicType type : types) {
                String rangeType = type.getRangeType();
                String typeName = type.getTypeName();
                HashMap<String, Object> tempObject = new HashMap<String, Object>(10);
                tempObject.put("id", type.getId());
                tempObject.put("parent", type.getParentId());
                tempObject.put("text", type.getTypeDescription());
                tempObject.put("type", "type");
                tempObject.put("rangeType", rangeType);
                tempObject.put("typeName", typeName);
                mapList.add(tempObject);
                List dics = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)type.getId())).orderByAsc((Object)"SORT"));
                if (dics == null || dics.size() <= 0) continue;
                for (DicSingle dic : dics) {
                    tempObject = new HashMap(10);
                    tempObject.put("id", dic.getId());
                    tempObject.put("parent", dic.getTypeId());
                    tempObject.put("text", dic.getLabel());
                    tempObject.put("type", "dic");
                    tempObject.put("rangeType", rangeType);
                    tempObject.put("typeName", typeName);
                    mapList.add(tempObject);
                }
            }
        }
        if ((dicChilds = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().isNotNull((Object)"PARENT_ID")).orderByAsc((Object)"SORT"))) != null && dicChilds.size() > 0) {
            for (DicSingle dicChild : dicChilds) {
                HashMap<String, Object> tempObject = new HashMap<String, Object>(10);
                tempObject.put("id", dicChild.getId());
                tempObject.put("parent", dicChild.getParentId());
                tempObject.put("text", dicChild.getLabel());
                tempObject.put("type", "dic");
                tempObject.put("rangeType", "child");
                tempObject.put("typeName", "child");
                mapList.add(tempObject);
            }
        }
        return mapList;
    }

    public List<Map<String, Object>> dicOrderTreeData(Long typeId) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        DicType pDic = (DicType)this.dicTypeService.getById((Serializable)typeId);
        if (pDic != null) {
            HashMap<String, Object> parent = new HashMap<String, Object>(10);
            parent.put("id", pDic.getId());
            parent.put("parent", Constants.ROOT_NODE_PARENT);
            parent.put("text", pDic.getTypeDescription());
            parent.put("type", "type");
            mapList.add(parent);
            DicSingle finder = new DicSingle();
            finder.setTypeId(typeId);
            List subDict = this.dicSingleService.list((Wrapper)new QueryWrapper((Object)finder).orderByAsc((Object)"SORT"));
            if (subDict != null && subDict.size() > 0) {
                for (DicSingle dic : subDict) {
                    HashMap<String, Object> tempObject = new HashMap<String, Object>(10);
                    tempObject.put("id", dic.getId());
                    tempObject.put("parent", dic.getTypeId());
                    tempObject.put("text", dic.getLabel());
                    tempObject.put("type", "dic");
                    mapList.add(tempObject);
                }
            }
        }
        return mapList;
    }

    public ApiResponse updateDicOrder(String orderInfo) {
        DicSingle dicSingle;
        if (ToolUtil.isEmpty((Object)orderInfo)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u6392\u5e8f\u5931\u8d25");
        }
        JSONArray arr = JSON.parseArray((String)orderInfo);
        List longList = arr.toJavaList(Long.class);
        Long[] orderInfoArr = longList.toArray(new Long[arr.size()]);
        DicSingle dic = null;
        ArrayList<DicSingle> listOfSingle = new ArrayList<DicSingle>();
        for (int i = 0; i < orderInfoArr.length; ++i) {
            Long id = orderInfoArr[i];
            dic = new DicSingle();
            dic.setId(id);
            dic.setSort(Integer.valueOf(i + 1));
            listOfSingle.add(dic);
        }
        if (ToolUtil.isNotEmpty(dic) && ToolUtil.isNotEmpty((Object)(dicSingle = (DicSingle)this.dicSingleService.getById((Serializable)dic.getId())))) {
            this.dicTypeService.evictTypeCacheById(dicSingle.getTypeId());
        }
        if (ToolUtil.isNotEmpty(listOfSingle)) {
            if (this.dicSingleService.updateBatchById(listOfSingle)) {
                return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
            }
            throw new BaseException("\u6392\u5e8f\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    public ApiResponse saveDicSingle(Long dictId, Long dictTypeId, String dictName, String dictValue) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{dictTypeId, dictName, dictValue})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u65b0\u589e");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        this.checkDicTypeRange(dictTypeId);
        if (this.checkDicSingleDuplicated(dictId, dictTypeId, dictName, dictValue, null).equals("LabelRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u5b57\u6bb5\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (this.checkDicSingleDuplicated(dictId, dictTypeId, dictName, dictValue, null).equals("ValueRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u5f53\u524d\u7c7b\u578b\u4e0b\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\uff01\uff09");
        }
        DicSingle dic = new DicSingle();
        DicSingle lastOne = (DicSingle)this.dicSingleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)dictTypeId)).orderByDesc(DicSingle::getSort), false);
        dic.setTypeId(dictTypeId);
        dic.setLabel(dictName);
        dic.setValue(dictValue);
        if (ToolUtil.isEmpty((Object)lastOne)) {
            dic.setSort(Integer.valueOf(1));
        } else {
            dic.setSort(Integer.valueOf(lastOne.getSort() + 1));
        }
        boolean flag = this.dicSingleService.saveOrUpdate((Object)dic);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        this.dicTypeService.evictTypeCacheById(dic.getTypeId());
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse updateDicSingle(Long dictId, Long dictTypeId, String dictName, String dictValue) {
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        DicSingle single = (DicSingle)this.dicSingleService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getId, (Object)dictId), false);
        Long parentId = null;
        if (HussarUtils.isNotEmpty((Object)single)) {
            parentId = single.getParentId();
        }
        this.checkDicTypeRange(dictTypeId);
        if (this.checkDicSingleDuplicated(dictId, dictTypeId, dictName, dictValue, parentId).equals("LabelRepeat")) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u5b57\u6bb5\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (this.checkDicSingleDuplicated(dictId, dictTypeId, dictName, dictValue, parentId).equals("ValueRepeat")) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u5f53\u524d\u5b57\u5178\u4e0b\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (ToolUtil.isEmpty((Object)dictId)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u4fee\u6539");
        }
        DicSingle dic = (DicSingle)this.dicSingleService.getById((Serializable)dictId);
        dic.setLabel(dictName);
        dic.setValue(dictValue);
        boolean flag = this.dicSingleService.saveOrUpdate((Object)dic);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        this.dicTypeService.evictTypeCacheById(dic.getTypeId());
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public void deleteType(Long id) {
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        if (id != null && this.dicTypeService.list((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)id)).size() > 0 && this.dicTypeService.removeById((Serializable)id)) {
            this.dicTypeService.evictTypeCacheById(id);
        }
        if (id != null && this.dicSingleService.list((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)id)).size() > 0) {
            this.dicSingleService.removeById((Serializable)id);
        }
    }

    @HussarTransactional
    public ApiResponse deleteCascadeDict(String[] ids) {
        if (ToolUtil.isEmpty((Object)ids)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u5220\u9664");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        ArrayList<Long> listOfGroup = new ArrayList<Long>();
        ArrayList<Long> listOfType = new ArrayList<Long>();
        ArrayList<Long> listOfSingle = new ArrayList<Long>();
        List<String> idList = Arrays.asList(ids);
        if (ToolUtil.isNotEmpty(idList)) {
            List idListL = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List dicGroupList = this.dicGroupService.list((Wrapper)new LambdaQueryWrapper().in(DicGroup::getId, idListL));
            List dicTypeList = null;
            dicTypeList = com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)dicGroupList) ? this.dicTypeService.list((Wrapper)new LambdaQueryWrapper().in(DicType::getParentId, (Collection)dicGroupList.stream().map(DicGroup::getId).collect(Collectors.toList()))) : this.dicTypeService.list((Wrapper)new LambdaQueryWrapper().in(DicType::getId, idListL));
            List dicSingleList = null;
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)dicTypeList)) {
                dicSingleList = this.dicSingleService.list((Wrapper)new LambdaQueryWrapper().in(DicSingle::getTypeId, (Collection)dicTypeList.stream().map(DicType::getId).collect(Collectors.toList())));
            } else {
                dicSingleList = this.dicSingleService.list((Wrapper)new LambdaQueryWrapper().in(DicSingle::getId, idListL));
                if (CollectionUtils.isNotEmpty((Collection)dicSingleList)) {
                    this.putDictSingleChildren(dicSingleList, idList.stream().map(Long::parseLong).collect(Collectors.toList()));
                }
            }
            if (ToolUtil.isNotEmpty((Object)dicGroupList)) {
                for (DicGroup dicGroup : dicGroupList) {
                    listOfGroup.add(dicGroup.getId());
                }
            }
            if (ToolUtil.isNotEmpty((Object)dicTypeList)) {
                for (DicType dicType : dicTypeList) {
                    listOfType.add(dicType.getId());
                    this.dicTypeService.evictTypeCacheById(dicType.getId());
                }
            }
            if (ToolUtil.isNotEmpty((Object)dicSingleList)) {
                for (DicSingle dicSingle : dicSingleList) {
                    listOfSingle.add(dicSingle.getId());
                }
            }
        }
        boolean dicGroupFlag = false;
        boolean dictTypeFlag = false;
        boolean dictSingleFlag = false;
        if (ToolUtil.isNotEmpty(listOfGroup)) {
            dicGroupFlag = this.dicGroupService.removeByIds(listOfGroup);
        }
        if (ToolUtil.isNotEmpty(listOfType)) {
            dictTypeFlag = this.dicTypeService.removeByIds(listOfType);
        }
        if (ToolUtil.isNotEmpty(listOfSingle)) {
            dictSingleFlag = this.dicSingleService.removeByIds(listOfSingle);
        }
        if (dicGroupFlag || dictTypeFlag || dictSingleFlag) {
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    private void putDictSingleChildren(List<DicSingle> dicSingleList, List<Long> idList) {
        for (Long id : idList) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getParentId, (Object)id);
            List list = this.dicSingleService.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            dicSingleList.addAll(list);
            this.putDictSingleChildren(dicSingleList, list.stream().map(DicSingle::getId).collect(Collectors.toList()));
        }
    }

    private Long getTypeId(Long typeId) {
        DicSingle lastOne = (DicSingle)this.dicSingleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getId, (Object)typeId)).orderByDesc(DicSingle::getSort), false);
        if (null == lastOne.getParentId()) {
            return lastOne.getTypeId();
        }
        return this.getTypeId(lastOne.getParentId());
    }

    public ApiResponse saveSingleChild(Long dictId, Long dictTypeId, String dictName, String dictValue) {
        DicSingle dicSingle;
        if (ToolUtil.isOneEmpty((Object[])new Object[]{dictTypeId, dictName, dictValue})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u65b0\u589e");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        Long typeId = this.getTypeId(dictTypeId);
        if (this.checkDicSingleDuplicated(dictId, typeId, dictName, dictValue, dictTypeId).equals("LabelRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u5b57\u6bb5\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (this.checkDicSingleDuplicated(dictId, typeId, dictName, dictValue, dictTypeId).equals("ValueRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u5f53\u524d\u5b57\u5178\u4e0b\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (ToolUtil.isEmpty((Object)dictId)) {
            DicSingle lastOne = (DicSingle)this.dicSingleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getParentId, (Object)dictTypeId)).orderByDesc(DicSingle::getSort), false);
            dicSingle = new DicSingle();
            dicSingle.setTypeId(typeId);
            dicSingle.setParentId(dictTypeId);
            dicSingle.setLabel(dictName);
            dicSingle.setValue(dictValue);
            if (ToolUtil.isEmpty((Object)lastOne)) {
                dicSingle.setSort(Integer.valueOf(1));
            } else {
                dicSingle.setSort(Integer.valueOf(lastOne.getSort() + 1));
            }
        } else {
            dicSingle = (DicSingle)this.dicSingleService.getById((Serializable)dictId);
            dicSingle.setLabel(dictName);
            dicSingle.setValue(dictValue);
        }
        boolean flag = this.dicSingleService.saveOrUpdate((Object)dicSingle);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        this.dicTypeService.evictTypeCacheById(dicSingle.getTypeId());
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    private void checkDicTypeRange(Long typeId) {
        DicType parent = (DicType)this.dicTypeService.getById((Serializable)typeId);
        if (!ToolUtil.isNotEmpty((Object)parent)) {
            throw new BaseException("\u7c7b\u578b\u5b57\u5178\u4e0d\u5b58\u5728");
        }
        this.checkRangeType(parent.getRangeType());
    }

    private void checkRangeType(String rangeType) {
        if (this.pseudoRootSys.equals(rangeType)) {
            throw new BaseException("\u5b57\u5178\u4e1a\u52a1\u7c7b\u578b\u4e3asys");
        }
    }

    private String checkDicTypeDuplicated(Long id, String dictName, String dictTypeCode) {
        AssertUtil.isNotNull((Object)id, (String)"\u4fee\u6539\u65f6\u5b57\u5178id\u4e0d\u80fd\u4e3a\u7a7a");
        DicGroup dicGroup = (DicGroup)this.dicGroupService.getById((Serializable)id);
        Long parentId = null;
        if (HussarUtils.isNotEmpty((Object)dicGroup)) {
            parentId = dicGroup.getParentId();
        }
        return this.checkDicTypeDuplicated(id, dictName, dictTypeCode, parentId);
    }

    private String checkDicTypeDuplicated(Long id, String dictName, String dictTypeCode, Long parentId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DicType::getTypeName, (Object)dictTypeCode);
        List resCode = this.dicTypeService.list((Wrapper)queryWrapper);
        if (resCode.size() > 1 || resCode.size() == 1 && !((DicType)resCode.get(0)).getId().equals(id)) {
            return "TypeNameRepeat";
        }
        queryWrapper.clear();
        ((LambdaQueryWrapper)queryWrapper.eq(DicType::getTypeDescription, (Object)dictName)).eq(DicType::getParentId, (Object)parentId);
        List resDescription = this.dicTypeService.list((Wrapper)queryWrapper);
        if (resDescription.size() > 1 || resDescription.size() == 1 && !((DicType)resDescription.get(0)).getId().equals(id)) {
            return "TypeDescriptionRepeat";
        }
        return "";
    }

    private String checkDicSingleDuplicated(Long dictId, Long dictTypeId, String dictName, String dictValue, Long parentId) {
        LambdaQueryWrapper finderL = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)dictTypeId)).eq(DicSingle::getLabel, (Object)dictName);
        if (HussarUtils.isNotEmpty((Object)parentId)) {
            finderL.eq(DicSingle::getParentId, (Object)parentId);
        } else {
            finderL.isNull(DicSingle::getParentId);
        }
        List resL = this.dicSingleService.list((Wrapper)finderL);
        if (resL.size() > 1 || resL.size() == 1 && !((DicSingle)resL.get(0)).getId().equals(dictId)) {
            return "LabelRepeat";
        }
        LambdaQueryWrapper finderV = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)dictTypeId)).eq(DicSingle::getValue, (Object)dictValue);
        List resV = this.dicSingleService.list((Wrapper)finderV);
        if (resV.size() > 1 || resV.size() == 1 && !HussarUtils.equals((Object)dictId, (Object)((DicSingle)resV.get(0)).getId())) {
            return "ValueRepeat";
        }
        return "";
    }

    private boolean checkDicGroupDuplicated(Long groupParentId, String groupName) {
        boolean flag = false;
        Wrapper finderL = (Wrapper)new LambdaQueryWrapper().eq(DicGroup::getGroupDescription, (Object)groupName);
        List resL = this.dicGroupService.list(finderL);
        if (resL.size() > 1 || resL.size() == 1 && !((DicGroup)resL.get(0)).getId().equals(groupParentId)) {
            flag = true;
        }
        return flag;
    }

    public List<DictExcel> handleDataBeforeImport(List<DictExcel> list, Long taskId) {
        String typeDescInMergeCell = null;
        String typeCodeInMergeCell = null;
        String typeIdInMergeCell = null;
        for (DictExcel dictExcel : list) {
            String typeDescData = dictExcel.getTypeDesc();
            String typeCodeData = dictExcel.getTypeCode();
            if (HussarUtils.isNotBlank((CharSequence)typeDescData) && HussarUtils.isNotBlank((CharSequence)typeCodeData)) {
                typeDescInMergeCell = typeDescData;
                typeCodeInMergeCell = typeCodeData;
            } else if (HussarUtils.isNotBlank((CharSequence)typeDescData) && HussarUtils.isBlank((CharSequence)typeCodeData)) {
                typeDescInMergeCell = typeDescData;
                typeCodeInMergeCell = typeCodeData;
            } else if (HussarUtils.isBlank((CharSequence)typeDescData) && HussarUtils.isNotBlank((CharSequence)typeCodeData)) {
                typeDescInMergeCell = typeDescData;
                typeCodeInMergeCell = typeCodeData;
            } else if (HussarUtils.isBlank((CharSequence)typeDescData) && HussarUtils.isBlank((CharSequence)typeCodeData)) {
                dictExcel.setTypeDesc(typeDescInMergeCell);
                dictExcel.setTypeCode(typeCodeInMergeCell);
            }
            String excelTypeId = dictExcel.getExcelTypeId();
            if (HussarUtils.isNotBlank((CharSequence)excelTypeId)) {
                typeIdInMergeCell = excelTypeId;
                continue;
            }
            dictExcel.setExcelTypeId(typeIdInMergeCell);
        }
        return list;
    }

    public ExcelCheckResult check(List<DictExcel> datas, Long taskId, List<Object> otherParams) {
        ArrayList<DictExcel> rootDataList = new ArrayList<DictExcel>(datas);
        ArrayList<DictExcel> successDataList = new ArrayList<DictExcel>();
        ArrayList<ExcelImportMsg> newDataList = new ArrayList<ExcelImportMsg>();
        ArrayList<ExcelImportMsg> updateDataList = new ArrayList<ExcelImportMsg>();
        ArrayList<ExcelImportMsg> existDataList = new ArrayList<ExcelImportMsg>();
        ArrayList<ExcelImportMsg> errorDataList = new ArrayList<ExcelImportMsg>();
        Long dictGroupId = HussarUtils.isNotEmpty(otherParams) ? (Long)otherParams.get(0) : Long.valueOf(0L);
        ArrayList<String> typeDescList = new ArrayList<String>();
        ArrayList<String> typeCodeList = new ArrayList<String>();
        ArrayList<String> typeIdList = new ArrayList<String>();
        ArrayList<String> singleIdList = new ArrayList<String>();
        DictExcel anteriorDictExcel = new DictExcel();
        boolean[] typeDescIsRepeat = new boolean[]{false, false};
        boolean[] typeIdIsRepeat = new boolean[]{false};
        boolean[] typeCodeIsRepeat = new boolean[]{true};
        ArrayList<String> singleLabelsInSameTypeList = new ArrayList<String>();
        ArrayList<String> singleValuesInSameTypeList = new ArrayList<String>();
        HashMap<String, String> singleLabelAndParentSingleLabelsMap = new HashMap<String, String>();
        List<DicType> allDictTypeInDBList = this.getAllDictTypeInDB();
        List<DicSingle> allDicSingleInDBList = this.getAllDictSingleInDB();
        DicExcelCheckResult dicExcelCheckResult = new DicExcelCheckResult();
        LinkedHashMap<String, Long> typeCodeAndIdInFirstRepeat = new LinkedHashMap<String, Long>();
        List<Integer> sortList = Arrays.asList(0, 0);
        List types = allDictTypeInDBList.stream().filter(type -> type.getParentId().equals(dictGroupId)).sorted(Comparator.comparing(DicType::getSort)).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(types)) {
            int lastSort = ((DicType)types.get(types.size() - 1)).getSort();
            sortList.set(0, lastSort);
        }
        HashMap<String, String> typeIdMap = new HashMap<String, String>();
        List<String> typeIds = datas.stream().map(DictExcel::getExcelTypeId).distinct().collect(Collectors.toList());
        for (int i = 0; i < datas.size(); ++i) {
            DictExcel dictExcel = datas.get(i);
            Map cellErrColMap = HussarBaseExcelValidateHelper.validateEntity((Object)dictExcel, (Integer)i);
            this.checkExcelForNotNull(i, dictExcel, cellErrColMap, allDictTypeInDBList);
            this.checkDicTypeDescForRepeat(i, dictExcel, cellErrColMap, typeDescList, anteriorDictExcel, typeDescIsRepeat, typeIdList);
            this.checkDicIdForRepeat(i, dictExcel, cellErrColMap, singleIdList, typeIds);
            this.checkDicTypeCodeForRepeat(i, dictExcel, cellErrColMap, typeCodeList, anteriorDictExcel, typeCodeIsRepeat, singleLabelsInSameTypeList, singleValuesInSameTypeList);
            this.checkDicSingleLabelForRepeat(i, dictExcel, cellErrColMap, singleLabelsInSameTypeList);
            this.checkDictSingleValueForRepeat(i, dictExcel, cellErrColMap, singleValuesInSameTypeList);
            this.checkExcelPrimaryKey(i, dictExcel.getExcelSingleId(), 5, cellErrColMap, "dictSingle");
            this.checkExcelPrimaryKey(i, dictExcel.getExcelTypeId(), 6, cellErrColMap, "dictType");
            if (HussarUtils.isNotEmpty(typeIdMap.get(dictExcel.getTypeCode()))) {
                if (!HussarUtils.equals(typeIdMap.get(dictExcel.getTypeCode()), (Object)dictExcel.getExcelTypeId())) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)6, (String)"\u540c\u4e00\u5b57\u5178\u4e3b\u952e\u4e0d\u76f8\u540c", (Map)cellErrColMap);
                }
            } else if (HussarUtils.isEmpty(typeIdMap.get(dictExcel.getTypeCode())) && HussarUtils.isNotEmpty((Object)dictExcel.getExcelTypeId())) {
                typeIdMap.put(dictExcel.getTypeCode(), dictExcel.getExcelTypeId());
            }
            if (!HussarUtils.isNotEmpty((Object)cellErrColMap)) continue;
            errorDataList.add(new ExcelImportMsg((Object)dictExcel, cellErrColMap));
        }
        if (HussarUtils.isNotEmpty(errorDataList)) {
            dicExcelCheckResult.setRootTypeNum(typeCodeList.size());
            ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
            excelCheckResult.setCheckMsg((Object)dicExcelCheckResult);
            return excelCheckResult;
        }
        typeCodeList.clear();
        singleLabelsInSameTypeList.clear();
        ArrayList<DictExcel> readedList = new ArrayList<DictExcel>();
        List<String> idList = allDictTypeInDBList.stream().map(DicType::getId).map(String::valueOf).collect(Collectors.toList());
        idList.addAll(allDicSingleInDBList.stream().map(DicSingle::getId).map(String::valueOf).collect(Collectors.toList()));
        for (int i = 0; i < datas.size(); ++i) {
            DictExcel dictExcel = datas.get(i);
            Map cellErrColMap = HussarBaseExcelValidateHelper.validateEntity((Object)dictExcel, (Integer)i);
            Map cellUpdateColMap = HussarBaseExcelValidateHelper.validateEntity((Object)dictExcel, (Integer)i);
            Map cellNewColMap = HussarBaseExcelValidateHelper.validateEntity((Object)dictExcel, (Integer)i);
            Map cellExistColMap = HussarBaseExcelValidateHelper.validateEntity((Object)dictExcel, (Integer)i);
            this.checkDicForExist(i, dictExcel, cellErrColMap, cellUpdateColMap, cellExistColMap, cellNewColMap, allDictTypeInDBList, allDicSingleInDBList, dicExcelCheckResult, typeCodeAndIdInFirstRepeat, sortList, typeCodeList, singleLabelsInSameTypeList, idList, dictGroupId);
            this.checkDicParentSingleLabels(i, dictExcel, cellErrColMap, cellNewColMap, cellUpdateColMap, cellExistColMap, singleLabelAndParentSingleLabelsMap, singleLabelsInSameTypeList, allDicSingleInDBList, readedList, dicExcelCheckResult);
            readedList.add(dictExcel);
            if (cellErrColMap.size() == 0) {
                successDataList.add(dictExcel);
            }
            if (HussarUtils.isNotEmpty((Object)cellErrColMap)) {
                errorDataList.add(new ExcelImportMsg((Object)dictExcel, cellErrColMap));
            }
            if (HussarUtils.isNotEmpty((Object)cellExistColMap)) {
                existDataList.add(new ExcelImportMsg((Object)dictExcel, cellExistColMap));
            }
            if (HussarUtils.isNotEmpty((Object)cellUpdateColMap)) {
                updateDataList.add(new ExcelImportMsg((Object)dictExcel, cellUpdateColMap));
            }
            if (!HussarUtils.isNotEmpty((Object)cellNewColMap)) continue;
            newDataList.add(new ExcelImportMsg((Object)dictExcel, cellNewColMap));
        }
        dicExcelCheckResult.setRootTypeNum(typeCodeList.size());
        ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
        excelCheckResult.setCheckMsg((Object)dicExcelCheckResult);
        return excelCheckResult;
    }

    public void checkExcelForNotNull(int i, DictExcel dictExcel, Map<Integer, Map<Integer, String>> cellErrColMap, List<DicType> allDictTypeInDBList) {
        if (HussarUtils.isEmpty((Object)dictExcel.getTypeDesc())) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", cellErrColMap);
        }
        if (HussarUtils.isEmpty((Object)dictExcel.getTypeCode())) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)"\u5b57\u5178\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", cellErrColMap);
        }
        if (HussarUtils.isEmpty((Object)dictExcel.getSingleLabel()) && HussarUtils.isNotEmpty((Object)dictExcel.getSingleValue())) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", cellErrColMap);
        }
        if (HussarUtils.isNotEmpty((Object)dictExcel.getSingleLabel()) && HussarUtils.isEmpty((Object)dictExcel.getSingleValue())) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)"\u5b57\u6bb5\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", cellErrColMap);
        }
        if (HussarUtils.isEmpty((Object)dictExcel.getSingleLabel()) && HussarUtils.isEmpty((Object)dictExcel.getSingleValue()) && HussarUtils.isNotEmpty((Object)dictExcel.getParentSingleLabels())) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", cellErrColMap);
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)"\u5b57\u6bb5\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", cellErrColMap);
        }
        if (HussarUtils.isNotEmpty((Object)dictExcel.getTypeDesc()) && dictExcel.getTypeDesc().length() > 32) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u5b57\u5178\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516532\u5b57\u7b26", cellErrColMap);
        }
        if (HussarUtils.isNotEmpty((Object)dictExcel.getTypeCode()) && dictExcel.getTypeCode().length() > 64) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)"\u5b57\u5178\u6807\u8bc6\u6700\u591a\u53ef\u8f93\u516564\u4e2a\u5b57\u7b26", cellErrColMap);
        }
        if (HussarUtils.isNotEmpty((Object)dictExcel.getSingleLabel()) && dictExcel.getSingleLabel().length() > 50) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5b57\u6bb5\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516550\u4e2a\u5b57\u7b26", cellErrColMap);
        }
        if (HussarUtils.isNotEmpty((Object)dictExcel.getSingleValue()) && dictExcel.getSingleValue().length() > 16) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)"\u5b57\u6bb5\u503c\u6700\u591a\u53ef\u8f93\u516516\u4e2a\u5b57\u7b26", cellErrColMap);
        }
        if (HussarUtils.isNotEmpty((Object)dictExcel.getTypeCode())) {
            List sysDictType = allDictTypeInDBList.stream().filter(dicType -> dicType.getRangeType().equals("sys")).collect(Collectors.toList());
            List sysDictTypeCode = sysDictType.stream().map(DicType::getTypeName).collect(Collectors.toList());
            Map map = sysDictType.stream().collect(Collectors.toMap(DicType::getTypeName, Function.identity()));
            if (sysDictTypeCode.contains(dictExcel.getTypeCode())) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)("\u5bfc\u5165\u7684\u5b57\u5178\u6807\u8bc6\u4e0d\u80fd\u4e0e\u7cfb\u7edf\u5b57\u5178\u5206\u7ec4\u4e2d " + ((DicType)map.get(dictExcel.getTypeCode())).getTypeDescription() + " \u5b57\u5178\u5bf9\u5e94\u7684\u6807\u8bc6\u76f8\u540c\uff01"), cellErrColMap);
            }
        }
    }

    public void checkDicTypeDescForRepeat(int i, DictExcel dictExcel, Map<Integer, Map<Integer, String>> cellErrColMap, List<String> typeDescList, DictExcel anteriorDictExcel, boolean[] typeDescIsRepeat, List<String> idList) {
        if (HussarUtils.isNotBlank((CharSequence)dictExcel.getTypeDesc())) {
            String typeDesc = dictExcel.getTypeDesc();
            String excelTypeId = dictExcel.getExcelTypeId();
            if (!typeDesc.equals(anteriorDictExcel.getTypeDesc())) {
                if (typeDescList.contains(typeDesc)) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u5b57\u5178\u540d\u79f0\u586b\u5199\u91cd\u590d", cellErrColMap);
                    typeDescIsRepeat[0] = true;
                } else {
                    typeDescList.add(typeDesc);
                    typeDescIsRepeat[0] = false;
                }
                if (HussarUtils.isNotEmpty((Object)excelTypeId)) {
                    if (idList.contains(excelTypeId)) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)6, (String)"\u5b57\u5178\u4e3b\u952e\u586b\u5199\u91cd\u590d", cellErrColMap);
                        typeDescIsRepeat[1] = true;
                    } else {
                        idList.add(excelTypeId);
                        typeDescIsRepeat[1] = false;
                    }
                }
                anteriorDictExcel.setExcelTypeId(excelTypeId);
                anteriorDictExcel.setTypeDesc(typeDesc);
            } else {
                if (typeDescIsRepeat[0]) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u5b57\u5178\u540d\u79f0\u586b\u5199\u91cd\u590d", cellErrColMap);
                }
                if (typeDescIsRepeat[1]) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)6, (String)"\u5b57\u5178\u4e3b\u952e\u586b\u5199\u91cd\u590d", cellErrColMap);
                }
            }
        }
    }

    private void checkDicIdForRepeat(int i, DictExcel dictExcel, Map<Integer, Map<Integer, String>> cellErrColMap, List<String> singelIdList, List<String> typeIds) {
        if (HussarUtils.isNotBlank((CharSequence)dictExcel.getExcelSingleId())) {
            String excelSingleId = dictExcel.getExcelSingleId();
            if (singelIdList.contains(excelSingleId)) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)"\u5b57\u6bb5\u4e3b\u952e\u586b\u5199\u91cd\u590d", cellErrColMap);
            }
            int index = typeIds.indexOf(excelSingleId);
            if (!HussarUtils.equals((Object)-1, (Object)index)) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)"\u5b57\u6bb5\u4e3b\u952e\u4e0e\u5b57\u5178\u4e3b\u952e\u586b\u5199\u91cd\u590d", cellErrColMap);
                HussarBaseExcelValidateHelper.addErrorMsg((int)index, (int)6, (String)"\u5b57\u6bb5\u4e3b\u952e\u4e0e\u5b57\u5178\u4e3b\u952e\u586b\u5199\u91cd\u590d", cellErrColMap);
            }
            singelIdList.add(excelSingleId);
        }
    }

    public void checkDicTypeCodeForRepeat(int i, DictExcel dictExcel, Map<Integer, Map<Integer, String>> cellErrColMap, List<String> typeCodeList, DictExcel anteriorDictExcel, boolean[] typeCodeIsRepeat, List<String> singleLabelsInSameTypeList, List<String> singleValuesInSameTypeList) {
        if (HussarUtils.isNotEmpty((Object)dictExcel.getTypeCode())) {
            String typeCode = dictExcel.getTypeCode();
            if (!typeCode.equals(anteriorDictExcel.getTypeCode())) {
                if (typeCodeList.contains(typeCode)) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)"\u5b57\u5178\u6807\u8bc6\u586b\u5199\u91cd\u590d", cellErrColMap);
                    typeCodeIsRepeat[0] = true;
                } else {
                    typeCodeList.add(typeCode);
                    typeCodeIsRepeat[0] = false;
                }
                anteriorDictExcel.setTypeCode(typeCode);
                anteriorDictExcel.setSingleLabel(dictExcel.getSingleLabel());
                anteriorDictExcel.setSingleValue(dictExcel.getSingleValue());
                singleLabelsInSameTypeList.clear();
                singleValuesInSameTypeList.clear();
            } else if (typeCodeIsRepeat[0]) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)"\u5b57\u5178\u6807\u8bc6\u586b\u5199\u91cd\u590d", cellErrColMap);
            }
        } else {
            singleLabelsInSameTypeList.clear();
            singleValuesInSameTypeList.clear();
        }
    }

    public void checkDicSingleLabelForRepeat(int i, DictExcel dictExcel, Map<Integer, Map<Integer, String>> cellErrColMap, List<String> singleLabelsInSameTypeList) {
        if (HussarUtils.isNotBlank((CharSequence)dictExcel.getSingleLabel())) {
            String singleLabel = dictExcel.getSingleLabel();
            if (singleLabelsInSameTypeList.contains(singleLabel)) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5f53\u524d\u5b57\u5178\u6807\u8bc6\u4e0b\uff0c\u5b57\u6bb5\u540d\u79f0\u586b\u5199\u91cd\u590d", cellErrColMap);
            } else {
                singleLabelsInSameTypeList.add(singleLabel);
            }
        }
    }

    public void checkDictSingleValueForRepeat(int i, DictExcel dictExcel, Map<Integer, Map<Integer, String>> cellErrColMap, List<String> singleValuesInSameTypeList) {
        if (HussarUtils.isNotBlank((CharSequence)dictExcel.getSingleValue())) {
            String singleValue = dictExcel.getSingleValue();
            if (singleValuesInSameTypeList.contains(singleValue)) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)"\u5f53\u524d\u5b57\u5178\u6807\u8bc6\u4e0b\uff0c\u5b57\u6bb5\u503c\u586b\u5199\u91cd\u590d", cellErrColMap);
            } else {
                singleValuesInSameTypeList.add(singleValue);
            }
        }
    }

    public void checkDicForExist(int i, DictExcel dictExcel, Map<Integer, Map<Integer, String>> cellErrColMap, Map<Integer, Map<Integer, String>> cellUpdateColMap, Map<Integer, Map<Integer, String>> cellExistColMap, Map<Integer, Map<Integer, String>> cellNewColMap, List<DicType> allDictTypeInDBList, List<DicSingle> allDicSingleInDBList, DicExcelCheckResult dicExcelCheckResult, Map<String, Long> typeCodeAndIdInFirstRepeat, List<Integer> sortList, List<String> typeCodeList, List<String> singleLabelsInSameTypeList, List<String> idList, Long dictGroupId) {
        if (HussarUtils.isNotEmpty((Object)dictExcel.getTypeCode())) {
            DicType sameCodeType;
            if (!typeCodeList.contains(dictExcel.getTypeCode())) {
                sortList.set(1, 0);
                typeCodeList.add(dictExcel.getTypeCode());
                singleLabelsInSameTypeList.clear();
            }
            if (HussarUtils.isNotEmpty((Object)(sameCodeType = this.getSameCodeType(allDictTypeInDBList, dictExcel)))) {
                dictExcel.setTypeId(sameCodeType.getId());
                if (!sameCodeType.getTypeDescription().equals(dictExcel.getTypeDesc())) {
                    if (HussarUtils.isNotEmpty((Object)this.getSameDescType(allDictTypeInDBList, dictExcel, dictGroupId))) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u5b57\u5178\u540d\u79f0\u5df2\u5b58\u5728\uff01\u8bf7\u91cd\u65b0\u586b\u5199", cellErrColMap);
                        if (!typeCodeAndIdInFirstRepeat.containsKey(dictExcel.getTypeCode())) {
                            typeCodeAndIdInFirstRepeat.put(dictExcel.getTypeCode(), dictExcel.getTypeId());
                            dicExcelCheckResult.setErrorTypeNum(dicExcelCheckResult.getErrorTypeNum() + 1);
                        }
                    } else {
                        HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)0, (String)"\u5f53\u524d\u4e3a\u66f4\u65b0\u5df2\u6709\u5b57\u5178\u7684\u5b57\u5178\u540d\u79f0", cellUpdateColMap);
                        HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)1, (String)"\u5f53\u524d\u5b57\u5178\u6807\u8bc6\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u5bf9\u5e94\u5b57\u5178\u540d\u79f0\u4e3a\u66f4\u65b0\u6570\u636e", cellUpdateColMap);
                        HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)"\u5f53\u524d\u5b57\u5178\u540d\u79f0\u4e3a\u66f4\u65b0\u6570\u636e", cellExistColMap);
                        HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)1, (String)"\u5f53\u524d\u5b57\u5178\u6807\u8bc6\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u5bf9\u5e94\u5b57\u5178\u540d\u79f0\u4e3a\u66f4\u65b0\u6570\u636e", cellExistColMap);
                        if (!typeCodeAndIdInFirstRepeat.containsKey(dictExcel.getTypeCode())) {
                            typeCodeAndIdInFirstRepeat.put(dictExcel.getTypeCode(), dictExcel.getTypeId());
                            dicExcelCheckResult.setUpdateTypeNum(dicExcelCheckResult.getUpdateTypeNum() + 1);
                            dicExcelCheckResult.setExistTypeNum(dicExcelCheckResult.getExistTypeNum() + 1);
                        }
                    }
                } else {
                    HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)"\u5f53\u524d\u5b57\u5178\u540d\u79f0\u5728\u6570\u636e\u5e93\u4e2d\u6709\u76f8\u540c\u6570\u636e", cellExistColMap);
                    HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)1, (String)"\u5f53\u524d\u5b57\u5178\u6807\u8bc6\u5728\u6570\u636e\u5e93\u4e2d\u6709\u76f8\u540c\u6570\u636e", cellExistColMap);
                    if (!typeCodeAndIdInFirstRepeat.containsKey(dictExcel.getTypeCode())) {
                        typeCodeAndIdInFirstRepeat.put(dictExcel.getTypeCode(), dictExcel.getTypeId());
                        dicExcelCheckResult.setExistTypeNum(dicExcelCheckResult.getExistTypeNum() + 1);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)dictExcel.getSingleValue())) {
                    dicExcelCheckResult.setRootSingleNum(dicExcelCheckResult.getRootSingleNum() + 1);
                    DicSingle sameValueSingle = this.getSameValueSingle(allDicSingleInDBList, dictExcel);
                    if (HussarUtils.isNotEmpty((Object)sameValueSingle)) {
                        dictExcel.setSingleId(sameValueSingle.getId());
                        if (!sameValueSingle.getLabel().equals(dictExcel.getSingleLabel())) {
                            if (HussarUtils.isNotEmpty((Object)this.getSameLabelSingle(allDicSingleInDBList, dictExcel.getTypeCode(), dictExcel.getSingleLabel()))) {
                                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5f53\u524d\u5b57\u5178\u4e0b\uff0c\u5b57\u5178\u540d\u79f0\u5df2\u5b58\u5728\uff01\u8bf7\u91cd\u65b0\u586b\u5199", cellErrColMap);
                                dicExcelCheckResult.setErrorSingleNum(dicExcelCheckResult.getErrorSingleNum() + 1);
                            } else {
                                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)2, (String)"\u5f53\u524d\u4e3a\u66f4\u65b0\u5df2\u6709\u5b57\u6bb5\u7684\u5b57\u6bb5\u540d\u79f0", cellUpdateColMap);
                                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)3, (String)"\u5f53\u524d\u5b57\u6bb5\u503c\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u5bf9\u5e94\u5b57\u6bb5\u540d\u79f0\u4e3a\u66f4\u65b0\u6570\u636e", cellUpdateColMap);
                                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)2, (String)"\u5f53\u524d\u4e3a\u66f4\u65b0\u5df2\u6709\u5b57\u6bb5\u7684\u5b57\u6bb5\u540d\u79f0", cellExistColMap);
                                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)3, (String)"\u5f53\u524d\u5b57\u6bb5\u503c\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u5bf9\u5e94\u5b57\u6bb5\u540d\u79f0\u4e3a\u66f4\u65b0\u6570\u636e", cellExistColMap);
                                dicExcelCheckResult.setUpdateSingleNum(dicExcelCheckResult.getUpdateSingleNum() + 1);
                                dicExcelCheckResult.setExistSingleNum(dicExcelCheckResult.getExistSingleNum() + 1);
                            }
                        } else {
                            HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)2, (String)"\u5f53\u524d\u5b57\u6bb5\u540d\u79f0\u5728\u6570\u636e\u5e93\u4e2d\u6709\u76f8\u540c\u6570\u636e", cellExistColMap);
                            HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)3, (String)"\u5f53\u524d\u5b57\u6bb5\u503c\u5728\u6570\u636e\u5e93\u4e2d\u6709\u76f8\u540c\u6570\u636e", cellExistColMap);
                            dicExcelCheckResult.setExistSingleNum(dicExcelCheckResult.getExistSingleNum() + 1);
                        }
                    } else if (HussarUtils.isNotEmpty((Object)this.getSameLabelSingle(allDicSingleInDBList, dictExcel.getTypeCode(), dictExcel.getSingleLabel()))) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)"\u5f53\u524d\u5206\u7ec4\u4e0b\u5b57\u6bb5\u540d\u79f0\u5df2\u5b58\u5728\uff01", cellErrColMap);
                        dicExcelCheckResult.setExistSingleNum(dicExcelCheckResult.getErrorSingleNum() + 1);
                    } else {
                        String excelSingleId = dictExcel.getExcelSingleId();
                        if (HussarUtils.isNotEmpty((Object)excelSingleId) && idList.contains(excelSingleId)) {
                            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)"\u5f53\u524d\u5b57\u6bb5\u4e3a\u65b0\u589e\u6570\u636e\uff0c\u4f46\u4e3b\u952e\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728", cellErrColMap);
                        }
                        if (HussarUtils.isNotEmpty((Object)excelSingleId) && HussarUtils.equals((Object)String.valueOf(Constants.ROOT_NODE_ID), (Object)excelSingleId)) {
                            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)"\u5f53\u524d\u5b57\u6bb5\u4e3a\u65b0\u589e\u6570\u636e\uff0c\u4f46\u4e3b\u952e\u4e0e\u5b57\u5178\u6811\u6839\u8282\u70b9\u51b2\u7a81", cellErrColMap);
                        }
                        HussarBaseExcelValidateHelper.addNewMsg((int)i, (int)2, (String)"\u5f53\u524d\u5b57\u6bb5\u540d\u79f0\u4e3a\u65b0\u589e\u6570\u636e", cellNewColMap);
                        HussarBaseExcelValidateHelper.addNewMsg((int)i, (int)3, (String)"\u5f53\u524d\u5b57\u6bb5\u503c\u4e3a\u65b0\u589e\u6570\u636e", cellNewColMap);
                        if (HussarUtils.isNotEmpty((Object)dictExcel.getParentSingleLabels())) {
                            HussarBaseExcelValidateHelper.addNewMsg((int)i, (int)4, (String)"\u5f53\u524d\u4e0a\u7ea7\u5b57\u6bb5\u4e3a\u65b0\u589e\u6570\u636e", cellNewColMap);
                        }
                        dicExcelCheckResult.setNewSingleNum(dicExcelCheckResult.getNewSingleNum() + 1);
                        long newSingleId = IdWorker.getId((Object)new DicSingle());
                        dictExcel.setSingleId(Long.valueOf(newSingleId));
                        List singles = allDicSingleInDBList.stream().filter(single -> single.getTypeId().equals(dictExcel.getTypeId())).sorted(Comparator.comparing(DicSingle::getSort)).collect(Collectors.toList());
                        if (HussarUtils.isNotEmpty(singles)) {
                            DicSingle lastOne = (DicSingle)singles.get(singles.size() - 1);
                            int lastSort = lastOne.getSort();
                            sortList.set(1, lastSort + sortList.get(1) + 1);
                            dictExcel.setSingleSort(sortList.get(1));
                        } else {
                            sortList.set(1, sortList.get(1) + 1);
                            dictExcel.setSingleSort(sortList.get(1));
                        }
                    }
                }
            } else {
                if (HussarUtils.isNotEmpty((Object)this.getSameDescType(allDictTypeInDBList, dictExcel, dictGroupId))) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)"\u5f53\u524d\u65b0\u589e\u5b57\u5178\u5bf9\u5e94\u5b57\u5178\u540d\u79f0\u5df2\u5b58\u5728\uff01", cellErrColMap);
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u5b57\u5178\u540d\u79f0\u5df2\u5b58\u5728\uff01", cellErrColMap);
                    if (!typeCodeAndIdInFirstRepeat.containsKey(dictExcel.getTypeCode())) {
                        typeCodeAndIdInFirstRepeat.put(dictExcel.getTypeCode(), dictExcel.getTypeId());
                        dicExcelCheckResult.setErrorTypeNum(dicExcelCheckResult.getErrorTypeNum() + 1);
                    }
                } else {
                    String excelTypeId = dictExcel.getExcelTypeId();
                    if (HussarUtils.isNotEmpty((Object)excelTypeId) && idList.contains(excelTypeId)) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)6, (String)"\u5f53\u524d\u5b57\u5178\u4e3a\u65b0\u589e\u6570\u636e\uff0c\u4f46\u4e3b\u952e\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728", cellErrColMap);
                    }
                    if (HussarUtils.isNotEmpty((Object)excelTypeId) && HussarUtils.equals((Object)String.valueOf(Constants.ROOT_NODE_ID), (Object)excelTypeId)) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)6, (String)"\u5f53\u524d\u5b57\u5178\u4e3a\u65b0\u589e\u6570\u636e\uff0c\u4f46\u4e3b\u952e\u4e0e\u5b57\u5178\u6811\u6839\u8282\u70b9\u51b2\u7a81", cellErrColMap);
                    }
                    HussarBaseExcelValidateHelper.addNewMsg((int)i, (int)0, (String)"\u5f53\u524d\u5b57\u5178\u540d\u79f0\u4e3a\u65b0\u589e\u6570\u636e", cellNewColMap);
                    HussarBaseExcelValidateHelper.addNewMsg((int)i, (int)1, (String)"\u5f53\u524d\u5b57\u5178\u6807\u8bc6\u4e3a\u65b0\u589e\u6570\u636e", cellNewColMap);
                    if (!typeCodeAndIdInFirstRepeat.containsKey(dictExcel.getTypeCode())) {
                        dicExcelCheckResult.setNewTypeNum(dicExcelCheckResult.getNewTypeNum() + 1);
                        long newTypeId = IdWorker.getId((Object)new DicType());
                        dictExcel.setTypeId(Long.valueOf(newTypeId));
                        sortList.set(0, sortList.get(0) + 1);
                        dictExcel.setTypeSort(sortList.get(0));
                        typeCodeAndIdInFirstRepeat.put(dictExcel.getTypeCode(), dictExcel.getTypeId());
                    } else {
                        Long typeId = typeCodeAndIdInFirstRepeat.get(dictExcel.getTypeCode());
                        dictExcel.setTypeId(typeId);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)dictExcel.getSingleValue())) {
                    String excelSingleId = dictExcel.getExcelSingleId();
                    if (HussarUtils.isNotEmpty((Object)excelSingleId) && idList.contains(excelSingleId)) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)"\u5f53\u524d\u5b57\u6bb5\u4e3a\u65b0\u589e\u6570\u636e\uff0c\u4f46\u4e3b\u952e\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728", cellErrColMap);
                    }
                    if (HussarUtils.isNotEmpty((Object)excelSingleId) && HussarUtils.equals((Object)String.valueOf(Constants.ROOT_NODE_ID), (Object)excelSingleId)) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)"\u5f53\u524d\u5b57\u6bb5\u4e3a\u65b0\u589e\u6570\u636e\uff0c\u4f46\u4e3b\u952e\u4e0e\u5b57\u5178\u6811\u6839\u8282\u70b9\u51b2\u7a81", cellErrColMap);
                    }
                    HussarBaseExcelValidateHelper.addNewMsg((int)i, (int)2, (String)"\u5f53\u524d\u5b57\u6bb5\u540d\u79f0\u4e3a\u65b0\u589e\u6570\u636e", cellNewColMap);
                    HussarBaseExcelValidateHelper.addNewMsg((int)i, (int)3, (String)"\u5f53\u524d\u5b57\u6bb5\u503c\u4e3a\u65b0\u589e\u6570\u636e", cellNewColMap);
                    if (HussarUtils.isNotEmpty((Object)dictExcel.getParentSingleLabels())) {
                        HussarBaseExcelValidateHelper.addNewMsg((int)i, (int)4, (String)"\u5f53\u524d\u4e0a\u7ea7\u5b57\u6bb5\u4e3a\u65b0\u589e\u6570\u636e", cellNewColMap);
                    }
                    dicExcelCheckResult.setRootSingleNum(dicExcelCheckResult.getRootSingleNum() + 1);
                    dicExcelCheckResult.setNewSingleNum(dicExcelCheckResult.getNewSingleNum() + 1);
                    long newSingleId = IdWorker.getId((Object)new DicSingle());
                    dictExcel.setSingleId(Long.valueOf(newSingleId));
                    List singles = allDicSingleInDBList.stream().filter(single -> single.getTypeId().equals(dictExcel.getTypeId())).sorted(Comparator.comparing(DicSingle::getSort)).collect(Collectors.toList());
                    if (HussarUtils.isNotEmpty(singles)) {
                        DicSingle lastOne = (DicSingle)singles.get(singles.size() - 1);
                        int lastSort = lastOne.getSort();
                        sortList.set(1, lastSort + sortList.get(1) + 1);
                        dictExcel.setSingleSort(sortList.get(1));
                    } else {
                        sortList.set(1, sortList.get(1) + 1);
                        dictExcel.setSingleSort(sortList.get(1));
                    }
                }
            }
        }
    }

    public void checkDicParentSingleLabels(int i, DictExcel dictExcel, Map<Integer, Map<Integer, String>> cellErrColMap, Map<Integer, Map<Integer, String>> cellNewColMap, Map<Integer, Map<Integer, String>> cellUpdateColMap, Map<Integer, Map<Integer, String>> cellExistColMap, Map<String, String> singleLabelAndParentSingleLabelsMap, List<String> singleLabelsInSameTypeList, List<DicSingle> allDicSingleInDBList, List<DictExcel> readedList, DicExcelCheckResult dicExcelCheckResult) {
        if (!singleLabelsInSameTypeList.contains(dictExcel.getSingleLabel())) {
            singleLabelsInSameTypeList.add(dictExcel.getSingleLabel());
        }
        if (HussarUtils.isNotBlank((CharSequence)dictExcel.getParentSingleLabels())) {
            String singleLabel = dictExcel.getSingleLabel();
            String parentSingleLabels = dictExcel.getParentSingleLabels();
            singleLabelAndParentSingleLabelsMap.put(singleLabel, parentSingleLabels);
            if (!parentSingleLabels.contains("/")) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u7528'/'\u5206\u9694\u4e0d\u540c\u5c42\u7ea7", cellErrColMap);
            } else {
                String parentLabel;
                List parentSingleLabelList = Arrays.asList(parentSingleLabels.split("/")).stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
                Integer listSize = parentSingleLabelList.size();
                if (HussarUtils.isEmpty((Object)listSize)) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u4ece\u6240\u5c5e\u6700\u9ad8\u7ea7\u5b57\u6bb5\u5f00\u59cb\u586b\u5199\uff0c\u6bcf\u4e00\u7ea7\u7528'/'\u5206\u9694", cellErrColMap);
                }
                if (listSize == 1) {
                    parentLabel = (String)parentSingleLabelList.get(0);
                    if (singleLabelsInSameTypeList.contains(parentLabel)) {
                        if (HussarUtils.isNotBlank((CharSequence)singleLabelAndParentSingleLabelsMap.get(parentLabel))) {
                            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u586b\u5199\u4e0d\u5168\uff0c\u8bf7\u6309\u7167\u6b63\u786e\u7684\u5c42\u7ea7\u586b\u5199", cellErrColMap);
                        } else {
                            DictExcel parentSingleExcel = (DictExcel)readedList.stream().filter(dictExcel1 -> dictExcel1.getTypeCode().equals(dictExcel.getTypeCode()) && dictExcel1.getSingleLabel().equals(parentLabel)).collect(Collectors.toList()).get(0);
                            dictExcel.setParentSingleId(parentSingleExcel.getSingleId());
                            DicSingle sameValueSingleInDB = this.getSameValueSingle(allDicSingleInDBList, dictExcel);
                            if (HussarUtils.isNotEmpty((Object)sameValueSingleInDB)) {
                                Long parentIdInDB = sameValueSingleInDB.getParentId();
                                if (!parentSingleExcel.getSingleId().equals(parentIdInDB)) {
                                    HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)4, (String)"\u5f53\u524d\u4e0a\u7ea7\u5b57\u6bb5\u4e3a\u66f4\u65b0\u6570\u636e", cellUpdateColMap);
                                    HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)4, (String)"\u5f53\u524d\u4e0a\u7ea7\u5b57\u6bb5\u4e3a\u66f4\u65b0\u6570\u636e", cellExistColMap);
                                    dicExcelCheckResult.setUpdateSingleNum(dicExcelCheckResult.getUpdateSingleNum() + 1);
                                } else {
                                    HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)4, (String)"\u5f53\u524d\u4e0a\u7ea7\u5b57\u6bb5\u7ed3\u6784\u4e0e\u6570\u636e\u5e93\u4e2d\u7684\u7ed3\u6784\u76f8\u540c", cellExistColMap);
                                }
                            } else {
                                HussarBaseExcelValidateHelper.addNewMsg((int)i, (int)4, (String)"\u5f53\u524d\u4e0a\u7ea7\u5b57\u6bb5\u4e3a\u65b0\u589e\u6570\u636e", cellNewColMap);
                            }
                        }
                    } else {
                        DicSingle parentSingle = this.getSameLabelSingle(allDicSingleInDBList, dictExcel.getTypeCode(), parentLabel);
                        if (HussarUtils.isEmpty((Object)parentSingle)) {
                            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u8bf7\u6309\u7167\u6b63\u786e\u7684\u5c42\u7ea7\u586b\u5199", cellErrColMap);
                        } else if (HussarUtils.isNotEmpty((Object)parentSingle.getParentId())) {
                            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u586b\u5199\u4e0d\u5168\uff0c\u8bf7\u6309\u7167\u6b63\u786e\u7684\u5c42\u7ea7\u586b\u5199", cellErrColMap);
                        } else {
                            dictExcel.setParentSingleId(parentSingle.getId());
                        }
                    }
                }
                if (listSize > 1) {
                    parentLabel = (String)parentSingleLabelList.get(listSize - 1);
                    DicSingle sameValueSingleInDB = this.getSameValueSingle(allDicSingleInDBList, dictExcel);
                    if (HussarUtils.isNotEmpty((Object)sameValueSingleInDB)) {
                        Long parentSingleIdInDB = sameValueSingleInDB.getParentId();
                        DicSingle parentSingleInDB = (DicSingle)allDicSingleInDBList.stream().filter(dicSingle -> dicSingle.getId().equals(parentSingleIdInDB)).collect(Collectors.toList()).get(0);
                        String parentSingleLabelInDB = parentSingleInDB.getLabel();
                        if (!parentLabel.equals(parentSingleLabelInDB)) {
                            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)4, (String)"\u5f53\u524d\u4e0a\u7ea7\u5b57\u6bb5\u66f4\u65b0\u6570\u636e", cellUpdateColMap);
                            dicExcelCheckResult.setUpdateSingleNum(dicExcelCheckResult.getUpdateSingleNum() + 1);
                        }
                    }
                    if (singleLabelsInSameTypeList.contains(parentLabel)) {
                        if (HussarUtils.isBlank((CharSequence)singleLabelAndParentSingleLabelsMap.get(parentLabel))) {
                            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u5411\u4e0a\u68c0\u67e5\uff0c\u586b\u5199\u6b63\u786e\u7684\u5c42\u7ea7\u5173\u7cfb", cellErrColMap);
                        } else {
                            String grandParentSingle = singleLabelAndParentSingleLabelsMap.get(parentLabel);
                            if (!(grandParentSingle = grandParentSingle + "/" + parentLabel).equals(parentSingleLabels)) {
                                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u5411\u4e0a\u68c0\u67e5\uff0c\u586b\u5199\u6b63\u786e\u7684\u5c42\u7ea7\u5173\u7cfb", cellErrColMap);
                            } else {
                                DictExcel parentSingleExcel = (DictExcel)readedList.stream().filter(dictExcel1 -> dictExcel1.getTypeCode().equals(dictExcel.getTypeCode()) && dictExcel1.getSingleLabel().equals(parentLabel)).collect(Collectors.toList()).get(0);
                                dictExcel.setParentSingleId(parentSingleExcel.getSingleId());
                            }
                        }
                    } else {
                        DicSingle parentSingle = this.getSameLabelSingle(allDicSingleInDBList, dictExcel.getTypeCode(), parentLabel);
                        if (HussarUtils.isEmpty((Object)parentSingle)) {
                            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u8bf7\u6309\u7167\u6b63\u786e\u7684\u5c42\u7ea7\u586b\u5199", cellErrColMap);
                        } else if (HussarUtils.isEmpty((Object)parentSingle.getParentId())) {
                            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u5411\u4e0a\u68c0\u67e5\uff0c\u586b\u5199\u6b63\u786e\u7684\u5c42\u7ea7\u5173\u7cfb", cellErrColMap);
                        } else {
                            String grandParentSingleLabels = this.getParentSingleLabels(allDicSingleInDBList, parentSingle, "");
                            String parentSingleLabels2 = grandParentSingleLabels + "/" + parentLabel;
                            if (!parentSingleLabels2.equals(parentSingleLabels)) {
                                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u5411\u4e0a\u68c0\u67e5\uff0c\u586b\u5199\u6b63\u786e\u7684\u5c42\u7ea7\u5173\u7cfb", cellErrColMap);
                            } else {
                                dictExcel.setParentSingleId(parentSingle.getId());
                            }
                        }
                    }
                }
            }
        } else {
            Long parentIdInDB;
            DicSingle sameValueSingleInDB = this.getSameValueSingle(allDicSingleInDBList, dictExcel);
            if (HussarUtils.isNotEmpty((Object)sameValueSingleInDB) && HussarUtils.isNotEmpty((Object)(parentIdInDB = sameValueSingleInDB.getParentId()))) {
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)4, (String)"\u66f4\u65b0\u5f53\u524d\u4e0a\u7ea7\u5b57\u6bb5\u4e3a\u7a7a", cellUpdateColMap);
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)4, (String)"\u66f4\u65b0\u5f53\u524d\u4e0a\u7ea7\u5b57\u6bb5\u4e3a\u7a7a", cellExistColMap);
                dicExcelCheckResult.setUpdateSingleNum(dicExcelCheckResult.getUpdateSingleNum() + 1);
            }
        }
    }

    public List<DicType> getAllDictTypeInDB() {
        return this.dicTypeService.getAllDicTypeInDB();
    }

    public List<DicSingle> getAllDictSingleInDB() {
        return this.dicSingleService.getAllDictSingleInDB();
    }

    public DicType getSameCodeType(List<DicType> allDicTypeList, DictExcel dicExcel) {
        Optional<DicType> sameTypeCode = allDicTypeList.stream().filter(dicType -> dicType.getTypeName().equals(dicExcel.getTypeCode())).findFirst();
        return sameTypeCode.orElse(null);
    }

    public DicType getSameDescType(List<DicType> allDicTypeList, DictExcel dicExcel, Long dictGroupId) {
        Optional<DicType> sameCodeType = allDicTypeList.stream().filter(dicType -> dicType.getParentId().equals(dictGroupId) && dicType.getTypeDescription().equals(dicExcel.getTypeDesc())).findFirst();
        return sameCodeType.orElse(null);
    }

    public DicSingle getSameValueSingle(List<DicSingle> allDictSinglesInDB, DictExcel dictExcel) {
        Optional<DicSingle> sameValueSingle = allDictSinglesInDB.stream().filter(dicSingle -> dicSingle.getTypeName().equals(dictExcel.getTypeCode()) && dicSingle.getValue().equals(dictExcel.getSingleValue())).filter(Objects::nonNull).findFirst();
        return sameValueSingle.orElse(null);
    }

    public DicSingle getSameLabelSingle(List<DicSingle> allDictSinglesInDB, String typeCode, String singleLabel) {
        Optional<DicSingle> sameValueSingle = allDictSinglesInDB.stream().filter(dicSingle -> dicSingle.getTypeName().equals(typeCode) && dicSingle.getLabel().equals(singleLabel)).findFirst();
        return sameValueSingle.orElse(null);
    }

    public DicSingle getSingleBySingleId(List<DicSingle> allDictSingleInDB, Long singleId) {
        Optional<DicSingle> single = allDictSingleInDB.stream().filter(dicSingle -> dicSingle.getId().equals(singleId)).findFirst();
        return single.orElse(null);
    }

    private String getParentSingleLabels(List<DicSingle> allDictSinglesInDB, DicSingle single, String parentSingleLabels) {
        DicSingle parentSingle = this.getSingleBySingleId(allDictSinglesInDB, single.getParentId());
        if (HussarUtils.notNull((Object)parentSingle)) {
            parentSingleLabels = "/" + parentSingle.getLabel() + parentSingleLabels;
            if (HussarUtils.notNull((Object)parentSingle.getParentId())) {
                parentSingleLabels = this.getParentSingleLabels(allDictSinglesInDB, parentSingle, parentSingleLabels);
            }
        }
        return parentSingleLabels;
    }

    @HussarTransactional
    public void saveData(List<DictExcel> datas, List<Object> otherParams) {
        Long dictGroupId = (Long)otherParams.get(0);
        ArrayList<DicType> dicTypes = new ArrayList<DicType>();
        ArrayList<DicSingle> dicSingles = new ArrayList<DicSingle>();
        ArrayList<String> typeCodeList = new ArrayList<String>();
        HashMap<String, Long> typeCodeIdMap = new HashMap<String, Long>();
        HashMap<Long, Long> singleIdMap = new HashMap<Long, Long>();
        for (DictExcel dictExcel : datas) {
            if (!typeCodeList.contains(dictExcel.getTypeCode())) {
                typeCodeList.add(dictExcel.getTypeCode());
                DicType dicType = new DicType();
                dicType.setId(Long.valueOf(HussarUtils.isEmpty((Object)dictExcel.getExcelTypeId()) ? dictExcel.getTypeId() : Long.parseLong(dictExcel.getExcelTypeId())));
                dicType.setTypeName(dictExcel.getTypeCode());
                dicType.setTypeDescription(dictExcel.getTypeDesc());
                dicType.setParentId(dictGroupId);
                if (HussarUtils.equals((Object)DictConstant.SYS_DICT_RANGE_TYPE_BIZ_ID, (Object)dictGroupId)) {
                    dicType.setRangeType("biz");
                } else {
                    dicType.setRangeType(String.valueOf(dictGroupId));
                }
                if (HussarUtils.isNotEmpty((Object)dictExcel.getTypeSort())) {
                    dicType.setSort(dictExcel.getTypeSort());
                }
                dicTypes.add(dicType);
                typeCodeIdMap.put(dictExcel.getTypeCode(), dicType.getId());
            }
            if (!HussarUtils.isNotEmpty((Object)dictExcel.getSingleValue())) continue;
            DicSingle dicSingle = new DicSingle();
            dicSingle.setId(Long.valueOf(HussarUtils.isEmpty((Object)dictExcel.getExcelSingleId()) ? dictExcel.getSingleId() : Long.parseLong(dictExcel.getExcelSingleId())));
            singleIdMap.put(dictExcel.getSingleId(), dicSingle.getId());
            dicSingle.setTypeId((Long)typeCodeIdMap.get(dictExcel.getTypeCode()));
            dicSingle.setLabel(dictExcel.getSingleLabel());
            dicSingle.setValue(dictExcel.getSingleValue());
            if (HussarUtils.isNotEmpty((Object)dictExcel.getParentSingleLabels())) {
                dicSingle.setParentId(dictExcel.getParentSingleId());
            }
            if (HussarUtils.isNotEmpty((Object)dictExcel.getSingleSort())) {
                dicSingle.setSort(dictExcel.getSingleSort());
            }
            dicSingles.add(dicSingle);
        }
        if (HussarUtils.isNotEmpty(dicSingles)) {
            dicSingles.forEach(d -> {
                if (HussarUtils.isNotEmpty((Object)d.getParentId())) {
                    d.setParentId((Long)singleIdMap.get(d.getParentId()));
                }
            });
        }
        this.dicTypeService.saveOrUpdateBatch(dicTypes);
        this.dicSingleService.saveOrUpdateBatch(dicSingles);
    }

    @HussarTransactional
    public void updateData(List<DictExcel> datas, List<Object> otherParams) {
        Long dictGroupId = (Long)otherParams.get(0);
        ArrayList<DicType> dicTypes = new ArrayList<DicType>();
        ArrayList<DicSingle> dicSingles = new ArrayList<DicSingle>();
        ArrayList<String> typeCodeList = new ArrayList<String>();
        ArrayList<Long> singleIdForUpdateNoParent = new ArrayList<Long>();
        for (DictExcel dictExcel : datas) {
            if (!typeCodeList.contains(dictExcel.getTypeCode())) {
                typeCodeList.add(dictExcel.getTypeCode());
                DicType dicType = new DicType();
                dicType.setId(dictExcel.getTypeId());
                dicType.setTypeName(dictExcel.getTypeCode());
                dicType.setTypeDescription(dictExcel.getTypeDesc());
                dicType.setParentId(dictGroupId);
                if (HussarUtils.equals((Object)DictConstant.SYS_DICT_RANGE_TYPE_BIZ_ID, (Object)dictGroupId)) {
                    dicType.setRangeType("biz");
                } else {
                    dicType.setRangeType(String.valueOf(dictGroupId));
                }
                if (HussarUtils.isNotEmpty((Object)dictExcel.getTypeSort())) {
                    dicType.setSort(dictExcel.getTypeSort());
                }
                dicTypes.add(dicType);
            }
            if (!HussarUtils.isNotEmpty((Object)dictExcel.getSingleValue())) continue;
            DicSingle dicSingle = new DicSingle();
            dicSingle.setId(dictExcel.getSingleId());
            dicSingle.setTypeId(dictExcel.getTypeId());
            dicSingle.setLabel(dictExcel.getSingleLabel());
            dicSingle.setValue(dictExcel.getSingleValue());
            if (HussarUtils.isNotEmpty((Object)dictExcel.getParentSingleLabels())) {
                dicSingle.setParentId(dictExcel.getParentSingleId());
            } else {
                singleIdForUpdateNoParent.add(dicSingle.getId());
            }
            if (HussarUtils.isNotEmpty((Object)dictExcel.getSingleSort())) {
                dicSingle.setSort(dictExcel.getSingleSort());
            }
            dicSingles.add(dicSingle);
        }
        this.dicTypeService.saveOrUpdateBatch(dicTypes);
        this.dicSingleService.saveOrUpdateBatch(dicSingles);
        if (HussarUtils.isNotEmpty(singleIdForUpdateNoParent)) {
            this.dicSingleService.updateSingleForUpdateToNoParent(singleIdForUpdateNoParent);
        }
    }

    public void checkExcelPrimaryKey(Integer i, String key, Integer index, Map<Integer, Map<Integer, String>> cellErrColMap, String type) {
        if (HussarUtils.isEmpty((Object)StringUtils.trimToEmpty((String)key))) {
            return;
        }
        String tip = "";
        if (HussarUtils.equals((Object)"user", (Object)type)) {
            tip = "\u7528\u6237";
        } else if (HussarUtils.equals((Object)"organ", (Object)type)) {
            tip = "\u7ec4\u7ec7\u673a\u6784";
        } else if (HussarUtils.equals((Object)"dictType", (Object)type)) {
            tip = "\u5b57\u5178";
        } else if (HussarUtils.equals((Object)"dictSingle", (Object)type)) {
            tip = "\u5b57\u6bb5";
        }
        try {
            Long.parseLong(key);
        }
        catch (Exception e) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + "\u4e3b\u952e\u4e0d\u5408\u6cd5"), cellErrColMap);
        }
    }
}

