/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.common.controller;

import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.properties.PinyinSynProperties;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.general.common.properties.HussarBaseJobProperties;
import com.jxdinfo.hussar.general.common.properties.HussarBaseOauth2SecurityProperties;
import com.jxdinfo.hussar.general.common.properties.HussarBaseSecurityProperties;
import com.jxdinfo.hussar.general.common.properties.HussarSecureProperties;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.EncryptSupportService;
import com.jxdinfo.hussar.platform.core.support.service.dto.EncryptDto;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.core.dto.PasswordEncryptDTO;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/baseData"})
@Api(tags={"\u57fa\u7840\u4fe1\u606f\u7ba1\u7406"})
public class SystemBaseDataControler {
    private static int SM2 = 1;
    private static final Logger logger = LoggerFactory.getLogger(SystemBaseDataControler.class);
    @Resource
    private IGlobalService globalService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Resource
    private SecureAssesmentProperties secureAssesmentProperties;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private HussarSecureProperties hussarSecureProperties;
    @Resource
    private PasswordEncryptService passwordEncryptService;
    @Resource
    private HussarBaseJobProperties hussarBaseJobProperties;
    @Resource
    private HussarBaseOauth2SecurityProperties hussarBaseOauth2SecurityProperties;
    @Resource
    private HussarBaseSecurityProperties hussarBaseSecurityProperties;
    @Resource
    private MultipartProperties multipartProperties;
    @Value(value="${hussar.secure.encrypt.getEnabled:${hussar.secure.encrypt.get-enabled:true}}")
    private Boolean getEncryptEnable;
    @Value(value="${hussar.secure.encrypt.postEnabled:${hussar.secure.encrypt.post-enabled:true}}")
    private Boolean postEncryptEnable;
    @Resource
    private PinyinSynProperties pinyinSynProperties;
    private static String DEF_ORG_OUT_NAME = "\u516c\u53f8\u5916\u90e8\u7ec4\u7ec7";
    private static String DEF_ORG_IN_NAME = "\u516c\u53f8\u5185\u90e8\u7ec4\u7ec7";

    private static int convert(String encryptType) {
        if ("sm2".equalsIgnoreCase(encryptType)) {
            return SM2;
        }
        return 0;
    }

    @GetMapping(value={"/getBaseData"})
    @ApiOperation(value="\u83b7\u53d6\u52a0\u5bc6\u914d\u7f6e\u4fe1\u606f", notes="\u83b7\u53d6\u52a0\u5bc6\u914d\u7f6e\u4fe1\u606f")
    @Inner
    public ApiResponse<Map<String, Object>> getInitEncryptInfo() {
        SysBaseConfig signHand;
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean enableEncrypt = this.hussarSecureProperties.getEnabled();
        map.put("enableEncrypt", enableEncrypt);
        map.put("getEnable", this.getEncryptEnable);
        map.put("postEnable", this.postEncryptEnable);
        map.put("h_version", this.hussarConfig.getStaticVersion());
        map.put("tabSwitchover", this.globalService.isTabSwitchover());
        map.put("kaptcha", this.hussarLoginConfigService.getKaptchaOpen());
        map.put("totp", this.hussarLoginConfigService.getTotpOpen());
        map.put("standAlone", this.sysBaseConfigService.isNotRedis());
        map.put("tenantOpen", this.hussarTenantProperties.isEnabled());
        map.put("tenantType", this.hussarTenantProperties.getType());
        map.put("connName", HussarContextHolder.getConnName());
        map.put("headerTokenKey", this.hussarBaseOauth2SecurityProperties.getHeaderTokenKey());
        map.put("allowDisplacement", this.hussarBaseSecurityProperties.getAllowDisplacement());
        map.put("maxFileSize", this.multipartProperties.getMaxFileSize().toBytes());
        map.put("secureAssessment", this.secureAssesmentProperties.isOpen());
        map.put("headerTokenKey", this.hussarBaseOauth2SecurityProperties.getHeaderTokenKey());
        map.put("pinyinsyn", this.pinyinSynProperties.isOpen());
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("form_to_form");
        if (HussarUtils.isNotEmpty((Object)baseConfig)) {
            map.put("isShowFormToForm", "0".equals(baseConfig.getConfigValue()));
        }
        if (HussarUtils.isNotEmpty((Object)(signHand = this.sysBaseConfigService.getSysBaseConfig("sign_hand")))) {
            map.put("signHand", "0".equals(signHand.getConfigValue()));
        } else {
            map.put("signHand", false);
        }
        if (enableEncrypt) {
            EncryptSupportService encryptSupportService = (EncryptSupportService)SpringContextHolder.getBean(EncryptSupportService.class);
            EncryptDto initEncryptInfo = encryptSupportService.getInitEncryptInfo();
            if (HussarUtils.isBlank((CharSequence)initEncryptInfo.getFrontPriKey()) || HussarUtils.isBlank((CharSequence)initEncryptInfo.getBackendPubKey())) {
                logger.error("\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u83b7\u53d6\u7684\u4f20\u8f93\u52a0\u5bc6\u79d8\u94a5\u4e3a\u7a7a");
                throw new BaseException(BaseExceptionEnum.SERVER_EXCEPTION.getCode(), BaseExceptionEnum.SERVER_EXCEPTION.getMessage());
            }
            map.put("enabledEncryptSign", initEncryptInfo.isEnabledEncryptSign());
            map.put("headerEncrypt", initEncryptInfo.getHeaderEncrypt());
            map.put("hussarFP", initEncryptInfo.getFrontPriKey());
            map.put("hussarBP", initEncryptInfo.getBackendPubKey());
            map.put("enableEncryptCbcMode", initEncryptInfo.getEnableEncryptCbcMode());
        }
        map.put("appName", this.hussarBaseJobProperties.getAppName());
        PasswordEncryptDTO pwEncryptDTO = this.passwordEncryptService.getPasswordEncryptInfo();
        boolean enablePwEncryption = pwEncryptDTO.getEnabled();
        map.put("enablePwEncryption", enablePwEncryption);
        if (enablePwEncryption) {
            if (HussarUtils.isBlank((CharSequence)pwEncryptDTO.getEncryptKey())) {
                logger.error("\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u83b7\u53d6\u7684\u5bc6\u7801\u52a0\u5bc6\u79d8\u94a5\u4e3a\u7a7a");
                throw new BaseException(BaseExceptionEnum.SERVER_EXCEPTION.getCode(), BaseExceptionEnum.SERVER_EXCEPTION.getMessage());
            }
            map.put("hussarET", SystemBaseDataControler.convert(pwEncryptDTO.getEncryptType()));
            map.put("hussarEK", pwEncryptDTO.getEncryptKey());
        }
        if (this.sysBaseConfigService.getSysBaseConfig("isGreyScreen") != null) {
            SysBaseConfig sysBaseConfig = this.sysBaseConfigService.getSysBaseConfig("isGreyScreen");
            boolean isGreyScreen = "1".equals(sysBaseConfig.getConfigValue());
            map.put("isGreyScreen", isGreyScreen);
        } else {
            map.put("isGreyScreen", false);
        }
        SysBaseConfig orgInName = this.sysBaseConfigService.getSysBaseConfig("org_in_name");
        map.put("orgInName", orgInName != null ? orgInName.getConfigValue() : DEF_ORG_IN_NAME);
        SysBaseConfig orgOutName = this.sysBaseConfigService.getSysBaseConfig("org_out_name");
        map.put("orgOutName", orgOutName != null ? orgOutName.getConfigValue() : DEF_ORG_OUT_NAME);
        return ApiResponse.success(map);
    }
}

